﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace TestServerVoAI
{
    public class cVaxServerExCOM : cVaxServerCOM
    {
        public MainForm m_RefMainForm = null;

        public cVaxServerExCOM()
        {
        
        }

        ~cVaxServerExCOM()
        {

        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////////////

        public Boolean StartServer(int nListenPort)
        {
            StopServer();
                        
            if (!base.Initialize(""))
            {
                return false;
            }

            if (!base.OpenNetworkUDP("", nListenPort))
            {
                UnInitialize();
                return false;
            }

            base.SetListenPortRangeRTP(20000, 30000);

            base.AudioSessionLost(true, 30); // Enable voice session lost for 30 seconds.
            
            base.AddLine("AnonymousUDP", cVaxServerCOM.VAX_LINE_TYPE_UDP, "", "", "", "", "", "255.255.255.255", -1, "32");
            return true;
        }

        public void StopServer()
        {
            base.UnInitialize();
        }
                
        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////

        protected override void OnRegisterUser(string sUserName, string sDomain, string sUserAgent, string sFromIP, int nFromPort, ulong nRegId)
        {
            base.RemoveUser(sUserName);
            base.AddUser(sUserName, sUserName, "32"); // Only supported audio codecs 32  (G711u & G711a)

            AuthRegister(nRegId);

            string sMsg = "OnRegisterUser(" + sUserName + ")";
            m_RefMainForm.SetStatus(sMsg);
        }

        protected override void OnRegisterUserSuccess(string sUserName, string sFromIP, int nFromPort, ulong nRegId)
        {
            string sMsg = "OnRegisterUserSuccess(" + sUserName + ")";
            m_RefMainForm.SetStatus(sMsg);
        }

        protected override void OnRegisterUserFailed(string sUserName, string sFromIP, int nFromPort, ulong nRegId)
        {
            string sMsg = "OnRegisterUserFailed(" + sUserName + ")";
            m_RefMainForm.SetStatus(sMsg);
        }

        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////

        protected override void OnIncomingCall(ulong nSessionId, string sCallerName, string sCallerId, string sDialNo, int nFromPeerType, string sFromPeerName, string sUserAgent, string sFromIP, int nFromPort)
        {
            AdjustFunctionOpenAI(nSessionId); // Function Tools

            // base.InputTranscriptOpenAI(nSessionId, true, "", ""); // Activate with default model = "gpt-4o-transcribe" and noise_reduction = "near_field"
                                                                     // triggers event: OnVaxAudioInputTranscriptOpenAI()
            
            String sModelPrompt = "You are a FEMALE agent and must speak as a female. By default, respond in English. If the user speaks in another language, " +
                                  "automatically switch and respond in that same language. Use the provided tools when appropriate.";


            // https://platform.openai.com/audio/realtime


            String sKeyOpenAI = "YOUR-OPEN-AI-KEY";
            

            // base.ActivateSemanticVAD(nSessionId, ""); // Semantic VAD is activated by default
            // https://platform.openai.com/docs/guides/realtime-vad#server-vad

            String sModel = "gpt-realtime";
            //sModel = "gpt-realtime-mini";

            //shimmer, coral, marin, alloy

            base.AcceptCallSession(nSessionId, 30, sKeyOpenAI, sModelPrompt, sModel, "coral", 1.0);
        }

        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////

        protected override void OnVaxFunctionCallOpenAI(ulong nSessionId, string sFuncName, string sCallId, string[] aParamNames, string[] aParamValues)
        {
            if (string.Equals(sFuncName, "add_two_numbers", StringComparison.OrdinalIgnoreCase))
            {
                int nValueA = int.Parse(aParamValues[0]);
                int nValueB = int.Parse(aParamValues[1]);

                int nValueTotal = nValueA + nValueB;
                string sResult = nValueTotal.ToString();

                base.SendFunctionResultOpenAI(nSessionId, sCallId, sResult);
            }

            if (string.Equals(sFuncName, "DepartmentTalk", StringComparison.OrdinalIgnoreCase))
            {
                string sDeptName = aParamValues[0];

                base.SendFunctionResultOpenAI(nSessionId, sCallId, "Please wait Transfering");

                // base.SendReqTransferCallBlind(nSessionId, "7878");   // Send a call transfer request for incoming calls from an IP PBX..
            }
        }

        private void AdjustFunctionOpenAI(ulong nSessionId)
        {
            base.AddFunctionOpenAI(nSessionId, "add_two_numbers", "Add two numbers and return the result.");

            base.AddFunctionParamOpenAI(nSessionId, "add_two_numbers", "a", "First number to add");
            base.AddFunctionParamOpenAI(nSessionId, "add_two_numbers", "b", "Second number to add");

            //base.RemoveFunctionAllOpenAI(nSessionId);

            base.AddFunctionOpenAI(nSessionId, "DepartmentTalk", "The department the user wants to talk to. Expected values: 'sales' or 'technical support'");
            base.AddFunctionParamOpenAI(nSessionId, "DepartmentTalk", "Department", "Department Name");
        }

        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////

        protected override void OnCallSessionConnected(ulong nSessionId)
        {
            base.SendInputOpenAI(nSessionId, "Hello");  // Triggers the model to speak first.

            string sMsg = "OnCallSessionConnected()";
            m_RefMainForm.SetStatus(sMsg);
        }

        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////

        protected override void OnVaxAudioOutputTranscriptOpenAI(ulong nSessionId, string sTranscript)
        {
            m_RefMainForm.SetStatus(sTranscript);
        }
        protected override void OnVaxAudioInputTranscriptOpenAI(ulong nSessionId, string sTranscript)
        {
            m_RefMainForm.SetStatus(sTranscript);
        }

        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////

        protected override void OnLineRegisterTrying(string sLineName)
        {
            string sMsg = "OnLineRegisterTrying(" + sLineName + ")";
            m_RefMainForm.SetStatus(sMsg);
        }
        protected override void OnLineRegisterFailed(string sLineName, int nStatusCode, string sReasonPhrase)
        {
            string sMsg = "OnLineRegisterFailed(" + sLineName + ")";
            m_RefMainForm.SetStatus(sMsg);
        }
        protected override void OnLineRegisterSuccess(string sLineName)
        {
            string sMsg = "OnLineRegisterSuccess(" + sLineName + ")";
            m_RefMainForm.SetStatus(sMsg);
        }

        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////

        protected override void OnCallSessionConnecting(ulong nSessionId, int nStatusCode, String sReasonPhrase)
        {
            string sMsg = "OnCallSessionConnecting(" + sReasonPhrase + ")";
            m_RefMainForm.SetStatus(sMsg);
        }
        protected override void OnCallSessionFailed(ulong nSessionId, int nStatusCode, String sReasonPhrase, String sContact)
        {
            string sMsg = "OnCallSessionFailed(" + sReasonPhrase + ")";
            m_RefMainForm.SetStatus(sMsg);
        }
        
        protected override void OnCallSessionHangup(ulong nSessionId)
        {
            string sMsg = "OnCallSessionHangup()";
            m_RefMainForm.SetStatus(sMsg);
        }

        protected override void OnCallSessionTimeout(ulong nSessionId)
        {
            string sMsg = "OnCallSessionTimeout()";
            m_RefMainForm.SetStatus(sMsg);
        }

        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////
        protected override void OnCallSessionErrorLog(ulong nSessionId, int nErrorCode, String sErrorMsg)
        {
            string sMsg = "OnCallSessionErrorLog("+ sErrorMsg + ")";
            m_RefMainForm.SetStatus(sMsg);
        }

        protected override void OnVaxErrorLog(String sFuncName, int nErrorCode, String sErrorMsg)
        {
            string sMsg = "OnVaxErrorLog(" + sFuncName + ", " + sErrorMsg + ")";
            m_RefMainForm.SetStatus(sMsg);
        }

        protected override void OnVaxErrorOpenAI(ulong nSessionId, string sMsg)
        {
            string sErrorMsg = "OnVaxErrorOpenAI(" + sMsg + ")";

            m_RefMainForm.SetStatus(sErrorMsg);
        }
    }
}
