﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TestServerVoAI
{
    public partial class MainForm : Form
    {
        cVaxServerExCOM m_objServerSIP = new cVaxServerExCOM();

        public MainForm()
        {
            InitializeComponent();
            m_objServerSIP.m_RefMainForm = this;
        }

        private void BtnInit_Click(object sender, EventArgs e)
        {
            if (BtnStart.Text == "Stop")
            {
                m_objServerSIP.StopServer();
                
                SetStatus("Server stopped.");
                BtnStart.Text = "Start";
                return;
            }

             Boolean bResult = m_objServerSIP.StartServer(Convert.ToInt32(EditListenPort.Text));

            if (bResult == false)
            {
                SetStatus("Server is not running [Failed]");
                return;
            }
                        
            SetStatus("Server is running successfully.");
            BtnStart.Text = "Stop";
        }
                
        private void BtnAddLine_Click(object sender, EventArgs e)
        {
            // m_objServerSIP.AddLine("TestLine", cVaxServerCOM.VAX_LINE_TYPE_UDP, "", "", "7090", "7090", "", "192.168.0.119", 5060, "32"); //Only supported audio codecs 32(G711u & G711a)
            // m_objServerSIP.RegisterLine("TestLine", 1800);
        }

        public void SetStatus(string sStatus)
        {
            ListBoxStatus.Items.Add(sStatus);
        }

        private void BtnClearLog_Click(object sender, EventArgs e)
        {
            ListBoxStatus.Items.Clear();
        }
    }
}
