﻿Option Strict On
Option Explicit On

Imports System
Imports System.Collections
Imports System.Collections.Generic
Imports System.Linq
Imports System.Text
Imports System.IO
Imports System.Runtime.InteropServices
Imports System.Windows.Forms

Public Class cVaxServerExCOM
    Inherits cVaxServerCOM

    Public m_RefMainForm As MainForm = Nothing

    Public Sub New()
    End Sub

    Protected Overrides Sub Finalize()
        Try
        Finally
            MyBase.Finalize()
        End Try
    End Sub

    Public Function StartServer(ByVal nListenPort As Integer) As Boolean

        StopServer()

        If Not MyBase.Initialize("") Then Return False

        If Not MyBase.OpenNetworkUDP("", nListenPort) Then
            MyBase.UnInitialize()
            Return False
        End If

        MyBase.SetListenPortRangeRTP(20000, 30000)
        MyBase.AudioSessionLost(True, 30)

        MyBase.AddLine("AnonymousUDP", cVaxServerCOM.VAX_LINE_TYPE_UDP, "", "", "", "", "", "255.255.255.255", -1, "32")

        Return True

    End Function

    Public Sub StopServer()

        MyBase.UnInitialize()

    End Sub

    '//////////////////////////////////////////////////////////////////////////////
    '//////////////////////////////////////////////////////////////////////////////

    Protected Overrides Sub OnRegisterUser(ByVal sUserName As String, ByVal sDomain As String, ByVal sUserAgent As String, ByVal sFromIP As String, ByVal nFromPort As Integer, ByVal nRegId As ULong)

        MyBase.RemoveUser(sUserName)
        MyBase.AddUser(sUserName, sUserName, "32")

        AuthRegister(nRegId)

        m_RefMainForm.SetStatus("OnRegisterUser(" & sUserName & ")")

    End Sub

    Protected Overrides Sub OnRegisterUserSuccess(ByVal sUserName As String, ByVal sFromIP As String, ByVal nFromPort As Integer, ByVal nRegId As ULong)
        m_RefMainForm.SetStatus("OnRegisterUserSuccess(" & sUserName & ")")
    End Sub

    Protected Overrides Sub OnRegisterUserFailed(ByVal sUserName As String, ByVal sFromIP As String, ByVal nFromPort As Integer, ByVal nRegId As ULong)
        m_RefMainForm.SetStatus("OnRegisterUserFailed(" & sUserName & ")")
    End Sub

    '//////////////////////////////////////////////////////////////////////////////
    '//////////////////////////////////////////////////////////////////////////////

    Protected Overrides Sub OnIncomingCall(ByVal nSessionId As ULong, ByVal sCallerName As String, ByVal sCallerId As String, ByVal sDialNo As String, ByVal nFromPeerType As Integer, ByVal sFromPeerName As String, ByVal sUserAgent As String, ByVal sFromIP As String, ByVal nFromPort As Integer)

        AdjustFunctionOpenAI(nSessionId)  ' // Function Tools

        ' MyBase.InputTranscriptOpenAI(nSessionId, True, "", "")

        ' // Activate With Default model = "gpt-4o-transcribe" And noise_reduction = "near_field"
        ' // triggers event: OnVaxAudioInputTranscriptOpenAI()

        Dim sModelPrompt As String = "You are a FEMALE agent and must speak as a female. By default, respond in English. If the user speaks in another language, " &
                                     "automatically switch and respond in that same language. Use the provided tools when appropriate."

        'https://platform.openai.com/audio/realtime


        Dim sKeyOpenAI As String = "YOUR-OPEN-AI-KEY"


        'MyBase.ActivateSemanticVAD(nSessionId, "") 'Semantic VAD Is activated by default
        'https://platform.openai.com/docs/guides/realtime-vad#server-vad

        Dim sModel As String = "gpt-realtime"
        'sModel = "gpt-realtime-mini";

        'shimmer, coral, marin, alloy

        MyBase.AcceptCallSession(nSessionId, 30, sKeyOpenAI, sModelPrompt, sModel, "coral", 1.0)

    End Sub

    Protected Overrides Sub OnVaxFunctionCallOpenAI(ByVal nSessionId As ULong, ByVal sFuncName As String, ByVal sCallId As String, ByVal aParamNames As String(), ByVal aParamValues As String())

        If String.Equals(sFuncName, "add_two_numbers", StringComparison.OrdinalIgnoreCase) Then

            Dim nValueA As Integer = Integer.Parse(aParamValues(0))
            Dim nValueB As Integer = Integer.Parse(aParamValues(1))

            MyBase.SendFunctionResultOpenAI(nSessionId, sCallId, (nValueA + nValueB).ToString())

        End If

        If String.Equals(sFuncName, "DepartmentTalk", StringComparison.OrdinalIgnoreCase) Then
            MyBase.SendFunctionResultOpenAI(nSessionId, sCallId, "Please wait Transfering")
        End If

    End Sub

    Private Sub AdjustFunctionOpenAI(ByVal nSessionId As ULong)

        MyBase.AddFunctionOpenAI(nSessionId, "add_two_numbers", "Add two numbers and return the result.")
        MyBase.AddFunctionParamOpenAI(nSessionId, "add_two_numbers", "a", "First number to add")
        MyBase.AddFunctionParamOpenAI(nSessionId, "add_two_numbers", "b", "Second number to add")

        MyBase.AddFunctionOpenAI(nSessionId, "DepartmentTalk", "The department the user wants to talk to. Expected values: 'sales' or 'technical support'")
        MyBase.AddFunctionParamOpenAI(nSessionId, "DepartmentTalk", "Department", "Department Name")

    End Sub

    Protected Overrides Sub OnCallSessionConnected(ByVal nSessionId As ULong)

        MyBase.SendInputOpenAI(nSessionId, "Hello")
        m_RefMainForm.SetStatus("OnCallSessionConnected()")

    End Sub

    Protected Overrides Sub OnVaxAudioOutputTranscriptOpenAI(ByVal nSessionId As ULong, ByVal sTranscript As String)
        m_RefMainForm.SetStatus("OnVaxAudioOutputTranscriptOpenAI(" & sTranscript & ")")
    End Sub

    Protected Overrides Sub OnVaxAudioInputTranscriptOpenAI(ByVal nSessionId As ULong, ByVal sTranscript As String)
        m_RefMainForm.SetStatus("OnVaxAudioInputTranscriptOpenAI(" & sTranscript & ")")
    End Sub

    Protected Overrides Sub OnLineRegisterTrying(ByVal sLineName As String)
        m_RefMainForm.SetStatus("OnLineRegisterTrying(" & sLineName & ")")
    End Sub

    Protected Overrides Sub OnLineRegisterFailed(ByVal sLineName As String, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String)
        m_RefMainForm.SetStatus("OnLineRegisterFailed(" & sLineName & ")")
    End Sub

    Protected Overrides Sub OnLineRegisterSuccess(ByVal sLineName As String)
        m_RefMainForm.SetStatus("OnLineRegisterSuccess(" & sLineName & ")")
    End Sub

    Protected Overrides Sub OnCallSessionConnecting(ByVal nSessionId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String)
        m_RefMainForm.SetStatus("OnCallSessionConnecting(" & sReasonPhrase & ")")
    End Sub

    Protected Overrides Sub OnCallSessionFailed(ByVal nSessionId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String, ByVal sContact As String)
        m_RefMainForm.SetStatus("OnCallSessionFailed(" & sReasonPhrase & ")")
    End Sub

    Protected Overrides Sub OnCallSessionHangup(ByVal nSessionId As ULong)
        m_RefMainForm.SetStatus("OnCallSessionHangup()")
    End Sub

    Protected Overrides Sub OnCallSessionTimeout(ByVal nSessionId As ULong)
        m_RefMainForm.SetStatus("OnCallSessionTimeout()")
    End Sub

    Protected Overrides Sub OnCallSessionErrorLog(ByVal nSessionId As ULong, ByVal nErrorCode As Integer, ByVal sErrorMsg As String)
        m_RefMainForm.SetStatus("OnCallSessionErrorLog(" & sErrorMsg & ")")
    End Sub

    Protected Overrides Sub OnVaxErrorLog(ByVal sFuncName As String, ByVal nErrorCode As Integer, ByVal sErrorMsg As String)
        m_RefMainForm.SetStatus("OnVaxErrorLog(" & sFuncName & ", " & sErrorMsg & ")")
    End Sub

    Protected Overrides Sub OnVaxErrorOpenAI(ByVal nSessionId As ULong, ByVal sMsg As String)
        m_RefMainForm.SetStatus("OnVaxErrorOpenAI(" & sMsg & ")")
    End Sub

End Class


