﻿Option Strict On
Option Explicit On

Imports System
Imports System.Runtime.InteropServices
Imports VaxServerVoAILib

Public Class cVaxServerCOM

    Public Const SIP_DEFAULT_PORT As Integer = 5060

    Public Const VAX_PEER_TYPE_USER As Integer = 0
    Public Const VAX_PEER_TYPE_LINE As Integer = 1

    Public Const VAX_LINE_TYPE_UDP As Integer = 0
    Public Const VAX_LINE_TYPE_TCP As Integer = 1
    Public Const VAX_LINE_TYPE_TLS As Integer = 2

    Public Const VAX_REC_MUTE_TYPE_NONE As Integer = -1
    Public Const VAX_REC_MUTE_TYPE_SPEAK As Integer = 0
    Public Const VAX_REC_MUTE_TYPE_LISTEN As Integer = 1
    Public Const VAX_REC_MUTE_TYPE_BOTH As Integer = 2

    Public Const VAX_WAVE_REC_TYPE_MONO_PCM As Integer = 0
    Public Const VAX_WAVE_REC_TYPE_STEREO_PCM As Integer = 1
    Public Const VAX_WAVE_REC_TYPE_MONO_G711U As Integer = 2
    Public Const VAX_WAVE_REC_TYPE_STEREO_G711U As Integer = 3
    Public Const VAX_WAVE_REC_TYPE_MONO_G711A As Integer = 4
    Public Const VAX_WAVE_REC_TYPE_STEREO_G711A As Integer = 5

    Public Const VAX_DTMF_TYPE_RFC2833 As Integer = 0
    Public Const VAX_DTMF_TYPE_SIP_INFO As Integer = 1
    Public Const VAX_DTMF_TYPE_INBAND As Integer = 2

    Public Const VAX_PLAY_WAVE_MODE_EXCLUSIVE As Integer = 0
    Public Const VAX_PLAY_WAVE_MODE_MIXED As Integer = 1

    Public Const VAX_CODEC_G711A As Integer = 2
    Public Const VAX_CODEC_G711U As Integer = 3

    Public Const VAX_CODEC_TOTAL_COUNT As Integer = 2

    Public Const VAX_CUSTOM_HEADER_REQ_ID_INVITE As Integer = 0

    Public Const VAX_CLOSED_REASON_CODE_HANGUP As Integer = 0
    Public Const VAX_CLOSED_REASON_CODE_SESSION_LOST As Integer = 1
    Public Const VAX_CLOSED_REASON_CODE_MOVED As Integer = 2
    Public Const VAX_CLOSED_REASON_CODE_TRANSFERED As Integer = 3
    Public Const VAX_CLOSED_REASON_CODE_REJECTED As Integer = 4
    Public Const VAX_CLOSED_REASON_CODE_FAILED As Integer = 5
    Public Const VAX_CLOSED_REASON_CODE_CANCELLED As Integer = 6
    Public Const VAX_CLOSED_REASON_CODE_TIMEOUT As Integer = 7
    Public Const VAX_CLOSED_REASON_CODE_CLOSED As Integer = 8
    Public Const VAX_CLOSED_REASON_CODE_SEND_REDIRECT_RESPONSE As Integer = 9
    Public Const VAX_CLOSED_REASON_CODE_SEND_FAILURE_RESPONSE As Integer = 10

    Private ReadOnly m_objServerVoAI As ServerLibVoAI = New ServerLibVoAI()

    Public Sub New()

        AddHandler m_objServerVoAI.OnRegisterUser, AddressOf OnRegisterUser
        AddHandler m_objServerVoAI.OnRegisterUserSuccess, AddressOf OnRegisterUserSuccess
        AddHandler m_objServerVoAI.OnRegisterUserFailed, AddressOf OnRegisterUserFailed
        AddHandler m_objServerVoAI.OnUnRegisterUser, AddressOf OnUnRegisterUser

        AddHandler m_objServerVoAI.OnCallSessionCreated, AddressOf OnCallSessionCreated
        AddHandler m_objServerVoAI.OnCallSessionClosed, AddressOf OnCallSessionClosed

        AddHandler m_objServerVoAI.OnCallSessionConnecting, AddressOf OnCallSessionConnecting
        AddHandler m_objServerVoAI.OnCallSessionFailed, AddressOf OnCallSessionFailed
        AddHandler m_objServerVoAI.OnCallSessionConnected, AddressOf OnCallSessionConnected

        AddHandler m_objServerVoAI.OnIncomingCall, AddressOf OnIncomingCall

        AddHandler m_objServerVoAI.OnCallSessionLost, AddressOf OnCallSessionLost
        AddHandler m_objServerVoAI.OnCallSessionHangup, AddressOf OnCallSessionHangup
        AddHandler m_objServerVoAI.OnCallSessionTimeout, AddressOf OnCallSessionTimeout
        AddHandler m_objServerVoAI.OnCallSessionCancelled, AddressOf OnCallSessionCancelled

        AddHandler m_objServerVoAI.OnChatMessageText, AddressOf OnChatMessageText
        AddHandler m_objServerVoAI.OnChatMessageSuccess, AddressOf OnChatMessageSuccess
        AddHandler m_objServerVoAI.OnChatMessageFailed, AddressOf OnChatMessageFailed
        AddHandler m_objServerVoAI.OnChatMessageTimeout, AddressOf OnChatMessageTimeout

        AddHandler m_objServerVoAI.OnVaxFunctionCallOpenAI, AddressOf OnVaxFunctionCallOpenAI_Internal
        AddHandler m_objServerVoAI.OnVaxSessionUpdatedOpenAI, AddressOf OnVaxSessionUpdatedOpenAI

        AddHandler m_objServerVoAI.OnVaxAudioOutputTranscriptOpenAI, AddressOf OnVaxAudioOutputTranscriptOpenAI
        AddHandler m_objServerVoAI.OnVaxAudioInputTranscriptOpenAI, AddressOf OnVaxAudioInputTranscriptOpenAI

        AddHandler m_objServerVoAI.OnVaxResponseDoneUsageOpenAI, AddressOf OnVaxResponseDoneUsageOpenAI
        AddHandler m_objServerVoAI.OnVaxStatusOpenAI, AddressOf OnVaxStatusOpenAI
        AddHandler m_objServerVoAI.OnVaxErrorOpenAI, AddressOf OnVaxErrorOpenAI

        AddHandler m_objServerVoAI.OnLineRegisterTrying, AddressOf OnLineRegisterTrying
        AddHandler m_objServerVoAI.OnLineRegisterFailed, AddressOf OnLineRegisterFailed
        AddHandler m_objServerVoAI.OnLineRegisterSuccess, AddressOf OnLineRegisterSuccess
        AddHandler m_objServerVoAI.OnLineUnRegisterTrying, AddressOf OnLineUnRegisterTrying
        AddHandler m_objServerVoAI.OnLineUnRegisterFailed, AddressOf OnLineUnRegisterFailed
        AddHandler m_objServerVoAI.OnLineUnRegisterSuccess, AddressOf OnLineUnRegisterSuccess

        AddHandler m_objServerVoAI.OnAttackDetectedScanSIP, AddressOf OnAttackDetectedScanSIP
        AddHandler m_objServerVoAI.OnAttackDetectedFloodSIP, AddressOf OnAttackDetectedFloodSIP
        AddHandler m_objServerVoAI.OnAttackDetectedBruteForceSIP, AddressOf OnAttackDetectedBruteForceSIP

        AddHandler m_objServerVoAI.OnSendReqTransferCallTimeout, AddressOf OnSendReqTransferCallTimeout
        AddHandler m_objServerVoAI.OnSendReqTransferCallAccepted, AddressOf OnSendReqTransferCallAccepted
        AddHandler m_objServerVoAI.OnSendReqTransferCallFailed, AddressOf OnSendReqTransferCallFailed

        AddHandler m_objServerVoAI.OnServerConnectingREC, AddressOf OnServerConnectingREC
        AddHandler m_objServerVoAI.OnServerConnectedREC, AddressOf OnServerConnectedREC
        AddHandler m_objServerVoAI.OnServerFailedREC, AddressOf OnServerFailedREC
        AddHandler m_objServerVoAI.OnServerTimeoutREC, AddressOf OnServerTimeoutREC
        AddHandler m_objServerVoAI.OnServerHungupREC, AddressOf OnServerHungupREC

        AddHandler m_objServerVoAI.OnVaxVectorSearchStartedOpenAI, AddressOf OnVaxVectorSearchStartedOpenAI
        AddHandler m_objServerVoAI.OnVaxVectorSearchTryingOpenAI, AddressOf OnVaxVectorSearchTryingOpenAI
        AddHandler m_objServerVoAI.OnVaxVectorSearchSuccessOpenAI, AddressOf OnVaxVectorSearchSuccessOpenAI
        AddHandler m_objServerVoAI.OnVaxVectorSearchFailedOpenAI, AddressOf OnVaxVectorSearchFailedOpenAI

        AddHandler m_objServerVoAI.OnCallSessionErrorLog, AddressOf OnCallSessionErrorLog
        AddHandler m_objServerVoAI.OnVaxErrorLog, AddressOf OnVaxErrorLog

    End Sub

#Region "Methods"

    Public Function GetVaxErrorCode() As Integer
        Return m_objServerVoAI.GetVaxErrorCode()
    End Function

    Public Function GetVaxErrorText() As String
        Return m_objServerVoAI.GetVaxErrorText()
    End Function

    Public Function GetVersionFile() As String
        Return m_objServerVoAI.GetVersionFile()
    End Function

    Public Function GetVersionSDK() As String
        Return m_objServerVoAI.GetVersionSDK()
    End Function

    Public Sub SetLicenseKey(ByVal sLicenseKey As String)
        m_objServerVoAI.SetLicenseKey(sLicenseKey)
    End Sub

    Public Function Initialize(ByVal sDomainRealm As String) As Boolean
        Return m_objServerVoAI.Initialize(sDomainRealm)
    End Function

    Public Sub UnInitialize()
        m_objServerVoAI.UnInitialize()
    End Sub

    Public Function SetListenPortRangeRTP(ByVal nListenStartPort As Integer, ByVal nListenEndPort As Integer) As Boolean
        Return m_objServerVoAI.SetListenPortRangeRTP(nListenStartPort, nListenEndPort)
    End Function

    Public Function SetNetworkMediaRTP(ByVal sListenIP As String, ByVal nListenStartPort As Integer) As Boolean
        Return m_objServerVoAI.SetNetworkMediaRTP(sListenIP, nListenStartPort)
    End Function

    Public Function CryptoMediaNONE(ByVal bForced As Boolean) As Boolean
        Return m_objServerVoAI.CryptoMediaNONE(bForced)
    End Function

    Public Function CryptoMediaSDP(ByVal bForced As Boolean) As Boolean
        Return m_objServerVoAI.CryptoMediaSDP(bForced)
    End Function

    Public Function AddNetworkRouteSIP(ByVal sAssignedIP As String, ByVal sRouterIP As String) As Boolean
        Return m_objServerVoAI.AddNetworkRouteSIP(sAssignedIP, sRouterIP)
    End Function

    Public Function AddNetworkRouteRTP(ByVal sAssignedIP As String, ByVal sRouterIP As String) As Boolean
        Return m_objServerVoAI.AddNetworkRouteRTP(sAssignedIP, sRouterIP)
    End Function

    Public Function OpenNetworkUDP(ByVal sListenIP As String, ByVal nListenPort As Integer) As Boolean
        Return m_objServerVoAI.OpenNetworkUDP(sListenIP, nListenPort)
    End Function

    Public Function OpenNetworkTCP(ByVal sListenIP As String, ByVal nListenPort As Integer) As Boolean
        Return m_objServerVoAI.OpenNetworkTCP(sListenIP, nListenPort)
    End Function

    Public Function OpenNetworkTLS(ByVal sListenIP As String, ByVal nListenPort As Integer, ByVal sCertPEM As String) As Boolean
        Return m_objServerVoAI.OpenNetworkTLS(sListenIP, nListenPort, sCertPEM)
    End Function

    Public Sub CloseNetworkUDP()
        m_objServerVoAI.CloseNetworkUDP()
    End Sub

    Public Sub CloseNetworkTCP()
        m_objServerVoAI.CloseNetworkTCP()
    End Sub

    Public Sub CloseNetworkTLS()
        m_objServerVoAI.CloseNetworkTLS()
    End Sub

    Public Function AddUser(ByVal sUserName As String, ByVal sPassword As String, ByVal sAudioCodecList As String) As Boolean
        Return m_objServerVoAI.AddUser(sUserName, sPassword, sAudioCodecList)
    End Function

    Public Sub RemoveUser(ByVal sUserName As String)
        m_objServerVoAI.RemoveUser(sUserName)
    End Sub

    Public Function RegisterUserExpiry(ByVal nExpiry As Integer) As Boolean
        Return m_objServerVoAI.RegisterUserExpiry(nExpiry)
    End Function

    Public Function AttachRegister(ByVal nRegId As ULong, ByVal sUserName As String) As Boolean
        Return m_objServerVoAI.AttachRegister(nRegId, sUserName)
    End Function

    Public Function AcceptRegister(ByVal nRegId As ULong) As Boolean
        Return m_objServerVoAI.AcceptRegister(nRegId)
    End Function

    Public Function RejectRegister(ByVal nRegId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String) As Boolean
        Return m_objServerVoAI.RejectRegister(nRegId, nStatusCode, sReasonPhrase)
    End Function

    Public Function AuthRegister(ByVal nRegId As ULong) As Boolean
        Return m_objServerVoAI.AuthRegister(nRegId)
    End Function

    Public Function AddLine(ByVal sLineName As String, ByVal nLineType As Integer, ByVal sDisplayName As String, ByVal sUserName As String, ByVal sAuthLogin As String, ByVal sAuthPwd As String, ByVal sDomainRealm As String, ByVal sServerAddr As String, ByVal nServerPort As Integer, ByVal sAudioCodecList As String) As Boolean
        Return m_objServerVoAI.AddLine(sLineName, nLineType, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort, sAudioCodecList)
    End Function

    Public Sub RemoveLine(ByVal sLineName As String)
        m_objServerVoAI.RemoveLine(sLineName)
    End Sub

    Public Function RegisterLine(ByVal sLineName As String, ByVal nExpire As Integer) As Boolean
        Return m_objServerVoAI.RegisterLine(sLineName, nExpire)
    End Function

    Public Function UnRegisterLine(ByVal sLineName As String) As Boolean
        Return m_objServerVoAI.UnRegisterLine(sLineName)
    End Function

    Public Function AcceptCallSession(ByVal nSessionId As ULong, ByVal nTimeout As Integer, ByVal sKeyOpenAI As String, ByVal sPrompt As String, ByVal sModel As String, ByVal sVoice As String, ByVal fOutputAudioSpeed As Double) As Boolean

        Return m_objServerVoAI.AcceptCallSession(nSessionId, nTimeout, sKeyOpenAI, sPrompt, sModel, sVoice, fOutputAudioSpeed)
    End Function

    Public Function RejectCallSession(ByVal nSessionId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String) As Boolean
        Return m_objServerVoAI.RejectCallSession(nSessionId, nStatusCode, sReasonPhrase)
    End Function

    Public Function CloseCallSession(ByVal nSessionId As ULong) As Boolean
        Return m_objServerVoAI.CloseCallSession(nSessionId)
    End Function

    Public Function DialCallSession(sCallerName As String, sCallerId As String, sDialNo As String, sToPeerName As String, nTimeout As Integer) As ULong
        Return m_objServerVoAI.DialCallSession(sCallerName, sCallerId, sDialNo, sToPeerName, nTimeout)
    End Function

    Public Function CallSessionSendStatusResponse(ByVal nSessionId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String, ByVal sContactURI As String) As Boolean
        Return m_objServerVoAI.CallSessionSendStatusResponse(nSessionId, nStatusCode, sReasonPhrase, sContactURI)
    End Function

    Public Function SendReqTransferCallBlind(ByVal nSessionId As ULong, ByVal sToUserName As String) As Boolean
        Return m_objServerVoAI.SendReqTransferCallBlind(nSessionId, sToUserName)
    End Function

    Public Function SendReqTransferCallConsult(ByVal nSessionId As ULong, ByVal nToSessionId As ULong) As Boolean
        Return m_objServerVoAI.SendReqTransferCallConsult(nSessionId, nToSessionId)
    End Function

    Public Function AcceptChatMessage(ByVal nChatMsgId As ULong, ByVal sToPeerName As String) As Boolean
        Return m_objServerVoAI.AcceptChatMessage(nChatMsgId, sToPeerName)
    End Function

    Public Sub RejectChatMessage(ByVal nChatMsgId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String)
        m_objServerVoAI.RejectChatMessage(nChatMsgId, nStatusCode, sReasonPhrase)
    End Sub

    Public Function SendChatMessageText(ByVal sMsgFrom As String, ByVal sMsgTo As String, ByVal sMsgText As String, ByVal sToPeerName As String) As ULong
        Return m_objServerVoAI.SendChatMessageText(sMsgFrom, sMsgTo, sMsgText, sToPeerName)
    End Function

    Public Function AudioSessionLost(ByVal bEnable As Boolean, ByVal nTimeout As Integer) As Boolean
        Return m_objServerVoAI.AudioSessionLost(bEnable, nTimeout)
    End Function

    Public Function SetUserAgentName(ByVal sName As String) As Boolean
        Return m_objServerVoAI.SetUserAgentName(sName)
    End Function

    Public Function GetUserAgentName() As String
        Return m_objServerVoAI.GetUserAgentName()
    End Function

    Public Function SetSessionNameSDP(ByVal sName As String) As Boolean
        Return m_objServerVoAI.SetSessionNameSDP(sName)
    End Function

    Public Function GetSessionNameSDP() As String
        Return m_objServerVoAI.GetSessionNameSDP()
    End Function

    Public Function SendDigitDTMF(ByVal nSessionId As ULong, ByVal sDigitDTMF As String, ByVal nTypeDTMF As Integer) As Boolean
        Return m_objServerVoAI.SendDigitDTMF(nSessionId, sDigitDTMF, nTypeDTMF)
    End Function

    Public Function DetectDigitDTMF(ByVal nSessionId As ULong, ByVal nTypeDTMF As Integer, ByVal bEnable As Boolean, ByVal nMilliSecTimeout As Integer) As Boolean
        Return m_objServerVoAI.DetectDigitDTMF(nSessionId, nTypeDTMF, bEnable, nMilliSecTimeout)
    End Function

    Public Function ActivateSemanticVAD(ByVal nSessionId As ULong, ByVal sEagerness As String) As Boolean
        Return m_objServerVoAI.ActivateSemanticVAD(nSessionId, sEagerness)
    End Function

    Public Function ActivateAcousticVAD(ByVal nSessionId As ULong, ByVal fThreshold As Double, ByVal nPrefixPadding As Integer, ByVal nSilenceDuration As Integer) As Boolean
        Return m_objServerVoAI.ActivateAcousticVAD(nSessionId, fThreshold, nPrefixPadding, nSilenceDuration)
    End Function

    Public Function UpdateSessionOpenAI(ByVal nSessionId As ULong, ByVal sPrompt As String, ByVal fOutputAudioSpeed As Double) As Boolean
        Return m_objServerVoAI.UpdateSessionOpenAI(nSessionId, sPrompt, fOutputAudioSpeed)
    End Function

    Public Function SendInputOpenAI(ByVal nSessionId As ULong, ByVal sInput As String) As Boolean
        Return m_objServerVoAI.SendInputOpenAI(nSessionId, sInput)
    End Function

    Public Function AddFunctionOpenAI(ByVal nSessionId As ULong, ByVal sFuncName As String, ByVal sFuncDesc As String) As Boolean
        Return m_objServerVoAI.AddFunctionOpenAI(nSessionId, sFuncName, sFuncDesc)
    End Function

    Public Sub RemoveFunctionOpenAI(ByVal nSessionId As ULong, ByVal sFuncName As String)
        m_objServerVoAI.RemoveFunctionOpenAI(nSessionId, sFuncName)
    End Sub

    Public Sub RemoveFunctionAllOpenAI(ByVal nSessionId As ULong)
        m_objServerVoAI.RemoveFunctionAllOpenAI(nSessionId)
    End Sub

    Public Function AddFunctionParamOpenAI(ByVal nSessionId As ULong, ByVal sFuncName As String, ByVal sParamName As String, ByVal sParamDesc As String) As Boolean
        Return m_objServerVoAI.AddFunctionParamOpenAI(nSessionId, sFuncName, sParamName, sParamDesc)
    End Function

    Public Function AddFunctionParamEnumOpenAI(ByVal nSessionId As ULong, ByVal sFuncName As String, ByVal sParamName As String, ByVal sEnumValue As String) As Boolean
        Return m_objServerVoAI.AddFunctionParamEnumOpenAI(nSessionId, sFuncName, sParamName, sEnumValue)
    End Function

    Public Function SendFunctionResultOpenAI(ByVal nSessionId As ULong, ByVal sCallId As String, ByVal sOutput As String) As Boolean
        Return m_objServerVoAI.SendFunctionResultOpenAI(nSessionId, sCallId, sOutput)
    End Function

    Public Function AttackDetectScanSIP(ByVal sDomainName As String) As Boolean
        Return m_objServerVoAI.AttackDetectScanSIP(sDomainName)
    End Function

    Public Function AttackDetectFloodSIP(ByVal nReqRecvLimit As Integer) As Boolean
        Return m_objServerVoAI.AttackDetectFloodSIP(nReqRecvLimit)
    End Function

    Public Function AttackDetectBruteForceSIP(ByVal nFailureCount As Integer, ByVal nFailureInterval As Integer) As Boolean
        Return m_objServerVoAI.AttackDetectBruteForceSIP(nFailureCount, nFailureInterval)
    End Function

    Public Function CallSessionMuteVoice(ByVal nSessionId As ULong, ByVal bListen As Boolean, ByVal bSpeak As Boolean) As Boolean
        Return m_objServerVoAI.CallSessionMuteVoice(nSessionId, bListen, bSpeak)
    End Function

    Public Function SetExtDataREC(ByVal nSessionId As ULong, ByVal sExtData As String) As Boolean
        Return m_objServerVoAI.SetExtDataREC(nSessionId, sExtData)
    End Function

    Public Function ConnectToServerREC(ByVal nSessionId As ULong,
                                       ByVal sCallerName As String,
                                       ByVal sCallerId As String,
                                       ByVal sDialNo As String,
                                       ByVal sToPeerName As String,
                                       ByVal nTimeout As Integer) As Boolean

        Return m_objServerVoAI.ConnectToServerREC(nSessionId, sCallerName, sCallerId, sDialNo, sToPeerName, nTimeout)
    End Function

    Public Function MuteCallServerREC(ByVal nSessionId As ULong, ByVal nMuteType As Integer) As Boolean
        Return m_objServerVoAI.MuteCallServerREC(nSessionId, nMuteType)
    End Function

    Public Function GetUserAgentNameCall(ByVal nSessionId As ULong) As String
        Return m_objServerVoAI.GetUserAgentNameCall(nSessionId)
    End Function

    Public Function AddVectorStoreSearchOpenAI(ByVal nSessionId As ULong,
                                               ByVal sSearchName As String,
                                               ByVal sSearchDesc As String,
                                               ByVal sVectorStoreId As String,
                                               ByVal sFilters As String,
                                               ByVal nMaxNoResults As Integer) As Boolean

        Return m_objServerVoAI.AddVectorStoreSearchOpenAI(nSessionId, sSearchName, sSearchDesc, sVectorStoreId, sFilters, nMaxNoResults)
    End Function

    Public Sub RemoveVectorStoreSearchOpenAI(ByVal nSessionId As ULong, ByVal sSearchName As String)
        m_objServerVoAI.RemoveVectorStoreSearchOpenAI(nSessionId, sSearchName)
    End Sub

    Public Sub RemoveVectorStoreSearchAllOpenAI(ByVal nSessionId As ULong)
        m_objServerVoAI.RemoveVectorStoreSearchAllOpenAI(nSessionId)
    End Sub

    Public Function InputTranscriptOpenAI(nSessionId As ULong, bActivate As Boolean, sModel As String, sNoiseReduction As String) As Boolean
        Return m_objServerVoAI.InputTranscriptOpenAI(nSessionId, bActivate, sModel, sNoiseReduction)
    End Function


#End Region

#Region "Events"

    Protected Overridable Sub OnRegisterUser(ByVal sUserName As String, ByVal sDomain As String, ByVal sUserAgent As String, ByVal sFromIP As String, ByVal nFromPort As Integer, ByVal nRegId As ULong)
    End Sub

    Protected Overridable Sub OnRegisterUserSuccess(ByVal sUserName As String, ByVal sFromIP As String, ByVal nFromPort As Integer, ByVal nRegId As ULong)
    End Sub

    Protected Overridable Sub OnRegisterUserFailed(ByVal sUserName As String, ByVal sFromIP As String, ByVal nFromPort As Integer, ByVal nRegId As ULong)
    End Sub

    Protected Overridable Sub OnUnRegisterUser(ByVal sUserName As String)
    End Sub

    Protected Overridable Sub OnCallSessionCreated(ByVal nSessionId As ULong, ByVal nReasonCode As Integer)
    End Sub

    Protected Overridable Sub OnCallSessionClosed(ByVal nSessionId As ULong, ByVal nReasonCode As Integer)
    End Sub

    Protected Overridable Sub OnCallSessionConnecting(ByVal nSessionId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String)
    End Sub

    Protected Overridable Sub OnCallSessionFailed(ByVal nSessionId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String, ByVal sContact As String)
    End Sub

    Protected Overridable Sub OnCallSessionConnected(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnIncomingCall(ByVal nSessionId As ULong,
                                             ByVal sCallerName As String,
                                             ByVal sCallerId As String,
                                             ByVal sDialNo As String,
                                             ByVal nFromPeerType As Integer,
                                             ByVal sFromPeerName As String,
                                             ByVal sUserAgent As String,
                                             ByVal sFromIP As String,
                                             ByVal nFromPort As Integer)
    End Sub

    Protected Overridable Sub OnCallSessionLost(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnCallSessionHangup(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnCallSessionTimeout(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnCallSessionCancelled(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnChatMessageText(ByVal nChatMsgId As ULong,
                                                ByVal sMsgFrom As String,
                                                ByVal sMsgTo As String,
                                                ByVal sMsgText As String,
                                                ByVal nFromPeerType As Integer,
                                                ByVal sFromPeerName As String,
                                                ByVal sFromIP As String,
                                                ByVal nFromPort As Integer)
    End Sub

    Protected Overridable Sub OnChatMessageSuccess(ByVal nChatMsgId As ULong)
    End Sub

    Protected Overridable Sub OnChatMessageFailed(ByVal nChatMsgId As ULong, ByVal nStatusId As Integer, ByVal sReasonPhrase As String)
    End Sub

    Protected Overridable Sub OnChatMessageTimeout(ByVal nChatMsgId As ULong)
    End Sub

    Private Sub OnVaxFunctionCallOpenAI_Internal(ByVal nSessionId As ULong,
                                                 ByVal sFuncName As String,
                                                 ByVal sCallId As String,
                                                 ByVal aParamNames As System.Array,
                                                 ByVal aParamValues As System.Array)

        Dim aNames As String() = Nothing
        Dim aValues As String() = Nothing

        If aParamNames IsNot Nothing Then
            Dim nLength As Integer = aParamNames.Length
            aNames = New String(nLength - 1) {}
            For nCount As Integer = 0 To nLength - 1
                aNames(nCount) = TryCast(aParamNames.GetValue(nCount), String)
            Next
        End If

        If aParamValues IsNot Nothing Then
            Dim nLength As Integer = aParamValues.Length
            aValues = New String(nLength - 1) {}
            For nCount As Integer = 0 To nLength - 1
                aValues(nCount) = TryCast(aParamValues.GetValue(nCount), String)
            Next
        End If

        OnVaxFunctionCallOpenAI(nSessionId, sFuncName, sCallId, aNames, aValues)
    End Sub

    Protected Overridable Sub OnVaxFunctionCallOpenAI(ByVal nSessionId As ULong,
                                                      ByVal sFuncName As String,
                                                      ByVal sCallId As String,
                                                      ByVal aParamNames As String(),
                                                      ByVal aParamValues As String())
    End Sub

    Protected Overridable Sub OnVaxSessionUpdatedOpenAI(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnVaxAudioOutputTranscriptOpenAI(ByVal nSessionId As ULong, ByVal sTranscript As String)
    End Sub

    Protected Overridable Sub OnVaxAudioInputTranscriptOpenAI(ByVal nSessionId As ULong, ByVal sTranscript As String)
    End Sub

    Protected Overridable Sub OnVaxResponseDoneUsageOpenAI(ByVal nSessionId As ULong, ByVal nTotalTokens As Integer, ByVal nInputTokens As Integer, ByVal nOutputTokens As Integer)
    End Sub

    Protected Overridable Sub OnVaxStatusOpenAI(ByVal nSessionId As ULong, ByVal nStatusId As Integer, ByVal sStatus As String)
    End Sub

    Protected Overridable Sub OnVaxErrorOpenAI(ByVal nSessionId As ULong, ByVal sMsg As String)
    End Sub

    Protected Overridable Sub OnLineRegisterTrying(ByVal sLineName As String)
    End Sub

    Protected Overridable Sub OnLineRegisterFailed(ByVal sLineName As String, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String)
    End Sub

    Protected Overridable Sub OnLineRegisterSuccess(ByVal sLineName As String)
    End Sub

    Protected Overridable Sub OnLineUnRegisterTrying(ByVal sLineName As String)
    End Sub

    Protected Overridable Sub OnLineUnRegisterFailed(ByVal sLineName As String, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String)
    End Sub

    Protected Overridable Sub OnLineUnRegisterSuccess(ByVal sLineName As String)
    End Sub

    Protected Overridable Sub OnAttackDetectedScanSIP(ByVal sReqMethod As String, ByVal sAddrIP As String, ByVal nAddrPort As Integer, ByVal nAddrType As Integer)
    End Sub

    Protected Overridable Sub OnAttackDetectedFloodSIP(ByVal sAddrIP As String, ByVal nAddrPort As Integer, ByVal nAddrType As Integer)
    End Sub

    Protected Overridable Sub OnAttackDetectedBruteForceSIP(ByVal sReqMethod As String, ByVal nAuthFailureCount As Integer, ByVal sAddrIP As String, ByVal nAddrPort As Integer, ByVal nAddrType As Integer)
    End Sub

    Protected Overridable Sub OnSendReqTransferCallTimeout(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnSendReqTransferCallAccepted(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnSendReqTransferCallFailed(ByVal nSessionId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String)
    End Sub

    Protected Overridable Sub OnServerConnectingREC(ByVal nSessionId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String)
    End Sub

    Protected Overridable Sub OnServerConnectedREC(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnServerFailedREC(ByVal nSessionId As ULong, ByVal nStatusCode As Integer, ByVal sReasonPhrase As String)
    End Sub

    Protected Overridable Sub OnServerTimeoutREC(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnServerHungupREC(ByVal nSessionId As ULong)
    End Sub

    Protected Overridable Sub OnVaxVectorSearchStartedOpenAI(ByVal nSessionId As ULong, ByVal sSearchName As String, ByVal sQuery As String)
    End Sub

    Protected Overridable Sub OnVaxVectorSearchTryingOpenAI(ByVal nSessionId As ULong, ByVal sSearchName As String)
    End Sub

    Protected Overridable Sub OnVaxVectorSearchSuccessOpenAI(ByVal nSessionId As ULong, ByVal sSearchName As String, ByVal sContent As String)
    End Sub

    Protected Overridable Sub OnVaxVectorSearchFailedOpenAI(ByVal nSessionId As ULong, ByVal sSearchName As String, ByVal sMsg As String)
    End Sub

    Protected Overridable Sub OnCallSessionErrorLog(ByVal nSessionId As ULong, ByVal nErrorCode As Integer, ByVal sErrorMsg As String)
    End Sub

    Protected Overridable Sub OnVaxErrorLog(ByVal sFuncName As String, ByVal nErrorCode As Integer, ByVal sErrorMsg As String)
    End Sub

#End Region

End Class
