unit MainFormDlg;

interface

uses
  Winapi.Windows, Winapi.Messages,
  System.SysUtils, System.Variants, System.Classes,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  Vcl.ComCtrls, Vcl.OleServer,
  Vcl.StdCtrls;

Type

  TMainForm = class(TForm)

  GroupBoxSettings: TGroupBox;
  LabelListenPort: TLabel;
  EditListenPort: TEdit;

  BtnStart: TButton;
  BtnAddLine: TButton;

  ListBoxStatus: TListBox;
  BtnClearLog: TButton;

  procedure OnCreate(Sender: TObject);
  procedure OnClose(Sender: TObject; var Action: TCloseAction);

  procedure SetStatus(const sStatus: String);

  procedure BtnClearLogClick(Sender: TObject);
  procedure BtnStartClick(Sender: TObject);
  procedure BtnAddLineClick(Sender: TObject);

end;

var
  MainForm: TMainForm;

implementation

uses
  VaxServerExCOM;

var
  m_pVaxCOM : TVaxServerExCOM;

{$R *.dfm}

  procedure TMainForm.OnCreate(Sender: TObject);
  begin

    m_pVaxCOM := TVaxServerExCOM.Create(Self);

  end;


  procedure TMainForm.BtnStartClick(Sender: TObject);
  var
    nListenPort: Integer;
    bResult: Boolean;
  begin

    if BtnStart.Caption = 'Stop' then
    begin
      m_pVaxCOM.StopServer;

      SetStatus('Server stopped.');
      BtnStart.Caption := 'Start';

      Exit;
    end;

    nListenPort := StrToInt(EditListenPort.Text);
    bResult := m_pVaxCOM.StartServer(nListenPort);

    if not bResult then
    begin
      SetStatus('Server is not running [Failed]');
      Exit;
    end;

    SetStatus('Server is running successfully.');
    BtnStart.Caption := 'Stop';

  end;


  procedure TMainForm.BtnAddLineClick(Sender: TObject);
  begin
     m_pVaxCOM.AddLine('TestLine', TVaxServerExCOM.VAX_LINE_TYPE_UDP, '', '', '7090', '7090', '', '192.168.0.119', 5060, '32'); //Only supported audio codecs 32(G711u & G711a)
     m_pVaxCOM.RegisterLine('TestLine', 1800);
  end;

  procedure TMainForm.BtnClearLogClick(Sender: TObject);
  begin
     ListBoxStatus.Clear();
  end;


  procedure TMainForm.SetStatus(const sStatus: String);
  begin
    ListBoxStatus.Items.Add(sStatus);
  end;


  procedure TMainForm.OnClose(Sender: TObject; var Action: TCloseAction);
  begin
    m_pVaxCOM.StopServer();
  end;

end.
