unit VaxServerCOM;

Interface

uses
    Classes, ComObj,
    Vcl.OleCtrls, Vcl.ComCtrls,
    Vcl.Forms, Vcl.OleServer,
    VaxServerVoAILib_TLB;

type TVaxServerCOM = class(TServerLibVoAI)

  public

  const SIP_DEFAULT_PORT = 5060;

  ///////////////////////////////////////////////////////////

  const VAX_LINE_TYPE_UDP = 0;
  const VAX_LINE_TYPE_TCP = 1;
  const VAX_LINE_TYPE_TLS = 2;

  ///////////////////////////////////////////////////////////

  const VAX_REC_MUTE_TYPE_NONE = -1;
  const VAX_REC_MUTE_TYPE_SPEAK = 0;
  const VAX_REC_MUTE_TYPE_LISTEN = 1;
  const VAX_REC_MUTE_TYPE_BOTH = 2;

  ///////////////////////////////////////////////////////////

  const VAX_WAVE_REC_TYPE_MONO_PCM = 0;
  const VAX_WAVE_REC_TYPE_STEREO_PCM = 1;
  const VAX_WAVE_REC_TYPE_MONO_G711U = 2;
  const VAX_WAVE_REC_TYPE_STEREO_G711U = 3;
  const VAX_WAVE_REC_TYPE_MONO_G711A = 4;
  const VAX_WAVE_REC_TYPE_STEREO_G711A = 5;

  ///////////////////////////////////////////////////////////

  const VAX_DTMF_TYPE_RFC2833 = 0;
  const VAX_DTMF_TYPE_SIP_INFO = 1;
  const VAX_DTMF_TYPE_INBAND = 2;

  const VAX_PLAY_WAVE_MODE_EXCLUSIVE = 0;
  const VAX_PLAY_WAVE_MODE_MIXED = 1;

  const VAX_CODEC_G711A = 2;
  const VAX_CODEC_G711U = 3;

  const VAX_CODEC_TOTAL_COUNT = 2;

  ///////////////////////////////////////////////////////////

  const VAX_CUSTOM_HEADER_REQ_ID_INVITE = 0;

  ///////////////////////////////////////////////////////////

  const VAX_CLOSED_REASON_CODE_HANGUP = 0;
  const VAX_CLOSED_REASON_CODE_SESSION_LOST = 1;
  const VAX_CLOSED_REASON_CODE_MOVED = 2;
  const VAX_CLOSED_REASON_CODE_TRANSFERED = 3;
  const VAX_CLOSED_REASON_CODE_REJECTED = 4;
  const VAX_CLOSED_REASON_CODE_FAILED = 5;
  const VAX_CLOSED_REASON_CODE_CANCELLED = 6;
  const VAX_CLOSED_REASON_CODE_TIMEOUT = 7;
  const VAX_CLOSED_REASON_CODE_CLOSED = 8;
  const VAX_CLOSED_REASON_CODE_SEND_REDIRECT_RESPONSE = 9;
  const VAX_CLOSED_REASON_CODE_SEND_FAILURE_RESPONSE = 10;

  /////////////////////////////////////////////////////////

  const VAX_ERROR_LOAD_COM_MSG_A = 'Unable to load VaxServerVoAI.dll COM component.';
  const VAX_ERROR_LOAD_COM_MSG_B = 'Please run command prompt as administrator.';
  const VAX_ERROR_LOAD_COM_MSG_C = 'Register the COM using regsvr32 command and try again.';
  const VAX_ERROR_LOAD_COM_MSG_D = 'e.g. regsvr32 VaxServerVoAI.dll';

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  public

    constructor Create(); reintroduce; overload;

    function GetVaxErrorCode: Integer;
    function GetVaxErrorText: String;
    function GetVersionFile: String;
    function GetVersionSDK: String;

    procedure SetLicenseKey(sLicenseKey: String);
    function Initialize(sDomainRealm: String): Boolean;
    procedure UnInitialize;

    function SetListenPortRangeRTP(nListenStartPort: Integer; nListenEndPort: Integer): Boolean;
    function SetNetworkMediaRTP(sListenIP: String; nListenStartPort: Integer): Boolean;

    function CryptoMediaNONE(bForced: Boolean): Boolean;
    function CryptoMediaSDP(bForced: Boolean): Boolean;

    function AddNetworkRouteSIP(sAssignedIP: String; sRouterIP: String): Boolean;
    function AddNetworkRouteRTP(sAssignedIP: String; sRouterIP: String): Boolean;

    function OpenNetworkUDP(sListenIP: String; nListenPort: Integer): Boolean;
    function OpenNetworkTCP(sListenIP: String; nListenPort: Integer): Boolean;
    function OpenNetworkTLS(sListenIP: String; nListenPort: Integer; sCertPEM: String): Boolean;

    procedure CloseNetworkUDP;
    procedure CloseNetworkTCP;
    procedure CloseNetworkTLS;

    function AddUser(sUserName: String; sPassword: String; sAudioCodecList: String): Boolean;
    procedure RemoveUser(sUserName: String);
    function RegisterUserExpiry(nExpiry: Integer): Boolean;
    function AttachRegister(nRegId: UInt64; sUserName: String): Boolean;
    function AcceptRegister(nRegId: UInt64): Boolean;
    function RejectRegister(nRegId: UInt64; nStatusCode: Integer; sReasonPhrase: String): Boolean;
    function AuthRegister(nRegId: UInt64): Boolean;

    function AddLine(sLineName: String; nLineType: Integer; sDisplayName: String; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer; sAudioCodecList: String): Boolean;
    procedure RemoveLine(sLineName: String);
    function RegisterLine(sLineName: String; nExpire: Integer): Boolean;
    function UnRegisterLine(sLineName: String): Boolean;

    function AcceptCallSession(nSessionId: UInt64; nTimeout: Integer; sKeyOpenAI: String; sPrompt: String; sModel: String; sVoice: String; fOutputAudioSpeed: Double): Boolean;
    function RejectCallSession(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String): Boolean;
    function CloseCallSession(nSessionId: UInt64): Boolean;

    function DialCallSession(sCallerName: String; sCallerId: String; sDialNo: String; sToPeerName: String; nTimeout: Integer): UInt64;
    function CallSessionSendStatusResponse(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String; sContactURI: String): Boolean;

    function SendReqTransferCallBlind(nSessionId: UInt64; sToUserName: String): Boolean;
    function SendReqTransferCallConsult(nSessionId: UInt64; nToSessionId: UInt64): Boolean;

    function AcceptChatMessage(nChatMsgId: UInt64; sToPeerName: String): Boolean;
    procedure RejectChatMessage(nChatMsgId: UInt64; nStatusCode: Integer; sReasonPhrase: String);
    function SendChatMessageText(sMsgFrom: String; sMsgTo: String; sMsgText: String; sToPeerName: String): UInt64;

    function AudioSessionLost(bEnable: Boolean; nTimeout: Integer): Boolean;

    function SetUserAgentName(sName: String): Boolean;
    function GetUserAgentName: String;
    function SetSessionNameSDP(sName: String): Boolean;
    function GetSessionNameSDP: String;

    function SendDigitDTMF(nSessionId: UInt64; sDigitDTMF: String; nTypeDTMF: Integer): Boolean;
    function DetectDigitDTMF(nSessionId: UInt64; nTypeDTMF: Integer; bEnable: Boolean; nMilliSecTimeout: Integer): Boolean;

    function ActivateSemanticVAD(nSessionId: UInt64; sEagerness: String): Boolean;
    function ActivateAcousticVAD(nSessionId: UInt64; fThreshold: Double; nPrefixPadding: Integer; nSilenceDuration: Integer): Boolean;

    function UpdateSessionOpenAI(nSessionId: UInt64; sPrompt: String; fOutputAudioSpeed: Double): Boolean;
    function SendInputOpenAI(nSessionId: UInt64; sInput: String): Boolean;
    function AddFunctionOpenAI(nSessionId: UInt64; sFuncName: String; sFuncDesc: String): Boolean;
    procedure RemoveFunctionOpenAI(nSessionId: UInt64; sFuncName: String);
    procedure RemoveFunctionAllOpenAI(nSessionId: UInt64);
    function AddFunctionParamOpenAI(nSessionId: UInt64; sFuncName: String; sParamName: String; sParamDesc: String): Boolean;
    function AddFunctionParamEnumOpenAI(nSessionId: UInt64; sFuncName: String; sParamName: String; sEnumValue: String): Boolean;
    function SendFunctionResultOpenAI(nSessionId: UInt64; sCallId: String; sOutput: String): Boolean;

    function AttackDetectScanSIP(sDomainName: String): Boolean;
    function AttackDetectFloodSIP(nReqRecvLimit: Integer): Boolean;
    function AttackDetectBruteForceSIP(nFailureCount: Integer; nFailureInterval: Integer): Boolean;

    function CallSessionMuteVoice(nSessionId: UInt64; bListen: Boolean; bSpeak: Boolean): Boolean;
    function SetExtDataREC(nSessionId: UInt64; sExtData: String): Boolean;
    function ConnectToServerREC(nSessionId: UInt64; sCallerName: String; sCallerId: String; sDialNo: String; sToPeerName: String; nTimeout: Integer): Boolean;
    function MuteCallServerREC(nSessionId: UInt64; nMuteType: Integer): Boolean;
    function GetUserAgentNameCall(nSessionId: UInt64): String;

    function AddVectorStoreSearchOpenAI(nSessionId: UInt64; sSearchName: String; sSearchDesc: String; sVectorStoreId: String; sFilters: String; nMaxNoResults: Integer): Boolean;
    procedure RemoveVectorStoreSearchOpenAI(nSessionId: UInt64; sSearchName: String);
    procedure RemoveVectorStoreSearchAllOpenAI(nSessionId: UInt64);

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  protected
    procedure InvokeEvent(DispID: LongInt; var Params: TVariantArray); override;

  protected

    procedure OnRegisterUser(sUserName: String; sDomain: String; sUserAgent: String; sFromIP: String; nFromPort: Integer; nRegId: UInt64); virtual;
    procedure OnRegisterUserSuccess(sUserName: String; sFromIP: String; nFromPort: Integer; nRegId: UInt64); virtual;
    procedure OnRegisterUserFailed(sUserName: String; sFromIP: String; nFromPort: Integer; nRegId: UInt64); virtual;
    procedure OnUnRegisterUser(sUserName: String); virtual;

    procedure OnCallSessionCreated(nSessionId: UInt64; nReasonCode: Integer); virtual;
    procedure OnCallSessionClosed(nSessionId: UInt64; nReasonCode: Integer); virtual;
    procedure OnCallSessionConnecting(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String); virtual;
    procedure OnCallSessionFailed(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String; sContact: String); virtual;
    procedure OnCallSessionConnected(nSessionId: UInt64); virtual;
    procedure OnIncomingCall(nSessionId: UInt64; sCallerName: String; sCallerId: String; sDialNo: String; nFromPeerType: Integer; sFromPeerName: String; sUserAgent: String; sFromIP: String; nFromPort: Integer); virtual;
    procedure OnCallSessionLost(nSessionId: UInt64); virtual;
    procedure OnCallSessionHangup(nSessionId: UInt64); virtual;
    procedure OnCallSessionTimeout(nSessionId: UInt64); virtual;
    procedure OnCallSessionCancelled(nSessionId: UInt64); virtual;

    procedure OnChatMessageText(nChatMsgId: UInt64; sMsgFrom: String; sMsgTo: String; sMsgText: String; nFromPeerType: Integer; sFromPeerName: String; sFromIP: String; nFromPort: Integer); virtual;
    procedure OnChatMessageSuccess(nChatMsgId: UInt64); virtual;
    procedure OnChatMessageFailed(nChatMsgId: UInt64; nStatusId: Integer; sReasonPhrase: String); virtual;
    procedure OnChatMessageTimeout(nChatMsgId: UInt64); virtual;

    procedure OnVaxFunctionCallOpenAI(nSessionId: UInt64; sFuncName: String; sCallId: String; aParamNames: TArray<String>; aParamValues: TArray<String>); virtual;
    procedure OnVaxSessionUpdatedOpenAI(nSessionId: UInt64); virtual;
    procedure OnVaxAudioOutputTranscriptOpenAI(nSessionId: UInt64; sTranscript: String); virtual;
    procedure OnVaxAudioInputTranscriptOpenAI(nSessionId: UInt64; sTranscript: String); virtual;
    procedure OnVaxResponseDoneUsageOpenAI(nSessionId: UInt64; nTotalTokens: Integer; nInputTokens: Integer; nOutputTokens: Integer); virtual;
    procedure OnVaxStatusOpenAI(nSessionId: UInt64; nStatusId: Integer; sStatus: String); virtual;
    procedure OnVaxErrorOpenAI(nSessionId: UInt64; sMsg: String); virtual;

    procedure OnLineRegisterTrying(sLineName: String); virtual;
    procedure OnLineRegisterFailed(sLineName: String; nStatusCode: Integer; sReasonPhrase: String); virtual;
    procedure OnLineRegisterSuccess(sLineName: String); virtual;
    procedure OnLineUnRegisterTrying(sLineName: String); virtual;
    procedure OnLineUnRegisterFailed(sLineName: String; nStatusCode: Integer; sReasonPhrase: String); virtual;
    procedure OnLineUnRegisterSuccess(sLineName: String); virtual;

    procedure OnAttackDetectedScanSIP(sReqMethod: String; sAddrIP: String; nAddrPort: Integer; nAddrType: Integer); virtual;
    procedure OnAttackDetectedFloodSIP(sAddrIP: String; nAddrPort: Integer; nAddrType: Integer); virtual;
    procedure OnAttackDetectedBruteForceSIP(sReqMethod: String; nAuthFailureCount: Integer; sAddrIP: String; nAddrPort: Integer; nAddrType: Integer); virtual;

    procedure OnSendReqTransferCallTimeout(nSessionId: UInt64); virtual;
    procedure OnSendReqTransferCallAccepted(nSessionId: UInt64); virtual;
    procedure OnSendReqTransferCallFailed(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String); virtual;

    procedure OnServerConnectingREC(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String); virtual;
    procedure OnServerConnectedREC(nSessionId: UInt64); virtual;
    procedure OnServerFailedREC(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String); virtual;
    procedure OnServerTimeoutREC(nSessionId: UInt64); virtual;
    procedure OnServerHungupREC(nSessionId: UInt64); virtual;

    procedure OnVaxVectorSearchStartedOpenAI(nSessionId: UInt64; sSearchName: String; sQuery: String); virtual;
    procedure OnVaxVectorSearchTryingOpenAI(nSessionId: UInt64; sSearchName: String); virtual;
    procedure OnVaxVectorSearchSuccessOpenAI(nSessionId: UInt64; sSearchName: String; sContent: String); virtual;
    procedure OnVaxVectorSearchFailedOpenAI(nSessionId: UInt64; sSearchName: String; sMsg: String); virtual;

    procedure OnCallSessionErrorLog(nSessionId: UInt64; nErrorCode: Integer; sErrorMsg: String); virtual;
    procedure OnVaxErrorLog(sFuncName: String; nErrorCode: Integer; sErrorMsg: String); virtual;


end;


implementation

{$ASSERTIONS ON}

var
  m_bLoadedCOM: Boolean;

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  constructor TVaxServerCOM.Create();
  begin
    inherited Create(Nil);

    try
      inherited SetLicenseKey('');
    except

      // Register VaxServerVoAI.dll (COM) (Please have a look at ReadMe.txt)

      m_bLoadedCOM := False;
      Exit();
    end;

    m_bLoadedCOM := True;
  end;

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  procedure TVaxServerCOM.SetLicenseKey(sLicenseKey: String);
  begin

    if(m_bLoadedCOM = False) Then
    Begin
       Exit();
    end;

    inherited SetLicenseKey(sLicenseKey);

  end;

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  function TVaxServerCOM.Initialize(sDomainRealm: String): Boolean;
  begin

    if(m_bLoadedCOM = False) Then
    Begin
      OnVaxErrorLog('', -1, VAX_ERROR_LOAD_COM_MSG_A);
      OnVaxErrorLog('', -1, VAX_ERROR_LOAD_COM_MSG_B);
      OnVaxErrorLog('', -1, VAX_ERROR_LOAD_COM_MSG_C);
      OnVaxErrorLog('', -1, VAX_ERROR_LOAD_COM_MSG_D);
      Exit(False);
    end;

    Result := Boolean(inherited Initialize(sDomainRealm));

  end;

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  procedure TVaxServerCOM.UnInitialize();
  begin

    if(m_bLoadedCOM = False) Then
    Begin
       Exit();
    end;

    inherited UnInitialize();

  end;

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  function TVaxServerCOM.GetVaxErrorCode: Integer;
  begin
    Result := Integer(inherited GetVaxErrorCode);
  end;

  function TVaxServerCOM.GetVaxErrorText: String;
  begin
    Result := String(inherited GetVaxErrorText);
  end;

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  function TVaxServerCOM.GetVersionFile: String;
  begin
    Result := String(inherited GetVersionFile);
  end;

  function TVaxServerCOM.GetVersionSDK: String;
  begin
    Result := String(inherited GetVersionSDK);
  end;

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  function TVaxServerCOM.SetListenPortRangeRTP(nListenStartPort: Integer; nListenEndPort: Integer): Boolean;
  begin
    Result := Boolean(inherited SetListenPortRangeRTP(nListenStartPort, nListenEndPort));
  end;

  function TVaxServerCOM.SetNetworkMediaRTP(sListenIP: String; nListenStartPort: Integer): Boolean;
  begin
    Result := Boolean(inherited SetNetworkMediaRTP(sListenIP, nListenStartPort));
  end;

  function TVaxServerCOM.CryptoMediaNONE(bForced: Boolean): Boolean;
  begin
    Result := Boolean(inherited CryptoMediaNONE(bForced));
  end;

  function TVaxServerCOM.CryptoMediaSDP(bForced: Boolean): Boolean;
  begin
    Result := Boolean(inherited CryptoMediaSDP(bForced));
  end;

  function TVaxServerCOM.AddNetworkRouteSIP(sAssignedIP: String; sRouterIP: String): Boolean;
  begin
    Result := Boolean(inherited AddNetworkRouteSIP(sAssignedIP, sRouterIP));
  end;

  function TVaxServerCOM.AddNetworkRouteRTP(sAssignedIP: String; sRouterIP: String): Boolean;
  begin
    Result := Boolean(inherited AddNetworkRouteRTP(sAssignedIP, sRouterIP));
  end;

  function TVaxServerCOM.OpenNetworkUDP(sListenIP: String; nListenPort: Integer): Boolean;
  begin
    Result := Boolean(inherited OpenNetworkUDP(sListenIP, nListenPort));
  end;

  function TVaxServerCOM.OpenNetworkTCP(sListenIP: String; nListenPort: Integer): Boolean;
  begin
    Result := Boolean(inherited OpenNetworkTCP(sListenIP, nListenPort));
  end;

  function TVaxServerCOM.OpenNetworkTLS(sListenIP: String; nListenPort: Integer; sCertPEM: String): Boolean;
  begin
    Result := Boolean(inherited OpenNetworkTLS(sListenIP, nListenPort, sCertPEM));
  end;

  procedure TVaxServerCOM.CloseNetworkUDP;
  begin
    inherited CloseNetworkUDP;
  end;

  procedure TVaxServerCOM.CloseNetworkTCP;
  begin
    inherited CloseNetworkTCP;
  end;

  procedure TVaxServerCOM.CloseNetworkTLS;
  begin
    inherited CloseNetworkTLS;
  end;

  function TVaxServerCOM.AddUser(sUserName: String; sPassword: String; sAudioCodecList: String): Boolean;
  begin
    Result := Boolean(inherited AddUser(sUserName, sPassword, sAudioCodecList));
  end;

  procedure TVaxServerCOM.RemoveUser(sUserName: String);
  begin
    inherited RemoveUser(sUserName);
  end;

  function TVaxServerCOM.RegisterUserExpiry(nExpiry: Integer): Boolean;
  begin
    Result := Boolean(inherited RegisterUserExpiry(nExpiry));
  end;

  function TVaxServerCOM.AttachRegister(nRegId: UInt64; sUserName: String): Boolean;
  begin
    Result := Boolean(inherited AttachRegister(nRegId, sUserName));
  end;

  function TVaxServerCOM.AcceptRegister(nRegId: UInt64): Boolean;
  begin
    Result := Boolean(inherited AcceptRegister(nRegId));
  end;

  function TVaxServerCOM.RejectRegister(nRegId: UInt64; nStatusCode: Integer; sReasonPhrase: String): Boolean;
  begin
    Result := Boolean(inherited RejectRegister(nRegId, nStatusCode, sReasonPhrase));
  end;

  function TVaxServerCOM.AuthRegister(nRegId: UInt64): Boolean;
  begin
    Result := Boolean(inherited AuthRegister(nRegId));
  end;

  function TVaxServerCOM.AddLine(sLineName: String; nLineType: Integer; sDisplayName: String; sUserName: String; sAuthLogin: String; sAuthPwd: String; sDomainRealm: String; sServerAddr: String; nServerPort: Integer; sAudioCodecList: String): Boolean;
  begin
    Result := Boolean(inherited AddLine(sLineName, nLineType, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort, sAudioCodecList));
  end;

  procedure TVaxServerCOM.RemoveLine(sLineName: String);
  begin
    inherited RemoveLine(sLineName);
  end;

  function TVaxServerCOM.RegisterLine(sLineName: String; nExpire: Integer): Boolean;
  begin
    Result := Boolean(inherited RegisterLine(sLineName, nExpire));
  end;

  function TVaxServerCOM.UnRegisterLine(sLineName: String): Boolean;
  begin
    Result := Boolean(inherited UnRegisterLine(sLineName));
  end;

  function TVaxServerCOM.AcceptCallSession(nSessionId: UInt64; nTimeout: Integer; sKeyOpenAI: String; sPrompt: String; sModel: String; sVoice: String; fOutputAudioSpeed: Double): Boolean;
  begin
    Result := Boolean(inherited AcceptCallSession(nSessionId, nTimeout, sKeyOpenAI, sPrompt, sModel, sVoice, fOutputAudioSpeed));
  end;

  function TVaxServerCOM.RejectCallSession(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String): Boolean;
  begin
    Result := Boolean(inherited RejectCallSession(nSessionId, nStatusCode, sReasonPhrase));
  end;

  function TVaxServerCOM.CloseCallSession(nSessionId: UInt64): Boolean;
  begin
    Result := Boolean(inherited CloseCallSession(nSessionId));
  end;

  function TVaxServerCOM.DialCallSession(sCallerName: String; sCallerId: String; sDialNo: String; sToPeerName: String; nTimeout: Integer): UInt64;
  begin
    Result := UInt64(inherited DialCallSession(sCallerName, sCallerId, sDialNo, sToPeerName, nTimeout));
  end;

  function TVaxServerCOM.CallSessionSendStatusResponse(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String; sContactURI: String): Boolean;
  begin
    Result := Boolean(inherited CallSessionSendStatusResponse(nSessionId, nStatusCode, sReasonPhrase, sContactURI));
  end;

  function TVaxServerCOM.SendReqTransferCallBlind(nSessionId: UInt64; sToUserName: String): Boolean;
  begin
    Result := Boolean(inherited SendReqTransferCallBlind(nSessionId, sToUserName));
  end;

  function TVaxServerCOM.SendReqTransferCallConsult(nSessionId: UInt64; nToSessionId: UInt64): Boolean;
  begin
    Result := Boolean(inherited SendReqTransferCallConsult(nSessionId, nToSessionId));
  end;

  function TVaxServerCOM.AcceptChatMessage(nChatMsgId: UInt64; sToPeerName: String): Boolean;
  begin
    Result := Boolean(inherited AcceptChatMessage(nChatMsgId, sToPeerName));
  end;

  procedure TVaxServerCOM.RejectChatMessage(nChatMsgId: UInt64; nStatusCode: Integer; sReasonPhrase: String);
  begin
    inherited RejectChatMessage(nChatMsgId, nStatusCode, sReasonPhrase);
  end;

  function TVaxServerCOM.SendChatMessageText(sMsgFrom: String; sMsgTo: String; sMsgText: String; sToPeerName: String): UInt64;
  begin
    Result := UInt64(inherited SendChatMessageText(sMsgFrom, sMsgTo, sMsgText, sToPeerName));
  end;

  function TVaxServerCOM.AudioSessionLost(bEnable: Boolean; nTimeout: Integer): Boolean;
  begin
    Result := Boolean(inherited AudioSessionLost(bEnable, nTimeout));
  end;

  function TVaxServerCOM.SetUserAgentName(sName: String): Boolean;
  begin
    Result := Boolean(inherited SetUserAgentName(sName));
  end;

  function TVaxServerCOM.GetUserAgentName: String;
  begin
    Result := String(inherited GetUserAgentName);
  end;

  function TVaxServerCOM.SetSessionNameSDP(sName: String): Boolean;
  begin
    Result := Boolean(inherited SetSessionNameSDP(sName));
  end;

  function TVaxServerCOM.GetSessionNameSDP: String;
  begin
    Result := String(inherited GetSessionNameSDP);
  end;

  function TVaxServerCOM.SendDigitDTMF(nSessionId: UInt64; sDigitDTMF: String; nTypeDTMF: Integer): Boolean;
  begin
    Result := Boolean(inherited SendDigitDTMF(nSessionId, sDigitDTMF, nTypeDTMF));
  end;

  function TVaxServerCOM.DetectDigitDTMF(nSessionId: UInt64; nTypeDTMF: Integer; bEnable: Boolean; nMilliSecTimeout: Integer): Boolean;
  begin
    Result := Boolean(inherited DetectDigitDTMF(nSessionId, nTypeDTMF, bEnable, nMilliSecTimeout));
  end;

  function TVaxServerCOM.ActivateSemanticVAD(nSessionId: UInt64; sEagerness: String): Boolean;
  begin
    Result := Boolean(inherited ActivateSemanticVAD(nSessionId, sEagerness));
  end;

  function TVaxServerCOM.ActivateAcousticVAD(nSessionId: UInt64; fThreshold: Double; nPrefixPadding: Integer; nSilenceDuration: Integer): Boolean;
  begin
    Result := Boolean(inherited ActivateAcousticVAD(nSessionId, fThreshold, nPrefixPadding, nSilenceDuration));
  end;

  function TVaxServerCOM.UpdateSessionOpenAI(nSessionId: UInt64; sPrompt: String; fOutputAudioSpeed: Double): Boolean;
  begin
    Result := Boolean(inherited UpdateSessionOpenAI(nSessionId, sPrompt, fOutputAudioSpeed));
  end;

  function TVaxServerCOM.SendInputOpenAI(nSessionId: UInt64; sInput: String): Boolean;
  begin
    Result := Boolean(inherited SendInputOpenAI(nSessionId, sInput));
  end;

  function TVaxServerCOM.AddFunctionOpenAI(nSessionId: UInt64; sFuncName: String; sFuncDesc: String): Boolean;
  begin
    Result := Boolean(inherited AddFunctionOpenAI(nSessionId, sFuncName, sFuncDesc));
  end;

  procedure TVaxServerCOM.RemoveFunctionOpenAI(nSessionId: UInt64; sFuncName: String);
  begin
    inherited RemoveFunctionOpenAI(nSessionId, sFuncName);
  end;

  procedure TVaxServerCOM.RemoveFunctionAllOpenAI(nSessionId: UInt64);
  begin
    inherited RemoveFunctionAllOpenAI(nSessionId);
  end;

  function TVaxServerCOM.AddFunctionParamOpenAI(nSessionId: UInt64; sFuncName: String; sParamName: String; sParamDesc: String): Boolean;
  begin
    Result := Boolean(inherited AddFunctionParamOpenAI(nSessionId, sFuncName, sParamName, sParamDesc));
  end;

  function TVaxServerCOM.AddFunctionParamEnumOpenAI(nSessionId: UInt64; sFuncName: String; sParamName: String; sEnumValue: String): Boolean;
  begin
    Result := Boolean(inherited AddFunctionParamEnumOpenAI(nSessionId, sFuncName, sParamName, sEnumValue));
  end;

  function TVaxServerCOM.SendFunctionResultOpenAI(nSessionId: UInt64; sCallId: String; sOutput: String): Boolean;
  begin
    Result := Boolean(inherited SendFunctionResultOpenAI(nSessionId, sCallId, sOutput));
  end;

  function TVaxServerCOM.AttackDetectScanSIP(sDomainName: String): Boolean;
  begin
    Result := Boolean(inherited AttackDetectScanSIP(sDomainName));
  end;

  function TVaxServerCOM.AttackDetectFloodSIP(nReqRecvLimit: Integer): Boolean;
  begin
    Result := Boolean(inherited AttackDetectFloodSIP(nReqRecvLimit));
  end;

  function TVaxServerCOM.AttackDetectBruteForceSIP(nFailureCount: Integer; nFailureInterval: Integer): Boolean;
  begin
    Result := Boolean(inherited AttackDetectBruteForceSIP(nFailureCount, nFailureInterval));
  end;

  function TVaxServerCOM.CallSessionMuteVoice(nSessionId: UInt64; bListen: Boolean; bSpeak: Boolean): Boolean;
  begin
    Result := Boolean(inherited CallSessionMuteVoice(nSessionId, bListen, bSpeak));
  end;

  function TVaxServerCOM.SetExtDataREC(nSessionId: UInt64; sExtData: String): Boolean;
  begin
    Result := Boolean(inherited SetExtDataREC(nSessionId, sExtData));
  end;

  function TVaxServerCOM.ConnectToServerREC(nSessionId: UInt64; sCallerName: String; sCallerId: String; sDialNo: String; sToPeerName: String; nTimeout: Integer): Boolean;
  begin
    Result := Boolean(inherited ConnectToServerREC(nSessionId, sCallerName, sCallerId, sDialNo, sToPeerName, nTimeout));
  end;

  function TVaxServerCOM.MuteCallServerREC(nSessionId: UInt64; nMuteType: Integer): Boolean;
  begin
    Result := Boolean(inherited MuteCallServerREC(nSessionId, nMuteType));
  end;

  function TVaxServerCOM.GetUserAgentNameCall(nSessionId: UInt64): String;
  begin
    Result := String(inherited GetUserAgentNameCall(nSessionId));
  end;

  function TVaxServerCOM.AddVectorStoreSearchOpenAI(nSessionId: UInt64; sSearchName: String; sSearchDesc: String; sVectorStoreId: String; sFilters: String; nMaxNoResults: Integer): Boolean;
  begin
    Result := Boolean(inherited AddVectorStoreSearchOpenAI(nSessionId, sSearchName, sSearchDesc, sVectorStoreId, sFilters, nMaxNoResults));
  end;

  procedure TVaxServerCOM.RemoveVectorStoreSearchOpenAI(nSessionId: UInt64; sSearchName: String);
  begin
    inherited RemoveVectorStoreSearchOpenAI(nSessionId, sSearchName);
  end;

  procedure TVaxServerCOM.RemoveVectorStoreSearchAllOpenAI(nSessionId: UInt64);
  begin
    inherited RemoveVectorStoreSearchAllOpenAI(nSessionId);
  end;

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  procedure TVaxServerCOM.InvokeEvent(DispID: LongInt; var Params: TVariantArray);
  begin
    case DispID of
      -1: Exit;

      1: OnRegisterUser(Params[0] {WideString}, Params[1] {WideString}, Params[2] {WideString}, Params[3] {WideString}, Params[4] {Integer}, Params[5] {Largeuint});
      2: OnRegisterUserSuccess(Params[0] {WideString}, Params[1] {WideString}, Params[2] {Integer}, Params[3] {Largeuint});
      3: OnRegisterUserFailed(Params[0] {WideString}, Params[1] {WideString}, Params[2] {Integer}, Params[3] {Largeuint});
      4: OnUnRegisterUser(Params[0] {WideString});

      5: OnCallSessionCreated(Params[0] {Largeuint}, Params[1] {Integer});
      6: OnCallSessionClosed(Params[0] {Largeuint}, Params[1] {Integer});
      7: OnCallSessionConnecting(Params[0] {Largeuint}, Params[1] {Integer}, Params[2] {WideString});
      8: OnCallSessionFailed(Params[0] {Largeuint}, Params[1] {Integer}, Params[2] {WideString}, Params[3] {WideString});
      9: OnCallSessionConnected(Params[0] {Largeuint});

      10: OnIncomingCall(Params[0] {Largeuint}, Params[1] {WideString}, Params[2] {WideString}, Params[3] {WideString}, Params[4] {Integer}, Params[5] {WideString}, Params[6] {WideString}, Params[7] {WideString}, Params[8] {Integer});

      11: OnCallSessionLost(Params[0] {Largeuint});
      12: OnCallSessionHangup(Params[0] {Largeuint});
      13: OnCallSessionTimeout(Params[0] {Largeuint});
      14: OnCallSessionCancelled(Params[0] {Largeuint});

      15: OnChatMessageText(Params[0] {Largeuint}, Params[1] {WideString}, Params[2] {WideString}, Params[3] {WideString}, Params[4] {Integer}, Params[5] {WideString}, Params[6] {WideString}, Params[7] {Integer});
      16: OnChatMessageSuccess(Params[0] {Largeuint});
      17: OnChatMessageFailed(Params[0] {Largeuint}, Params[1] {Integer}, Params[2] {WideString});
      18: OnChatMessageTimeout(Params[0] {Largeuint});

      19: OnVaxFunctionCallOpenAI(Params[0] {Largeuint}, Params[1] {WideString}, Params[2] {WideString}, Params[3] {OleVariant}, Params[4] {OleVariant});
      20: OnVaxSessionUpdatedOpenAI(Params[0] {Largeuint});
      21: OnVaxAudioOutputTranscriptOpenAI(Params[0] {Largeuint}, Params[1] {WideString});
      22: OnVaxResponseDoneUsageOpenAI(Params[0] {Largeuint}, Params[1] {Integer}, Params[2] {Integer}, Params[3] {Integer});
      23: OnVaxStatusOpenAI(Params[0] {Largeuint}, Params[1] {Integer}, Params[2] {WideString});
      24: OnVaxErrorOpenAI(Params[0] {Largeuint}, Params[1] {WideString});

      25: OnLineRegisterTrying(Params[0] {WideString});
      26: OnLineRegisterFailed(Params[0] {WideString}, Params[1] {Integer}, Params[2] {WideString});
      27: OnLineRegisterSuccess(Params[0] {WideString});
      28: OnLineUnRegisterTrying(Params[0] {WideString});
      29: OnLineUnRegisterFailed(Params[0] {WideString}, Params[1] {Integer}, Params[2] {WideString});
      30: OnLineUnRegisterSuccess(Params[0] {WideString});

      31: OnAttackDetectedScanSIP(Params[0] {WideString}, Params[1] {WideString}, Params[2] {Integer}, Params[3] {Integer});
      32: OnAttackDetectedFloodSIP(Params[0] {WideString}, Params[1] {Integer}, Params[2] {Integer});
      33: OnAttackDetectedBruteForceSIP(Params[0] {WideString}, Params[1] {Integer}, Params[2] {WideString}, Params[3] {Integer}, Params[4] {Integer});

      34: OnSendReqTransferCallTimeout(Params[0] {Largeuint});
      35: OnSendReqTransferCallAccepted(Params[0] {Largeuint});
      36: OnSendReqTransferCallFailed(Params[0] {Largeuint}, Params[1] {Integer}, Params[2] {WideString});

      37: OnServerConnectingREC(Params[0] {Largeuint}, Params[1] {Integer}, Params[2] {WideString});
      38: OnServerConnectedREC(Params[0] {Largeuint});
      39: OnServerFailedREC(Params[0] {Largeuint}, Params[1] {Integer}, Params[2] {WideString});
      40: OnServerTimeoutREC(Params[0] {Largeuint});
      41: OnServerHungupREC(Params[0] {Largeuint});

      42: OnVaxVectorSearchStartedOpenAI(Params[0] {Largeuint}, Params[1] {WideString}, Params[2] {WideString});
      43: OnVaxVectorSearchTryingOpenAI(Params[0] {Largeuint}, Params[1] {WideString});
      44: OnVaxVectorSearchSuccessOpenAI(Params[0] {Largeuint}, Params[1] {WideString}, Params[2] {WideString});
      45: OnVaxVectorSearchFailedOpenAI(Params[0] {Largeuint}, Params[1] {WideString}, Params[2] {WideString});

      46: OnCallSessionErrorLog(Params[0] {Largeuint}, Params[1] {Integer}, Params[2] {WideString});
      47: OnVaxErrorLog(Params[0] {WideString}, Params[1] {Integer}, Params[2] {WideString});
      48: OnVaxAudioInputTranscriptOpenAI(Params[0] {Largeuint}, Params[1] {WideString});
    end;
  end;

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  procedure TVaxServerCOM.OnRegisterUser(sUserName: String; sDomain: String; sUserAgent: String; sFromIP: String; nFromPort: Integer; nRegId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnRegisterUserSuccess(sUserName: String; sFromIP: String; nFromPort: Integer; nRegId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnRegisterUserFailed(sUserName: String; sFromIP: String; nFromPort: Integer; nRegId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnUnRegisterUser(sUserName: String);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionCreated(nSessionId: UInt64; nReasonCode: Integer);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionClosed(nSessionId: UInt64; nReasonCode: Integer);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionConnecting(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionFailed(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String; sContact: String);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionConnected(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnIncomingCall(nSessionId: UInt64; sCallerName: String; sCallerId: String; sDialNo: String; nFromPeerType: Integer; sFromPeerName: String; sUserAgent: String; sFromIP: String; nFromPort: Integer);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionLost(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionHangup(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionTimeout(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionCancelled(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnChatMessageText(nChatMsgId: UInt64; sMsgFrom: String; sMsgTo: String; sMsgText: String; nFromPeerType: Integer; sFromPeerName: String; sFromIP: String; nFromPort: Integer);
  begin
  end;

  procedure TVaxServerCOM.OnChatMessageSuccess(nChatMsgId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnChatMessageFailed(nChatMsgId: UInt64; nStatusId: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxServerCOM.OnChatMessageTimeout(nChatMsgId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnVaxFunctionCallOpenAI(nSessionId: UInt64; sFuncName: String; sCallId: String; aParamNames: TArray<String>; aParamValues: TArray<String>);
  begin
  end;

  procedure TVaxServerCOM.OnVaxSessionUpdatedOpenAI(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnVaxAudioOutputTranscriptOpenAI(nSessionId: UInt64; sTranscript: String);
  begin
  end;

  procedure TVaxServerCOM.OnVaxAudioInputTranscriptOpenAI(nSessionId: UInt64; sTranscript: String);
  begin
  end;


  procedure TVaxServerCOM.OnVaxResponseDoneUsageOpenAI(nSessionId: UInt64; nTotalTokens: Integer; nInputTokens: Integer; nOutputTokens: Integer);
  begin
  end;

  procedure TVaxServerCOM.OnVaxStatusOpenAI(nSessionId: UInt64; nStatusId: Integer; sStatus: String);
  begin
  end;

  procedure TVaxServerCOM.OnVaxErrorOpenAI(nSessionId: UInt64; sMsg: String);
  begin
  end;

  procedure TVaxServerCOM.OnLineRegisterTrying(sLineName: String);
  begin
  end;

  procedure TVaxServerCOM.OnLineRegisterFailed(sLineName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxServerCOM.OnLineRegisterSuccess(sLineName: String);
  begin
  end;

  procedure TVaxServerCOM.OnLineUnRegisterTrying(sLineName: String);
  begin
  end;

  procedure TVaxServerCOM.OnLineUnRegisterFailed(sLineName: String; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxServerCOM.OnLineUnRegisterSuccess(sLineName: String);
  begin
  end;

  procedure TVaxServerCOM.OnAttackDetectedScanSIP(sReqMethod: String; sAddrIP: String; nAddrPort: Integer; nAddrType: Integer);
  begin
  end;

  procedure TVaxServerCOM.OnAttackDetectedFloodSIP(sAddrIP: String; nAddrPort: Integer; nAddrType: Integer);
  begin
  end;

  procedure TVaxServerCOM.OnAttackDetectedBruteForceSIP(sReqMethod: String; nAuthFailureCount: Integer; sAddrIP: String; nAddrPort: Integer; nAddrType: Integer);
  begin
  end;

  procedure TVaxServerCOM.OnSendReqTransferCallTimeout(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnSendReqTransferCallAccepted(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnSendReqTransferCallFailed(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxServerCOM.OnServerConnectingREC(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxServerCOM.OnServerConnectedREC(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnServerFailedREC(nSessionId: UInt64; nStatusCode: Integer; sReasonPhrase: String);
  begin
  end;

  procedure TVaxServerCOM.OnServerTimeoutREC(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnServerHungupREC(nSessionId: UInt64);
  begin
  end;

  procedure TVaxServerCOM.OnVaxVectorSearchStartedOpenAI(nSessionId: UInt64; sSearchName: String; sQuery: String);
  begin
  end;

  procedure TVaxServerCOM.OnVaxVectorSearchTryingOpenAI(nSessionId: UInt64; sSearchName: String);
  begin
  end;

  procedure TVaxServerCOM.OnVaxVectorSearchSuccessOpenAI(nSessionId: UInt64; sSearchName: String; sContent: String);
  begin
  end;

  procedure TVaxServerCOM.OnVaxVectorSearchFailedOpenAI(nSessionId: UInt64; sSearchName: String; sMsg: String);
  begin
  end;

  procedure TVaxServerCOM.OnCallSessionErrorLog(nSessionId: UInt64; nErrorCode: Integer; sErrorMsg: String);
  begin
  end;

  procedure TVaxServerCOM.OnVaxErrorLog(sFuncName: String; nErrorCode: Integer; sErrorMsg: String);
  begin
  end;


end.

