﻿
//Class cVaxMainHtml

var m_objAccountSIP = null;
var m_objPhoneCall = null;

var m_objDigitTone = null;
var m_objPhoneTone = null;

var m_objPhoneTransfer = null;
var m_objBusyLamp = null;

var m_objChat = null;
var m_objSetting = null;

function cVaxMainHtml() 
{
    m_objAccountSIP = new cVaxAccountSIP();
    m_objPhoneCall = new cVaxPhoneCall();
    
    m_objPhoneTone = new cVaxPhoneTone();
    m_objDigitTone = new cVaxDigitTone();

    m_objPhoneTransfer = new cVaxPhoneTransfer();
    m_objBusyLamp = new cVaxBusyLamp();

    m_objChat = new cVaxChat();
    m_objSetting = new cVaxSetting();

    var m_hVideoOutElement = null;
    var m_hCanvasCTX = null;
        
    this.OnLoadPage = function ()
    {
        m_objSetting.OnLoadPage();
        
        m_objAccountSIP.OnLoadPage();
        m_objPhoneCall.OnLoadPage();
        
        m_objPhoneTone.OnLoadPage();
        m_objDigitTone.OnLoadPage();

        m_objPhoneTransfer.OnLoadPage();
        m_objBusyLamp.OnLoadPage();

        m_objChat.OnLoadPage();
                
        m_objVaxWebPhoneLib.SetEventMainSIP(OnInitialized, OnUnInitialized, null, null, null, null);
    }

    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    function OnInitialized()
    {
        AdjustVideoOut();
                        
        CreateCanvasOutput();

        if (CheckDeviceCamera.checked)
        {
            (async () => {
                await m_objVaxWebPhoneLib.ActivateMediaCamera(OnVideoMediaDrawFrame, m_hVideoPreviewOut.srcObject, m_hVideoMediaOut);
            })();
        }

        if (CheckShareScreen.checked)
        {
            (async () => {
                await m_objVaxWebPhoneLib.ActivateMediaScreen(OnVideoMediaDrawFrame, m_hVideoPreviewOut.srcObject, m_hVideoMediaOut);
            })();
        }
    }

    function OnUnInitialized()
    {
        m_objVaxWebPhoneLib.DeactivateMediaCamera();
        m_objVaxWebPhoneLib.DeactivateMediaScreen();
    }

    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    this.CheckDeviceCamera_onclick = function ()
    {
        if (CheckDeviceCamera.checked == false)
        {
            m_objVaxWebPhoneLib.DeactivateMediaCamera();
            return;
        }

        (async () =>
        {
            await m_objVaxWebPhoneLib.ActivateMediaCamera(OnVideoMediaDrawFrame, m_hVideoPreviewOut.srcObject, m_hVideoMediaOut);
        })();
    }

    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    this.CheckShareScreen_onclick = function ()
    {
        if (CheckShareScreen.checked == false)
        {
            m_objVaxWebPhoneLib.DeactivateMediaScreen();
            return;
        }

        (async () =>
        {
            await m_objVaxWebPhoneLib.ActivateMediaScreen(OnVideoMediaDrawFrame, m_hVideoPreviewOut.srcObject, m_hVideoMediaOut);
        })();
    }

    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    function OnVideoMediaDrawFrame(hCameraVideoStream, hScreenVideoStream)
    {
        //m_hCanvasCTX.clearRect(0, 0, m_hVideoOutElement.width, m_hVideoOutElement.height);

        if (hScreenVideoStream && hCameraVideoStream)
        {
            m_hCanvasCTX.drawImage(hScreenVideoStream, 0, 0, m_hVideoOutElement.width, m_hVideoOutElement.height);

            const nCamWidth = m_hVideoOutElement.width / 4;
            const nCamHeight = m_hVideoOutElement.height / 4;

            m_hCanvasCTX.drawImage(hCameraVideoStream, m_hVideoOutElement.width - nCamWidth - 10, m_hVideoOutElement.height - nCamHeight - 10, nCamWidth, nCamHeight);
        }
        else if (hScreenVideoStream && hCameraVideoStream == null)
        {
            m_hCanvasCTX.drawImage(hScreenVideoStream, 0, 0, m_hVideoOutElement.width, m_hVideoOutElement.height);
        }
        else if (hScreenVideoStream == null && hCameraVideoStream)
        {
            m_hCanvasCTX.drawImage(hCameraVideoStream, 0, 0, m_hVideoOutElement.width, m_hVideoOutElement.height);
        }
    }

    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    function CreateCanvasOutput()
    {
        m_hVideoOutElement = document.createElement("canvas");
        m_hCanvasCTX = m_hVideoOutElement.getContext("2d");
                
        m_hVideoOutElement.width = 640;
        m_hVideoOutElement.height = 480;
                                
        const hCombinedStream = m_hVideoOutElement.captureStream();

        if (!(hCombinedStream instanceof MediaStream))
        {
            throw new Error("Canvas captureStream() failed to return a MediaStream.");
        }

        m_hVideoPreviewOut.srcObject = hCombinedStream;
    }

    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    function AdjustVideoOut()
    {
        m_hVideoPreviewOut = document.getElementById('Preview');
        m_hVideoMediaOut = document.getElementById('MediaVideo');

        m_hVideoPreviewOut.addEventListener('loadedmetadata', function ()
        {
            console.log('Local video videoWidth: ' + this.videoWidth +
                'px,  videoHeight: ' + this.videoHeight + 'px');
        });

        m_hVideoMediaOut.addEventListener('loadedmetadata', function ()
        {
            console.log('Remote video videoWidth: ' + this.videoWidth +
                'px,  videoHeight: ' + this.videoHeight + 'px');
        });

        m_hVideoMediaOut.onresize = function ()
        {
            console.log('Remote video size changed to ' +
                m_hVideoMediaOut.videoWidth + 'x' + m_hVideoMediaOut.videoHeight);

            //if (startTime)
            //{
            //    var elapsedTime = window.performance.now() - startTime;

            //    console.log('Setup time: ' + elapsedTime.toFixed(3) + 'ms');

            //    startTime = null;
            //}
        };
    }
    
    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    this.AddPhoneStatusLog = function (sText)
    {
        if (ListPhoneLog.value.length == 0)
            ListPhoneLog.value = ListPhoneLog.value + sText;
        else
            ListPhoneLog.value = ListPhoneLog.value + "\n" + sText;

        ListPhoneLog.scrollTop = ListPhoneLog.scrollHeight;
    }

    this.ClearPhoneStatusLog = function ()
    {
        ListPhoneLog.value = "";
    }

    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    this.GetBtnCallText = function ()
    {
        return BtnDialCall.value;
    }

    this.SetBtnCallText = function (sText)
    {
        BtnDialCall.value = sText;
    }

    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    this.GetBtnHoldText = function ()
    {
        return BtnHoldCall.value;
    }

    this.SetBtnHoldText = function (sText)
    {
        BtnHoldCall.value = sText;
    }

};
  

