
// Warning: Please do not make any changes to this file.

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

function cVaxPhoneEventSIP() 
{    
    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    var m_hEventOnInitialized = null;

    var m_hEventOnVoiceMailMsg = null;
    var m_hEventOnAudioSessionLost = null;

    var m_hEventOnAddCallHistory = null;
    var m_hEventOnVaxErrorMsg = null;

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    var m_hEventConnectingToRegister = null;
    var m_hEventTryingToRegister = null;
    var m_hEventFailedToRegister = null;
    var m_hEventSuccessToRegister = null;

    var m_hEventConnectingToReRegister = null;
    var m_hEventTryingToReRegister = null;
    var m_hEventFailedToReRegister = null;
    var m_hEventSuccessToReRegister = null;

    var m_hEventTryingToUnRegister = null;
    var m_hEventFailedToUnRegister = null;
    var m_hEventSuccessToUnRegister = null;

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    var m_hEventOnHungupCall = null;
    var m_hEventOnDigitDTMF = null;
    
    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    var m_hEventOnDialCallStarted = null;
    var m_hEventOnDialingCall = null;
    var m_hEventOnDialCallFailed = null;

    var m_hEventOnDialCallRingToneStarted = null;
    var m_hEventOnDialCallRingToneEnded = null;

    var m_hEventOnDialCallBusyToneStarted = null;
    var m_hEventOnDialCallBusyToneEnded = null;

    var m_hEventOnDialCallConnected = null;
    var m_hEventOnIncomingCallConnected = null;

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    var m_hEventOnIncomingCallStarted = null;
    var m_hEventOnIncomingCallEnded = null;

    var m_hEventOnIncomingCallRingToneStarted = null;
    var m_hEventOnIncomingCallRingToneEnded = null;

    var m_hEventOnIncomingRefreshCallStarted = null;
    var m_hEventOnIncomingRefreshCallEnded = null;

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    var m_hEventOnTryingToHold = null;
    var m_hEventOnFailedToHold = null;
    var m_hEventOnSuccessToHold = null;

    var m_hEventOnTryingToUnHold = null;
    var m_hEventOnFailedToUnHold = null;
    var m_hEventOnSuccessToUnHold = null;

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    var m_hEventOnChatContactStatus = null;
    var m_hEventOnChatRecvMsgText = null;

    var m_hEventOnChatSendMsgTextSuccess = null;
    var m_hEventOnChatSendMsgTextFailed = null;

    var m_hEventOnChatSendMsgTypingSuccess = null;
    var m_hEventOnChatSendMsgTypingFailed = null;

    var m_hEventOnChatRecvMsgTypingStart = null;
    var m_hEventOnChatRecvMsgTypingStop = null;

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    var m_hEventBusyLampSubscribeFailed = null;
    var m_hEventBusyLampSubscribeSuccess = null;
    var m_hEventBusyLampContactStatus = null;

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    var m_hEventOnTransferCallFailed = null;
    var m_hEventOnTransferCallAccepted = null;

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////
    
    this.OnWebSocketRecv = function (sMsgJSON) 
    {
        var objParsedJSON = null;

        try
        {
            objParsedJSON = JSON.parse(sMsgJSON);
        }
        catch (e)
        {
            alert(e + ':\n\n' + sMsgJSON); // Error in sMsgJSON (JSON)
            return;
        }

        var sEventName = objParsedJSON.EventName;
        var aEventParam = objParsedJSON.EventParam;

        if (sEventName == "OnInitialized") 
        {
            this.OnInitialized();
        }
                
        else if (sEventName == "OnConnectingToRegister") 
        {
            this.OnConnectingToRegister();
        }

        else if (sEventName == "OnTryingToRegister") 
        {
            this.OnTryingToRegister();
        }

        else if (sEventName == "OnFailToRegister") 
        {
            var nStatusCode = aEventParam[0];
            var sReasonPhrase = aEventParam[1];

            this.OnFailedToRegister(nStatusCode, sReasonPhrase);
        }

        else if (sEventName == "OnSuccessToRegister") 
        {
            this.OnSuccessToRegister();
        }

        else if (sEventName == "OnConnectingToReRegister") 
        {
            this.OnConnectingToReRegister();
        }

        else if (sEventName == "OnTryingToReRegister") 
        {
            this.OnTryingToReRegister();
        }

        else if (sEventName == "OnFailToReRegister") 
        {
            var nStatusCode = aEventParam[0];
            var sReasonPhrase = aEventParam[1];

            this.OnFailedToReRegister(nStatusCode, sReasonPhrase);
        }

        else if (sEventName == "OnSuccessToReRegister") 
        {
            this.OnSuccessToReRegister();
        }

        else if (sEventName == "OnTryingToUnRegister") 
        {
            this.OnTryingToUnRegister();
        }

        else if (sEventName == "OnFailToUnRegister") 
        {
            this.OnFailedToUnRegister();
        }

        else if (sEventName == "OnSuccessToUnRegister") 
        {
            this.OnSuccessToUnRegister();
        }

        else if (sEventName == "OnDialCallStarted") 
        {
            var nLineNo = aEventParam[0];
            var sCallerName = aEventParam[1];
            var sCallerId = aEventParam[2];
            var sDialNo = aEventParam[3];

            this.OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
        }

        else if (sEventName == "OnDialingCall") 
        {
            var nLineNo = aEventParam[0];
            var nStatusCode = aEventParam[1];
            var sReasonPhrase = aEventParam[2];

            this.OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
        }

        else if (sEventName == "OnDialCallFailed") 
        {
            var nLineNo = aEventParam[0];
            var nStatusCode = aEventParam[1];
            var sReasonPhrase = aEventParam[2];
            var sContact = aEventParam[3];

            this.OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase, sContact);
        }

        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////

        else if (sEventName == "OnDialCallRingToneStarted") 
        {
            this.OnDialCallRingToneStarted();
        }

        else if (sEventName == "OnDialCallRingToneEnded") 
        {
            this.OnDialCallRingToneEnded();
        }

        else if (sEventName == "OnDialCallBusyToneStarted") 
        {
            this.OnDialCallBusyToneStarted();
        }

        else if (sEventName == "OnDialCallBusyToneEnded") 
        {
           this.OnDialCallBusyToneEnded();
        }

        //////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////

        else if (sEventName == "OnDialCallConnected") 
        {
            var nLineNo = aEventParam[0];
            var sSDP = aEventParam[1];
            var sToRTPIP = aEventParam[2];
            var nToRTPPort = aEventParam[3];

            this.OnDialCallConnected(nLineNo, sSDP, sToRTPIP, nToRTPPort);
        }

        else if (sEventName == "OnAcceptCallConnected") 
        {
            var nLineNo = aEventParam[0];
            var sToRTPIP = aEventParam[1];
            var nToRTPPort = aEventParam[2];

            this.OnIncomingCallConnected(nLineNo, sToRTPIP, nToRTPPort);
        }

        else if (sEventName == "OnHungupCall") 
        {
            var nLineNo = aEventParam[0];
            this.OnHungupCall(nLineNo);
        }

        else if (sEventName == "OnIncomingCallStarted") 
        {
            var sSDP = aEventParam[0];
            var sCallId = aEventParam[1];
            var sCallerName = aEventParam[2];

            var sCallerId = aEventParam[3];
            var sDialNo = aEventParam[4];

            var sFromURI = aEventParam[5];
            var sToURI = aEventParam[6];

            this.OnIncomingCallStarted(sSDP, sCallId, sCallerName, sCallerId, sDialNo, sFromURI, sToURI);
        }

        else if (sEventName == "OnIncomingCallEnded") 
        {
            var sCallId = aEventParam[0];

            this.OnIncomingCallEnded(sCallId);
        }

        else if (sEventName == "OnIncomingCallRingToneStarted") 
        {
            var sCallId = aEventParam[0];

            this.OnIncomingCallRingToneStarted(sCallId);
        }

        else if (sEventName == "OnIncomingCallRingToneEnded") 
        {
            var sCallId = aEventParam[0];
            
            this.OnIncomingCallRingToneEnded(sCallId);
        }

        else if (sEventName == "OnTransferCallFailed") 
        {
            var nLineNo = aEventParam[0];
            var nStatusCode = aEventParam[1];
            var sReasonPhrase = aEventParam[2];

            this.OnTransferCallFailed(nLineNo, nStatusCode, sReasonPhrase);
        }

        else if (sEventName == "OnTransferCallAccepted") 
        {
            var nLineNo = aEventParam[0];
            this.OnTransferCallAccepted(nLineNo);
        }

        else if (sEventName == "OnDigitDTMF") 
        {
            var nLineNo = aEventParam[0];
            var sDigit = aEventParam[1];

            this.OnDigitDTMF(nLineNo, sDigit)
        }

        else if (sEventName == "OnVoiceMailMsg") 
        {
            var bIsMsgWaiting = aEventParam[0];
            var nNewMsgCount = aEventParam[1];

            var nOldMsgCount = aEventParam[2];
            var nNewUrgentMsgCount = aEventParam[3];

            var nOldUrgentMsgCount = aEventParam[4];
            var sMsgAccount = aEventParam[5];

            this.OnVoiceMailMsg(bIsMsgWaiting, nNewMsgCount, nOldMsgCount, nNewUrgentMsgCount, nOldUrgentMsgCount, sMsgAccount);
        }

        else if (sEventName == "OnAudioSessionLost") 
        {
            var nLineNo = aEventParam[0];
            this.OnAudioSessionLost(nLineNo);
        }

        else if (sEventName == "OnSuccessToHold") 
        {
            var nLineNo = aEventParam[0];
            this.OnSuccessToHold(nLineNo);
        }

        else if (sEventName == "OnTryingToHold") 
        {
            var nLineNo = aEventParam[0];
            this.OnTryingToHold(nLineNo);
        }

        else if (sEventName == "OnFailToHold") 
        {
            debugger;
            var nLineNo = aEventParam[0];
            this.OnFailedToHold(nLineNo);
        }

        else if (sEventName == "OnSuccessToUnHold") 
        {
            var nLineNo = aEventParam[0];
            this.OnSuccessToUnHold(nLineNo);
        }

        else if (sEventName == "OnTryingToUnHold") 
        {
            var nLineNo = aEventParam[0];
            this.OnTryingToUnHold(nLineNo);
        }

        else if (sEventName == "OnFailToUnHold") 
        {
            debugger;

            var nLineNo = aEventParam[0];
            this.OnFailedToUnHold(nLineNo);
        }

        else if (sEventName == "OnChatContactStatus") 
        {
            var sUserName = aEventParam[0];
            var nStatusId = aEventParam[1];

            this.OnChatContactStatus(sUserName, nStatusId);
        }

        else if (sEventName == "OnChatSendMsgTextSuccess") 
        {
            var sUserName = aEventParam[0];
            var sMsgText = aEventParam[1];
            var nUserValue32bit = aEventParam[2];

            this.OnChatSendMsgTextSuccess(sUserName, sMsgText, nUserValue32bit);
        }

        else if (sEventName == "OnChatSendMsgTextFail") 
        {
            var sUserName = aEventParam[0];
            var nStatusCode = aEventParam[1];

            var sReasonPhrase = aEventParam[2];
            var sMsgText = aEventParam[3];

            var nUserValue32bit = aEventParam[4];

            this.OnChatSendMsgTextFailed(sUserName, nStatusCode, sReasonPhrase, sMsgText, nUserValue32bit);
        }

        else if (sEventName == "OnChatSendMsgTypingSuccess") 
        {
            var sUserName = aEventParam[0];
            var nUserValue32bit = aEventParam[1];

            this.OnChatSendMsgTypingSuccess(sUserName, nUserValue32bit);
        }

        else if (sEventName == "OnChatSendMsgTypingFail") 
        {
            var sUserName = aEventParam[0];
            var nStatusCode = aEventParam[1];

            var sReasonPhrase = aEventParam[2];
            var nUserValue32bit = aEventParam[3];

            this.OnChatSendMsgTypingFailed(sUserName, nStatusCode, sReasonPhrase, nUserValue32bit)
        }

        else if (sEventName == "OnChatRecvMsgText") 
        {
            var sUserName = aEventParam[0];
            var sMsgText = aEventParam[1];

            var bIsChatContact = aEventParam[2];

            this.OnChatRecvMsgText(sUserName, sMsgText, bIsChatContact)
        }

        else if (sEventName == "OnChatRecvMsgTypingStart") 
        {
            var sUserName = aEventParam[0];

            this.OnChatRecvMsgTypingStart(sUserName);
        }

        else if (sEventName == "OnChatRecvMsgTypingStop") 
        {
            var sUserName = aEventParam[0];

            this.OnChatRecvMsgTypingStop(sUserName);
        }

        else if (sEventName == "OnHoldCall") 
        {
            var nLineNo = aEventParam[0];
            this.OnHoldCall(nLineNo);
        }

        else if (sEventName == "OnUnHoldCall") 
        {
            var nLineNo = aEventParam[0];
            this.OnUnHoldCall(nLineNo)
        }

        else if (sEventName == "OnAddCallHistory") 
        {
            var bOutboundCallType = aEventParam[0];
            var sCallerName = aEventParam[1];

            var sCallerId = aEventParam[2];
            var sDialNo = aEventParam[3];

            var nStartTime = aEventParam[4];
            var nEndTime = aEventParam[5];

            var nDuration = aEventParam[6];
            var nDayNo = aEventParam[7];
            var nHistoryTypeId = aEventParam[8];

            this.OnAddCallHistory(bOutboundCallType, sCallerName, sCallerId, sDialNo, nStartTime, nEndTime, nDuration, nDayNo, nHistoryTypeId);
        }

        else if (sEventName == "OnBusyLampSubscribeSuccess") 
        {
            var sUserName = aEventParam[0];

            this.OnBusyLampSubscribeSuccess(sUserName);
        }

        else if (sEventName == "OnBusyLampSubscribeFailed") 
        {
            var sUserName = aEventParam[0];
            var nStatusCode = aEventParam[1];
            var sReasonPhrase = aEventParam[2];

            this.OnBusyLampSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
        }

        else if (sEventName == "OnBusyLampContactStatus") 
        {
            var sUserName = aEventParam[0];
            var nStatusId = aEventParam[1];

            this.OnBusyLampContactStatus(sUserName, nStatusId);
        }

        else if (sEventName == "OnIncomingRefreshCallStarted")
        {
            var nLineNo = aEventParam[0];
            var bIsCallTypeOutbound = aEventParam[1];
            var sAudioFlowType = aEventParam[2];
            var sVideoFlowType = aEventParam[3];
            var sSDP = aEventParam[4];

            this.OnIncomingRefreshCallStarted(nLineNo, bIsCallTypeOutbound, sAudioFlowType, sVideoFlowType, sSDP);
        }

        else if (sEventName == "OnIncomingRefreshCallEnded")
        {
            var nLineNo = aEventParam[0];
            var sSDP = aEventParam[1];

            this.OnIncomingRefreshCallEnded(nLineNo, sSDP);
        }
                    
        else if (sEventName == "OnVaxErrorMsg") 
        {
            var sFuncName = aEventParam[0];
            var sErrorMsg = aEventParam[1];
            var nErrorCode = aEventParam[2];

            this.OnVaxErrorMsg(sFuncName, sErrorMsg, nErrorCode);
        }
    }
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////

    this.SetEventMainSIP = function (
        hEventOnInitialized,
        hEventOnVoiceMailMsg,
        hEventOnAudioSessionLost,
        hEventOnAddCallHistory,
        hEventOnVaxErrorMsg
    ) {
        m_hEventOnInitialized = hEventOnInitialized;

        m_hEventOnVoiceMailMsg = hEventOnVoiceMailMsg;
        m_hEventOnAudioSessionLost = hEventOnAudioSessionLost;

        m_hEventOnAddCallHistory = hEventOnAddCallHistory;
        m_hEventOnVaxErrorMsg = hEventOnVaxErrorMsg;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////

    this.OnInitialized = function () {

        m_hEventOnInitialized();
    }
        
    this.OnVoiceMailMsg = function (bIsMsgWaiting, nNewMsgCount, nOldMsgCount, nNewUrgentMsgCount, nOldUrgentMsgCount, sMsgAccount) {
        m_hEventOnVoiceMailMsg(bIsMsgWaiting, nNewMsgCount, nOldMsgCount, nNewUrgentMsgCount, nOldUrgentMsgCount, sMsgAccount);
    }

    this.OnAudioSessionLost = function (nLineNo) {
        m_hEventOnAudioSessionLost(nLineNo);
    }

    this.OnAddCallHistory = function (bOutboundCallType, sCallerName, sCallerId, sDialNo, nStartTime, nEndTime, nDuration, nDayNo, nHistoryTypeId) {
        m_hEventOnAddCallHistory(bOutboundCallType, sCallerName, sCallerId, sDialNo, nStartTime, nEndTime, nDuration, nDayNo, nHistoryTypeId);
    }

    this.OnVaxErrorMsg = function (sFuncName, sErrorMsg, nErrorCode) {
        m_hEventOnVaxErrorMsg(sFuncName, sErrorMsg, nErrorCode);
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////

    this.SetEventRegister = function (hEventConnectingToRegister, hEventTryingToRegister, hEventFailedToRegister, hEventSuccessToRegister, hEventConnectingToReRegister, hEventTryingToReRegister, hEventFailedToReRegister, hEventSuccessToReRegister, hEventTryingToUnRegister, hEventFailedToUnRegister, hEventSuccessToUnRegister) {
        m_hEventConnectingToRegister = hEventConnectingToRegister;
        m_hEventTryingToRegister = hEventTryingToRegister;
        m_hEventFailedToRegister = hEventFailedToRegister;
        m_hEventSuccessToRegister = hEventSuccessToRegister;

        m_hEventConnectingToReRegister = hEventConnectingToReRegister;
        m_hEventTryingToReRegister = hEventTryingToReRegister;
        m_hEventFailedToReRegister = hEventFailedToReRegister;
        m_hEventSuccessToReRegister = hEventSuccessToReRegister;

        m_hEventTryingToUnRegister = hEventTryingToUnRegister;
        m_hEventFailedToUnRegister = hEventFailedToUnRegister;
        m_hEventSuccessToUnRegister = hEventSuccessToUnRegister;
    }

    this.OnConnectingToRegister = function () {
        m_hEventConnectingToRegister();
    }

    this.OnTryingToRegister = function () {
        m_hEventTryingToRegister();
    }

    this.OnSuccessToRegister = function () {
        m_hEventSuccessToRegister();
    }

    this.OnFailedToRegister = function (nStatusCode, sReasonPhrase) {
        m_hEventFailedToRegister(nStatusCode, sReasonPhrase);
    }

    this.OnConnectingToReRegister = function () {
        m_hEventConnectingToReRegister();
    }

    this.OnTryingToReRegister = function () {
        m_hEventTryingToReRegister();
    }

    this.OnSuccessToReRegister = function () {
        m_hEventSuccessToReRegister();
    }

    this.OnFailedToReRegister = function (nStatusCode, sReasonPhrase) {
        m_hEventFailedToReRegister(nStatusCode, sReasonPhrase);
    }

    this.OnTryingToUnRegister = function () {
        m_hEventTryingToUnRegister();
    }

    this.OnSuccessToUnRegister = function () {
        m_hEventSuccessToUnRegister();
    }

    this.OnFailedToUnRegister = function () {
        m_hEventFailedToUnRegister();
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    this.SetEventCall = function (hEventOnHungupCall, hEventOnDigitDTMF)
    {
        m_hEventOnHungupCall = hEventOnHungupCall;
        m_hEventOnDigitDTMF = hEventOnDigitDTMF;
    }

    this.OnHungupCall = function (nLineNo) {
        m_hEventOnHungupCall(nLineNo);
    }

    this.OnDigitDTMF = function (nLineNo, sDigit) {
        m_hEventOnDigitDTMF(nLineNo, sDigit);
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    this.SetEventDialCall = function (
        hEventOnDialCallStarted,
        hEventOnDialingCall,
        hEventOnDialCallFailed,
        hEventOnDialCallConnected,
        hEventOnDialCallRingToneStarted,
        hEventOnDialCallRingToneEnded,
        hEventOnDialCallBusyToneStarted,
        hEventOnDialCallBusyToneEnded
    )
    {
        m_hEventOnDialCallStarted = hEventOnDialCallStarted;
        m_hEventOnDialingCall = hEventOnDialingCall;

        m_hEventOnDialCallFailed = hEventOnDialCallFailed;
        m_hEventOnDialCallConnected = hEventOnDialCallConnected;

        m_hEventOnDialCallRingToneStarted = hEventOnDialCallRingToneStarted;
        m_hEventOnDialCallRingToneEnded = hEventOnDialCallRingToneEnded;

        m_hEventOnDialCallBusyToneStarted = hEventOnDialCallBusyToneStarted;
        m_hEventOnDialCallBusyToneEnded = hEventOnDialCallBusyToneEnded;
    }

    this.OnDialCallStarted = function (nLineNo, sCallerName, sCallerId, sDialNo) {
        m_hEventOnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
    }

    this.OnDialingCall = function (nLineNo, nStatusCode, sReasonPhrase) {
        m_hEventOnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
    }

    this.OnDialCallFailed = function (nLineNo, nStatusCode, sReasonPhrase, sContact) {
        m_hEventOnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase, sContact);
    }

    this.OnDialCallRingToneStarted = function () {
        m_hEventOnDialCallRingToneStarted();
    }

    this.OnDialCallRingToneEnded = function () {
        m_hEventOnDialCallRingToneEnded();
    }

    this.OnDialCallBusyToneStarted = function () {
        m_hEventOnDialCallBusyToneStarted();
    }

    this.OnDialCallBusyToneEnded = function () {
        //m_hEventOnDialCallBusyToneEnded();
    }

    this.OnDialCallConnected = function (nLineNo, sSDP, sToRTPIP, nToRTPPort) {
        m_hEventOnDialCallConnected(nLineNo, sSDP, sToRTPIP, nToRTPPort);
    }
    
    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    this.SetEventIncomingCall = function (
        hEventOnIncomingCallStarted,
        hEventOnIncomingCallEnded,
        hEventOnIncomingCallConnected,
        hEventOnIncomingCallRingToneStarted,
        hEventOnIncomingCallRingToneEnded,
        hEventOnIncomingRefreshCallStarted,
        hEventOnIncomingRefreshCallEnded
    ) {
        m_hEventOnIncomingCallStarted = hEventOnIncomingCallStarted;
        m_hEventOnIncomingCallEnded = hEventOnIncomingCallEnded;

        m_hEventOnIncomingCallConnected = hEventOnIncomingCallConnected;

        m_hEventOnIncomingCallRingToneStarted = hEventOnIncomingCallRingToneStarted;
        m_hEventOnIncomingCallRingToneEnded = hEventOnIncomingCallRingToneEnded;

        m_hEventOnIncomingRefreshCallStarted = hEventOnIncomingRefreshCallStarted;
        m_hEventOnIncomingRefreshCallEnded = hEventOnIncomingRefreshCallEnded;
    }

    this.OnIncomingCallStarted = function (sSDP, sCallId, sCallerName, sCallerId, sDialNo, sFromURI, sToURI) {
        m_hEventOnIncomingCallStarted(sSDP, sCallId, sCallerName, sCallerId, sDialNo, sFromURI, sToURI);
    }

    this.OnIncomingCallEnded = function (sCallId) {
        m_hEventOnIncomingCallEnded(sCallId);
    }

    this.OnIncomingCallConnected = function (nLineNo, sToRTPIP, nToRTPPort) {
        m_hEventOnIncomingCallConnected(nLineNo, sToRTPIP, nToRTPPort);
    }

    this.OnIncomingCallRingToneStarted = function (sCallId) {
        m_hEventOnIncomingCallRingToneStarted(sCallId);
    }

    this.OnIncomingCallRingToneEnded = function (sCallId) {
        m_hEventOnIncomingCallRingToneEnded(sCallId);
    }

    this.OnIncomingRefreshCallStarted = function (nLineNo, sAudioFlowType, sVideoFlowType, sSDP) {
        m_hEventOnIncomingRefreshCallStarted(nLineNo, sAudioFlowType, sVideoFlowType, sSDP);
    }

    this.OnIncomingRefreshCallEnded = function (nLineNo, sSDP) {
        m_hEventOnIncomingRefreshCallEnded(nLineNo, sSDP);
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    this.SetEventHold = function (
        hEventOnTryingToHold,
        hEventOnFailedToHold,
        hEventOnSuccessToHold,
        hEventOnTryingToUnHold,
        hEventOnFailedToUnHold,
        hEventOnSuccessToUnHold
    ) {
        m_hEventOnTryingToHold = hEventOnTryingToHold;
        m_hEventOnFailedToHold = hEventOnFailedToHold;
        m_hEventOnSuccessToHold = hEventOnSuccessToHold;
        m_hEventOnTryingToUnHold = hEventOnTryingToUnHold;
        m_hEventOnFailedToUnHold = hEventOnFailedToUnHold;
        m_hEventOnSuccessToUnHold = hEventOnSuccessToUnHold;
    }

    this.OnTryingToHold = function (nLineNo) {
        m_hEventOnTryingToHold(nLineNo);
    }

    this.OnFailedToHold = function (nLineNo) {
        m_hEventOnFailedToHold(nLineNo);
    }

    this.OnSuccessToHold = function (nLineNo) {
        m_hEventOnSuccessToHold(nLineNo);
    }

    this.OnTryingToUnHold = function (nLineNo) {
        m_hEventOnTryingToUnHold(nLineNo);
    }

    this.OnFailedToUnHold = function (nLineNo) {
        m_hEventOnFailedToUnHold(nLineNo);
    }

    this.OnSuccessToUnHold = function (nLineNo) {
        m_hEventOnSuccessToUnHold(nLineNo);
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    this.SetEventChat = function (
        hEventOnChatContactStatus,
        hEventOnChatRecvMsgText,
        hEventOnChatSendMsgTextFailed,
        hEventOnChatSendMsgTextSuccess,
        hEventOnChatSendMsgTypingFailed,
        hEventOnChatSendMsgTypingSuccess,
        hEventOnChatRecvMsgTypingStart,
        hEventOnChatRecvMsgTypingStop
    ) {
        m_hEventOnChatContactStatus = hEventOnChatContactStatus;
        m_hEventOnChatRecvMsgText = hEventOnChatRecvMsgText;

        m_hEventOnChatSendMsgTextFailed = hEventOnChatSendMsgTextFailed;
        m_hEventOnChatSendMsgTextSuccess = hEventOnChatSendMsgTextSuccess;
        
        m_hEventOnChatSendMsgTypingFailed = hEventOnChatSendMsgTypingFailed;
        m_hEventOnChatSendMsgTypingSuccess = hEventOnChatSendMsgTypingSuccess;
        
        m_hEventOnChatRecvMsgTypingStart = hEventOnChatRecvMsgTypingStart;
        m_hEventOnChatRecvMsgTypingStop = hEventOnChatRecvMsgTypingStop;
    }

    this.OnChatContactStatus = function (sUserName, nStatusId) {
        m_hEventOnChatContactStatus(sUserName, nStatusId);
    }

    this.OnChatRecvMsgText = function (sUserName, sMsgText, bIsChatContact) {
        m_hEventOnChatRecvMsgText(sUserName, sMsgText, bIsChatContact);
    }
        
    this.OnChatSendMsgTextFailed = function (sUserName, nStatusCode, sReasonPhrase, sMsgText, nUserValue32bit) {
        m_hEventOnChatSendMsgTextFailed(sUserName, nStatusCode, sReasonPhrase, sMsgText, nUserValue32bit);
    }

    this.OnChatSendMsgTextSuccess = function (sUserName, sMsgText, nUserValue32bit) {
        m_hEventOnChatSendMsgTextSuccess(sUserName, sMsgText, nUserValue32bit);
    }
        
    this.OnChatSendMsgTypingFailed = function (sUserName, nStatusCode, sReasonPhrase, nUserValue32bit) {
        m_hEventOnChatSendMsgTypingFailed(sUserName, nStatusCode, sReasonPhrase, nUserValue32bit);
    }

    this.OnChatSendMsgTypingSuccess = function (sUserName, nUserValue32bit) {
        m_hEventOnChatSendMsgTypingSuccess(sUserName, nUserValue32bit);
    }

    this.OnChatRecvMsgTypingStart = function (sUserName) {
        m_hEventOnChatRecvMsgTypingStart(sUserName);
    }

    this.OnChatRecvMsgTypingStop = function (sUserName) {
        m_hEventOnChatRecvMsgTypingStop(sUserName);
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    this.SetEventBusyLamp = function (
        hEventBusyLampSubscribeFailed,
        hEventBusyLampSubscribeSuccess,
        hEventBusyLampContactStatus
    ) {
        m_hEventBusyLampSubscribeFailed = hEventBusyLampSubscribeFailed;
        m_hEventBusyLampSubscribeSuccess = hEventBusyLampSubscribeSuccess;
        m_hEventBusyLampContactStatus = hEventBusyLampContactStatus;
    }

    this.OnBusyLampSubscribeFailed = function (sUserName, nStatusCode, sReasonPhrase) {
        m_hEventBusyLampSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
    }

    this.OnBusyLampSubscribeSuccess = function (sUserName) {
        m_hEventBusyLampSubscribeSuccess(sUserName);
    }

    this.OnBusyLampContactStatus = function (sUserName, nStatusId) {
        m_hEventBusyLampContactStatus(sUserName, nStatusId);
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    this.SetEventTransferCall = function (hEventOnTransferCallFailed, hEventOnTransferCallAccepted) {
        m_hEventOnTransferCallFailed = hEventOnTransferCallFailed;
        m_hEventOnTransferCallAccepted = hEventOnTransferCallAccepted;
    }

    this.OnTransferCallFailed = function (nLineNo, nStatusCode, sReasonPhrase) {
        m_hEventOnTransferCallFailed(nLineNo, nStatusCode, sReasonPhrase);
    }

    this.OnTransferCallAccepted = function (nLineNo) {
        m_hEventOnTransferCallAccepted(nLineNo);
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////
}