﻿
// Class cVaxBusyLamp

function cVaxBusyLamp()
{
    this.OnLoadPage = function ()
    {
        m_objVaxWebPhoneLib.SetEventMainSIP(OnInitialized, OnUnInitialized, null, null, null, null);

        m_objVaxWebPhoneLib.SetEventRegister(null, null, null, OnSuccessToRegister, null, null, null, null, null, null, null);
        m_objVaxWebPhoneLib.SetEventBusyLamp(OnBusyLampSubscribeFailed, OnBusyLampSubscribeSuccess, OnBusyLampContactStatus);
    }
       
    function OnInitialized()
    {
    
    }

    function OnUnInitialized()
    {
        ListBusyLampStatusLog.value = "";
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    this.BtnBusyLampAddContact_onclick = function()
    {
        if(EditBusyLampContactName.value == "")
		    return;
		
        m_objVaxWebPhoneLib.BusyLampAddContact(EditBusyLampContactName.value);
                
        ListBusyLampContacts.options[ListBusyLampContacts.options.length] = new Option(EditBusyLampContactName.value, EditBusyLampContactName.value);

        if (ListBusyLampContacts.selectedIndex == -1)
            ListBusyLampContacts.selectedIndex = 0;

        EditBusyLampContactName.value = "";
    }

    this.BtnBusyLampRemoveContact_onclick = function()
    {
        if (ListBusyLampContacts.selectedIndex == -1) return;
        var sContactName = ListBusyLampContacts.options[ListBusyLampContacts.selectedIndex].value;
                
        m_objVaxWebPhoneLib.BusyLampRemoveContact(sContactName);
        ListBusyLampContacts.remove(ListBusyLampContacts.selectedIndex);
    }
       
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    function GetStatusText(nStatusId)
    {	
        var sStatusText = "";

        switch (nStatusId)
        {
            case 0:
                sStatusText = "Free";
                break;

            case 1:
                sStatusText = "Offline";
                break;

            case 2:
                sStatusText = "Busy";
                break;

            case 3:
                sStatusText = "Busy";
                break;
                      
            case 4:
                sStatusText = "UnKnown";
                break;
        }

        return sStatusText;
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
        
    function AddBusyLampLog(sStatus)
    {
        if (ListBusyLampStatusLog.value.length == 0)
            ListBusyLampStatusLog.value = ListBusyLampStatusLog.value + sStatus;
        else
            ListBusyLampStatusLog.value = ListBusyLampStatusLog.value + "\n" + sStatus;

        ListBusyLampStatusLog.scrollTop = ListBusyLampStatusLog.scrollHeight;
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    this.BtnBusyLampClearStatusLog_onclick = function ()
    {
        ListBusyLampStatusLog.value = "";
    }
        
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    function OnBusyLampContactStatus(sUserName, nStatusId)
    {	
        for (nContactCount = 0; nContactCount < ListBusyLampContacts.length; nContactCount++)
        {
            var sContactName = ListBusyLampContacts.options[nContactCount].text.toUpperCase();

            if (sContactName.indexOf(sUserName.toUpperCase()) != -1)
            {
                ListBusyLampContacts.options[nContactCount].text = sUserName + " [" + GetStatusText(nStatusId) + "]";
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    function OnSuccessToRegister()
    {
        for (nContactCount = 0; nContactCount < ListBusyLampContacts.length; nContactCount++)
        {
            var sContactName = ListBusyLampContacts.options[nContactCount].value;
            m_objVaxWebPhoneLib.BusyLampAddContact(sContactName);
            
        }
    }

    function OnBusyLampSubscribeSuccess(sUserName)
    {
        AddBusyLampLog("BusyLamp Subscribe " + sUserName + " Success");
    }

    function OnBusyLampSubscribeFailed(sUserName, nStatusCode, sReasonPhrase)
    {
        AddBusyLampLog("BusyLamp Subscribe " + sUserName + " Failed");
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
};