﻿// Class cVaxPhoneTone

function cVaxPhoneTone()
{
    CheckPlayDialTone.checked = true;
    CheckPlayRingTone.checked = true;

    var m_hRingTone = null; 
    var m_hDialTone = null; 
    var m_hBusyTone = null; 

    this.OnLoadPage = function ()
    {
        m_objVaxWebPhoneLib.SetEventMainSIP(OnInitialized, OnUnInitialized, null, null, null, null);

        m_objVaxWebPhoneLib.SetEventDialCall(null, null, null, null, OnDialCallRingToneStarted, OnDialCallRingToneEnded, OnDialCallBusyToneStarted, OnDialCallBusyToneEnded);
        m_objVaxWebPhoneLib.SetEventIncomingCall(null, null, OnIncomingCallAccepted, OnIncomingCallRejected, null, OnIncomingCallRingToneStarted, OnIncomingCallRingToneEnded, null, null);
    }

    function OnInitialized() {
        m_hRingTone = null;
        m_hDialTone = null;
        m_hBusyTone = null;
    }

    function OnUnInitialized() {
        PlayStopDialTone();
        PlayStopRingTone();
        PlayStopBusyTone();
    }

    ///////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////
        
    function PlayStartDialTone()
    {
        PlayStopDialTone();

        m_hDialTone = m_objVaxWebPhoneLib.PlayMediaStartFile("AudioWeb/DialTone.wav", true);
    }

    function PlayStopDialTone()
    {
        if(m_hDialTone == null)
            return;

        m_objVaxWebPhoneLib.PlayMediaStopFile(m_hDialTone);
        m_hDialTone = null;
    }

    ///////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////

    function PlayStartBusyTone()
    {
        PlayStopBusyTone();
                
        m_hBusyTone = m_objVaxWebPhoneLib.PlayMediaStartFile("AudioWeb/BusyTone.wav", true);
    }

    function PlayStopBusyTone()
    {
        if(m_hBusyTone == null)
            return;

        m_objVaxWebPhoneLib.PlayMediaStopFile(m_hBusyTone);
        m_hBusyTone = null;
    }

    ///////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////

    function PlayStartRingTone()
    {
        PlayStopRingTone();

        m_hRingTone = m_objVaxWebPhoneLib.PlayMediaStartFile("AudioWeb/RingTone.mp3", true);
    }

    function PlayStopRingTone() 
    {
        if(m_hRingTone == null)
            return;

        m_objVaxWebPhoneLib.PlayMediaStopFile(m_hRingTone);
        m_hRingTone = null;
    }

    ///////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////

    this.CheckPlayDialTone_onclick = function () 
    {
        if (!CheckPlayDialTone.checked)
        {
            PlayStopDialTone();
            PlayStopBusyTone();
        }
    }

    this.CheckPlayRingTone_onclick = function () 
    {
        if (!CheckPlayRingTone.checked)
        {
            PlayStopRingTone();
        }
    }

    ///////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////

    function StartDialTone() 
    {
        if (CheckPlayDialTone.checked)
        {
            PlayStartDialTone();
        }
    }

    function StopDialTone() 
    {
        PlayStopDialTone();
    }

    function StartBusyTone() 
    {
        if (CheckPlayDialTone.checked)
        {
            PlayStartBusyTone();
        }
    }

    function StopBusyTone() 
    {
        PlayStopBusyTone();
    }

    ///////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////

    function StartRingTone() 
    {
        if (CheckPlayRingTone.checked)
        {
            PlayStartRingTone();
        }
    }

    function StopRingTone() 
    {
        PlayStopRingTone();
    }

    ///////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////

    function OnDialCallRingToneStarted()
    {
        StartDialTone();
    }

    function OnDialCallRingToneEnded()
    {
        StopDialTone();
    }

    function OnDialCallBusyToneStarted()
    {
        StartBusyTone();
    }

    function OnDialCallBusyToneEnded()
    {
        StopBusyTone();
    }

    ///////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////

    function OnIncomingCallAccepted(sCallId)
    {
        StopRingTone();
    }

    function OnIncomingCallRejected(sCallId)
    {
        StopRingTone();
    }

    function OnIncomingCallRingToneStarted()
    {
        StartRingTone();
    }

    function OnIncomingCallRingToneEnded(sCallId)
    {
        StopRingTone();
    }


    ///////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////

};