#pragma once
#include "afxwin.h"

///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

#import "VaxServerWebRTC.dll" rename_namespace("VaxServerWebRTC")

using namespace VaxServerWebRTC;

#define VAX_PAUSE_FLOW_MODE_TYPE  0
#define VAX_STOP_FLOW_MODE_TYPE   1

class CVaxServerWebRTC : public CCmdTarget
{
	DECLARE_DYNCREATE(CVaxServerWebRTC)

public:
	CVaxServerWebRTC();
	~CVaxServerWebRTC();

public:

	DWORD m_dwCookie;
	
	_IServerWebRTCEvents* m_pVaxEvents;
	IServerWebRTC* m_pVaxSIP;

	//------------------------------------------------------------------------------------------------------------------
	//-------------------------------			Functions Added
	//------------------------------------------------------------------------------------------------------------------
	
	BOOL LoadObjectCOM();
	void UnLoadObjectCOM();
	BOOL IsLoadedObjectCOM();

public:

	CString GetVersionFile();
	CString GetVersionSDK();

	BOOL SetLicenceKey(LPCTSTR LicenceKey);

	int GetVaxErrorCode();
	CString GetVaxErrorMsg();
	
	BOOL Initialize(LPCTSTR sListenIP, int nListenPort, LPCTSTR sCertPEM, LPCTSTR sPathURL);
	void UnInitialize();

	BOOL KeepAlive(BOOL bEnable, int nSeconds);
	int GetClientCount();

	BOOL GetStartListenIP();
	CString GetNextListenIP();

	CString BuildWebSocketURL();
	BOOL RegisterWebSocketIP();

	BOOL SetListenPortRangeRTP(int nPortMinWebRTC, int nPortMaxWebRTC, int nPortMinSIP, int nPortMaxSIP);
	
	BOOL AddNetworkRouteWebRTC(LPCTSTR sAssignedIP, LPCTSTR sRouterIP);
	BOOL AdjustVideoFlowMode(int nModeType);
	
public:

	afx_msg virtual void OnFinalRelease();


///////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////

public:
		
	virtual void OnVaxErrorLog(LPCTSTR sFuncName, LPCTSTR sErrorMsg, int nErrorCode);
	
	DECLARE_MESSAGE_MAP()
	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CVaxServerWebRTC)
						
	//}}AFX_DISPATCH

	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()

};

