#include "StdAfx.h"
#include "VaxServerWebRTC.h"
#include <afxctl.h>


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
extern "C"{
#endif 

#ifndef __IID_DEFINED__
#define __IID_DEFINED__

typedef struct _IID
{
    unsigned long x;
    unsigned short s1;
    unsigned short s2;
    unsigned char  c[8];
} IID;

#endif // __IID_DEFINED__

#ifndef CLSID_DEFINED
#define CLSID_DEFINED
typedef IID CLSID;
#endif // CLSID_DEFINED

const IID LIBID_VaxServerWebRTCLib  = {0xB65253E0,0xB348,0x4A79,{0xA5,0xAA,0x10,0x2E,0xCE,0xEA,0x5A,0xB7}};
const IID DIID__IServerWebRTCEvents = {0xDA3E679E,0x47E1,0x4B57,{0x84,0x10,0x55,0xB8,0x89,0xC6,0xDF,0xAF}};;
const IID IID_IServerWebRTC         = {0x88DBAB10,0xC234,0x4EEB,{0xA6,0x9E,0xE1,0x90,0x4D,0x19,0xC0,0xDA}};
const CLSID CLSID_ServerWebRTC      = {0xFDFE23BD,0x635F,0x427A,{0xBC,0xFC,0x19,0xD7,0x38,0x07,0x3A,0x6A}};

#ifdef __cplusplus
}
#endif

IMPLEMENT_DYNCREATE(CVaxServerWebRTC, CCmdTarget)

CVaxServerWebRTC::CVaxServerWebRTC()
{
	EnableAutomation();
	
	m_pVaxSIP = NULL;
	m_pVaxEvents = NULL;

	LoadObjectCOM();
}

CVaxServerWebRTC::~CVaxServerWebRTC()
{
	//UnInitialize();
	UnLoadObjectCOM();
}


void CVaxServerWebRTC::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CVaxServerWebRTC, CCmdTarget)
	//{{AFX_MSG_MAP(CVaxServerWebRTC)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CVaxServerWebRTC, CCmdTarget)
	
	DISP_FUNCTION(CVaxServerWebRTC, "OnVaxErrorLog", OnVaxErrorLog, VT_EMPTY, VTS_BSTR VTS_I4 VTS_BSTR)
			
END_DISPATCH_MAP()

// Note: we add support for IID_IVaxServerSIP to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {3DB0F857-BB81-4371-A80C-C4CB971721D1}
//static const IID IID_IVaxServerSIP =
//{ 0x3db0f857, 0xbb81, 0x4371, { 0xa8, 0xc, 0xc4, 0xcb, 0x97, 0x17, 0x21, 0xd1 } };

BEGIN_INTERFACE_MAP(CVaxServerWebRTC, CCmdTarget)
	INTERFACE_PART(CVaxServerWebRTC, DIID__IServerWebRTCEvents, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVaxServerWebRTC message handlers

void CVaxServerWebRTC::UnLoadObjectCOM()
{
	if(m_pVaxSIP)
	{
		m_pVaxSIP->Release();
		m_pVaxSIP = NULL;
	}

	if(m_pVaxEvents)
	{
		LPUNKNOWN pUnk = GetIDispatch(FALSE);
		AfxConnectionUnadvise(m_pVaxEvents, DIID__IServerWebRTCEvents, pUnk, FALSE, m_dwCookie);

		m_pVaxEvents->Release();
		m_pVaxEvents = NULL;
	}
}

BOOL CVaxServerWebRTC::LoadObjectCOM()
{
	UnLoadObjectCOM();

	CoInitialize(NULL);
	
	HRESULT hr = CoCreateInstance(CLSID_ServerWebRTC, NULL, CLSCTX_INPROC_SERVER, IID_IDispatch, (void**) &m_pVaxEvents);
	if(FAILED(hr)) return FALSE;

	m_pVaxEvents->QueryInterface(IID_IServerWebRTC, (void**) &m_pVaxSIP);
	
	m_dwCookie = 1;
		
	LPUNKNOWN pUnk = GetIDispatch(FALSE);

	if(!AfxConnectionAdvise(m_pVaxEvents, DIID__IServerWebRTCEvents, pUnk, FALSE, &m_dwCookie))
	{
		return FALSE;
	}

	return TRUE;
}

BOOL CVaxServerWebRTC::IsLoadedObjectCOM()
{
	if(m_pVaxSIP == NULL)	
	{
		OnVaxErrorLog("", "Unable to load VaxServerWebRTC.dll COM component. Run command prompt as administrator, register the COM using regsvr32 command and try again.\n\n e.g. regsvr32 VaxServerWebRTC.dll", -1);
		return FALSE;
	}

	return TRUE;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

CString CVaxServerWebRTC::GetVersionFile()
{
	if(!IsLoadedObjectCOM())
		return "";

	return CString((BSTR) m_pVaxSIP->GetVersionFile());
}
	
CString CVaxServerWebRTC::GetVersionSDK()
{
	if(!IsLoadedObjectCOM())
		return "";

	return CString((BSTR) m_pVaxSIP->GetVersionSDK());
}
	
BOOL CVaxServerWebRTC::SetLicenceKey(LPCTSTR LicenceKey)
{
	if(!IsLoadedObjectCOM())
		return FALSE;

	return m_pVaxSIP->SetLicenceKey(LicenceKey);
}

int CVaxServerWebRTC::GetVaxErrorCode()
{
	if(!IsLoadedObjectCOM())
		return -1;

	return m_pVaxSIP->GetVaxErrorCode();
}
	
CString CVaxServerWebRTC::GetVaxErrorMsg()
{
	if(!IsLoadedObjectCOM())
		return "";

	return CString((BSTR) m_pVaxSIP->GetVaxErrorMsg());
}
	
BOOL CVaxServerWebRTC::Initialize(LPCTSTR sListenIP, int nListenPort, LPCTSTR sCertPEM, LPCTSTR sPathURL)
{
	if(!IsLoadedObjectCOM())
		return FALSE;

	return m_pVaxSIP->Initialize(sListenIP, nListenPort, sCertPEM, sPathURL);
}
	
void CVaxServerWebRTC::UnInitialize()
{
	if(!IsLoadedObjectCOM())
		return;

	m_pVaxSIP->UnInitialize();
}

BOOL CVaxServerWebRTC::KeepAlive(BOOL bEnable, int nSeconds)
{
	return m_pVaxSIP->KeepAlive(bEnable, nSeconds);
}

int CVaxServerWebRTC::GetClientCount()
{
	if(!IsLoadedObjectCOM())
		return 0;

	return m_pVaxSIP->GetClientCount();
}

BOOL CVaxServerWebRTC::GetStartListenIP()
{
	if(!IsLoadedObjectCOM())
		return FALSE;

	return m_pVaxSIP->GetStartListenIP();
}
	
CString CVaxServerWebRTC::GetNextListenIP()
{
	if(!IsLoadedObjectCOM())
		return "";

	return CString((BSTR) m_pVaxSIP->GetNextListenIP());
}
	
CString CVaxServerWebRTC::BuildWebSocketURL()
{
	if(!IsLoadedObjectCOM())
		return "";

	return CString((BSTR) m_pVaxSIP->BuildWebSocketURL());
}

BOOL CVaxServerWebRTC::RegisterWebSocketIP()
{
	if(!IsLoadedObjectCOM())
		return FALSE;

	return m_pVaxSIP->RegisterWebSocketIP();
}

BOOL CVaxServerWebRTC::SetListenPortRangeRTP(int nPortMinWebRTC, int nPortMaxWebRTC, int nPortMinSIP, int nPortMaxSIP)
{
	if(!IsLoadedObjectCOM())
		return FALSE;

	return m_pVaxSIP->SetListenPortRangeRTP(nPortMinWebRTC, nPortMaxWebRTC, nPortMinSIP, nPortMaxSIP);
}

BOOL CVaxServerWebRTC::AddNetworkRouteWebRTC(LPCTSTR sAssignedIP, LPCTSTR sRouterIP)
{
	if(!IsLoadedObjectCOM())
		return FALSE;

	return m_pVaxSIP->AddNetworkRouteWebRTC(sAssignedIP, sRouterIP);
}

BOOL CVaxServerWebRTC::AdjustVideoFlowMode(int nModeType)
{
	if(!IsLoadedObjectCOM())
		return FALSE;

	return m_pVaxSIP->AdjustVideoFlowMode(nModeType);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CVaxServerWebRTC::OnVaxErrorLog(LPCTSTR sFuncName, LPCTSTR sErrorMsg, int nErrorCode)
{
}

