
// ServerWebRTCDlg.cpp : implementation file
//

#include "stdafx.h"
#include "afxdialogex.h"
#include "ServerWebRTC.h"
#include "ServerWebRTCDlg.h"
#include "ClipBoard.h"
#include "VaxServerWebRTCEx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CServerWebRTCDlg dialog


CServerWebRTCDlg::CServerWebRTCDlg(CWnd* pParent /*=NULL*/) : CDialogEx(CServerWebRTCDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pServerWebRTC = new CVaxServerWebRTCEx();
	m_pServerWebRTC->m_pMainDlg = this;

	m_bServerStarted = FALSE;

	m_sDemoWebPhoneURL = "https://www.vaxvoip.com/WebPhoneSDK/DemoWeb/DemoPhone.html";
	m_sLicenseKeyURL = "https://www.vaxvoip.com/WebPhoneSDK/KeyVaxVoIP/wOSv5/KeyBindWebRTC";
}

void CServerWebRTCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BTN_STARTSERVER, m_BtnStartServer);
	DDX_Text(pDX, IDC_EDIT_DEMOURL, m_sDemoWebPhoneURL);
	DDX_Text(pDX, IDC_EDIT_LICENSEURL, m_sLicenseKeyURL);
}

BEGIN_MESSAGE_MAP(CServerWebRTCDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_STARTSERVER, &CServerWebRTCDlg::OnBnClickedBtnStartserver)
	ON_BN_CLICKED(IDC_BTN_COPYDEMO_URL, &CServerWebRTCDlg::OnBnClickedBtnCopyDemoUrl)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_COPY_LICENSE_URL, &CServerWebRTCDlg::OnBnClickedBtnCopyLicenseUrl)
END_MESSAGE_MAP()


// CServerWebRTCDlg message handlers

BOOL CServerWebRTCDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();
			
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	ApplyFont();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CServerWebRTCDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CServerWebRTCDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CServerWebRTCDlg::OnBnClickedBtnStartserver()
{
	UpdateData(TRUE);
	
	if (m_bServerStarted == TRUE)
	{
		m_BtnStartServer.SetWindowText("Start VaxServerWebRTC");
		m_bServerStarted = FALSE;

		m_pServerWebRTC->UnInitialize();
		return;
	}
		
	if(!m_pServerWebRTC->Initialize("", 8080, "", ""))
	{
		CString sErrorMsg = m_pServerWebRTC->GetVaxErrorMsg();
		MessageBox("Unable to start the server WebRTC. " + sErrorMsg, "VaxVoIP SIP SDK", MB_OK | MB_ICONEXCLAMATION);

		return;
	}

	m_pServerWebRTC->SetListenPortRangeRTP(40000, 44000, 46000, 50000);
	m_pServerWebRTC->RegisterWebSocketIP();
	
	m_BtnStartServer.SetWindowText("Stop VaxServerWebRTC");
	m_bServerStarted = TRUE;

	UpdateData(FALSE);
}

void CServerWebRTCDlg::OnBnClickedBtnCopyDemoUrl()
{
	CClipBoard objClipBoard;
	objClipBoard.WriteText(m_sDemoWebPhoneURL);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CServerWebRTCDlg::OnVaxErrorLog(LPCTSTR sFuncName, LPCTSTR sErrorMsg, int nErrorCode)
{
	MessageBox(sErrorMsg, "VaxVoIP SIP SDK", MB_OK | MB_ICONEXCLAMATION);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

void CServerWebRTCDlg::ApplyFont()
{
	LOGFONT logFont;
	CWnd* pGroupBox;
	CFont* pFont;

	CFont objFont;
	objFont.CreateFontIndirect(&logFont);  
	
	pGroupBox = GetDlgItem(IDC_STATIC_STEP_1);
	pFont = pGroupBox->GetFont();        
	pFont->GetLogFont(&logFont);       
	logFont.lfWeight = FW_BOLD;
	pGroupBox->SetFont(&objFont); 

	pGroupBox = GetDlgItem(IDC_STATIC_STEP_2);
	pFont = pGroupBox->GetFont();        
	pFont->GetLogFont(&logFont);       
	logFont.lfWeight = FW_BOLD;
	pGroupBox->SetFont(&objFont); 

	pGroupBox = GetDlgItem(IDC_STATIC_STEP_3);
	pFont = pGroupBox->GetFont();        
	pFont->GetLogFont(&logFont);       
	logFont.lfWeight = FW_BOLD;
	pGroupBox->SetFont(&objFont); 
			
	pGroupBox = GetDlgItem(IDC_STATIC_STEP_4);
	pFont = pGroupBox->GetFont();        
	pFont->GetLogFont(&logFont);       
	logFont.lfWeight = FW_BOLD;
	pGroupBox->SetFont(&objFont); 

	pGroupBox = GetDlgItem(IDC_STATIC_STEP_5);
	pFont = pGroupBox->GetFont();        
	pFont->GetLogFont(&logFont);       
	logFont.lfWeight = FW_BOLD;
	pGroupBox->SetFont(&objFont);
			
	pGroupBox = GetDlgItem(IDC_STATIC_IMPOTANT_MSG);
	pFont = pGroupBox->GetFont();        
	pFont->GetLogFont(&logFont);       
	logFont.lfWeight = FW_BOLD;
	pGroupBox->SetFont(&objFont); 

	pGroupBox = GetDlgItem(IDC_STATIC_STEP_USE_LICENSE);
	pFont = pGroupBox->GetFont();
	pFont->GetLogFont(&logFont);
	logFont.lfWeight = FW_BOLD;
	pGroupBox->SetFont(&objFont);
}


void CServerWebRTCDlg::OnDestroy()
{
	CDialogEx::OnDestroy();
	delete m_pServerWebRTC;
}

void CServerWebRTCDlg::OnOK()
{
}


void CServerWebRTCDlg::OnBnClickedBtnCopyLicenseUrl()
{
	CClipBoard objClipBoard;
	objClipBoard.WriteText(m_sLicenseKeyURL);
}
