﻿
// Class cVaxSetting

const VAX_DTMF_TYPE_RFC2833 = 0;
const VAX_DTMF_TYPE_SIP_INFO = 1;
const VAX_DTMF_TYPE_INBAND = 2;

function cVaxSetting() 
{
    RadioForceNone.checked = true;

    this.OnLoadPage = function ()
    {
        m_objVaxWebPhoneLib.SetEventMainSIP(OnInitialized, OnUnInitialized, null, null, null, null);
    }

    function OnInitialized()
    {	
        ActivateDigitDTMF();

        AddAudioInputDevices();
        AddAudioOutputDevices();
        
        m_objVaxWebPhoneLib.AttachDetectMediaChange(OnChangeMediaDevices);
    }

    function OnUnInitialized()
    {
    
    }

    ////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////

    this.RadioForceNone_Click = function () 
    {
        ActivateDigitDTMF();
    }

    this.RadioForceInbandDTMF_Click = function () 
    {
        ActivateDigitDTMF();
    }

    this.RadioForceRfc2833DTMF_Click = function () 
    {
        ActivateDigitDTMF();
    }

    this.RadioForceInfoDTMF_Click = function () 
    {
        ActivateDigitDTMF();
    }
            
    
    ////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////

    function ActivateDigitDTMF() 
    {
        if (RadioForceNone.checked) 
        {
            m_objVaxWebPhoneLib.ForceDigitDTMF(VAX_DTMF_TYPE_RFC2833, true);
        }

        else if (RadioForceInbandDTMF.checked)
        {
            m_objVaxWebPhoneLib.ForceDigitDTMF(VAX_DTMF_TYPE_INBAND, RadioForceInbandDTMF.checked);
        }

        else if (RadioForceRfc2833DTMF.checked)
        {
            m_objVaxWebPhoneLib.ForceDigitDTMF(VAX_DTMF_TYPE_RFC2833, RadioForceRfc2833DTMF.checked); 
        }

        else if (RadioForceInfoDTMF.checked)
        {
            m_objVaxWebPhoneLib.ForceDigitDTMF(VAX_DTMF_TYPE_SIP_INFO, RadioForceInfoDTMF.checked);
        }
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    async function AddAudioInputDevices()
    {
        var aDeviceNames = [];
        var aDeviceIds = [];

        let sDefaultName = '';
        let sDefaultID = '';

        let vDefault = { name: sDefaultName, id: sDefaultID };

        await m_objVaxWebPhoneLib.GetAudioInputDeviceList(aDeviceNames, aDeviceIds, vDefault);

        if (aDeviceNames.length == 0)
        {
            SetCookie('AudioInputDeviceName', '');
            SetCookie('AudioInputDeviceId', '');

            return;
        }

        var select = document.getElementById("ComboAudioInputDevices");
        select.innerHTML = '';
                
        for (let nIndex = 0; nIndex < aDeviceNames.length; nIndex++)
        {
            var newOption = document.createElement("option");

            newOption.text = aDeviceNames[nIndex];
            newOption.value = aDeviceIds[nIndex];
            
            select.appendChild(newOption);
        }
        
        var sDeviceName = GetCookie('AudioInputDeviceName');
        var sDeviceId = GetCookie('AudioInputDeviceId');
                        
        if (sDeviceName != null && sDeviceName != '')
        {
            var bFound = false;

            for (var nIndex = 0; nIndex < select.options.length; nIndex++)
            {
                if (select.options[nIndex].text === sDeviceName && select.options[nIndex].value === sDeviceId)
                {
                    bFound = true;

                    select.selectedIndex = nIndex;
                    break;
                }
            }

            if (bFound == false)
            {
                sDeviceName = '';
                sDeviceId = '';

                SetCookie('AudioInputDeviceName', '');
                SetCookie('AudioInputDeviceId', '');
            }
        }
        else
        {
            sDeviceName = '';
            sDeviceId = '';

            for (var nIndex = 0; nIndex < select.options.length; nIndex++)
            {
                if (select.options[nIndex].text === vDefault.name)
                {
                    select.selectedIndex = nIndex;
                    break;
                }
            }
        }

        m_objVaxWebPhoneLib.SetActiveAudioInputDevice(sDeviceName, sDeviceId);
    }

    async function AddAudioOutputDevices()
    {
        var aDeviceNames = [];
        var aDeviceIds = [];

        let sDefaultName = '';
        let sDefaultID = '';

        let vDefault = { name: sDefaultName, id: sDefaultID };
                
        await m_objVaxWebPhoneLib.GetAudioOutputDeviceList(aDeviceNames, aDeviceIds, vDefault);
                
        if (aDeviceNames.length == 0)
        {
            SetCookie('AudioOutputDeviceName', '');
            SetCookie('AudioOutputDeviceId', '');

            return;
        }
                        
        var select = document.getElementById("ComboAudioOutputDevices");
        select.innerHTML = '';
                
        for (let nIndex = 0; nIndex < aDeviceNames.length; nIndex++)
        {
            var newOption = document.createElement("option");

            newOption.text = aDeviceNames[nIndex];
            newOption.value = aDeviceIds[nIndex];

            select.appendChild(newOption);
        }

        var sDeviceName = GetCookie('AudioOutputDeviceName');
        var sDeviceId = GetCookie('AudioOutputDeviceId');
                
        if (sDeviceName != null && sDeviceName != '')
        {
            var bFound = false;

            for (var nIndex = 0; nIndex < select.options.length; nIndex++)
            {
                if (select.options[nIndex].text === sDeviceName && select.options[nIndex].value === sDeviceId)
                {
                    bFound = true;

                    select.selectedIndex = nIndex;
                    break;
                }
            }

            if (bFound == false)
            {
                sDeviceName = '';
                sDeviceId = '';

                SetCookie('AudioOutputDeviceName', '');
                SetCookie('AudioOutputDeviceId', '');
            }
        }
        else
        {
            sDeviceName = '';
            sDeviceId = '';

            for (var nIndex = 0; nIndex < select.options.length; nIndex++)
            {
                if (select.options[nIndex].text === vDefault.name)
                {
                    select.selectedIndex = nIndex;
                    break;
                }
            }
        }

        m_objVaxWebPhoneLib.SetActiveAudioOutputDevice(sDeviceName, sDeviceId);
    }
        
    this.ComboAudioInputDevices_onchange = function ()
    {
        if (ComboAudioInputDevices.selectedIndex == -1)
            return;
                
        var sDeviceName = ComboAudioInputDevices.options[ComboAudioInputDevices.selectedIndex].text;
        var sDeviceId = ComboAudioInputDevices.options[ComboAudioInputDevices.selectedIndex].value;
                
        if (sDeviceId == 'default')
        {
            SetCookie('AudioInputDeviceName', '');
            SetCookie('AudioInputDeviceId', '');

            m_objVaxWebPhoneLib.SetActiveAudioInputDevice(sDeviceName, '');
        }
        else
        {
            SetCookie('AudioInputDeviceName', sDeviceName);
            SetCookie('AudioInputDeviceId', sDeviceId);

            m_objVaxWebPhoneLib.SetActiveAudioInputDevice(sDeviceName, sDeviceId);
        }

        m_objVaxWebPhoneLib.ChangeAudioInputDevice(sDeviceId);
    }

    this.ComboAudioOutputDevices_onchange = function ()
    {
        if (ComboAudioOutputDevices.selectedIndex == -1)
            return;
                
        var sDeviceName = ComboAudioOutputDevices.options[ComboAudioOutputDevices.selectedIndex].text;
        var sDeviceId = ComboAudioOutputDevices.options[ComboAudioOutputDevices.selectedIndex].value;
                
        if (sDeviceId == 'default')
        {
            SetCookie('AudioOutputDeviceName', '');
            SetCookie('AudioOutputDeviceId', '');

            m_objVaxWebPhoneLib.SetActiveAudioOutputDevice(sDeviceName, '');
        }
        else
        {
            SetCookie('AudioOutputDeviceName', sDeviceName);
            SetCookie('AudioOutputDeviceId', sDeviceId);

            m_objVaxWebPhoneLib.SetActiveAudioOutputDevice(sDeviceName, sDeviceId);
        }

        m_objVaxWebPhoneLib.ChangeAudioOutputDevice(sDeviceId);
    }
    
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    function OnChangeMediaDevices()
    {
        AddAudioInputDevices();
        AddAudioOutputDevices();
    }

};