﻿
// Warning: Please do not make any changes to this file.

function cVaxWebSocket() 
{
    var m_hWebSocket = null;
        
    var m_hEventOnTryingToConnect = null;
    var m_hEventOnFailedToConnect = null;
    var m_hEventOnSuccessToConnect = null;
    var m_hEventOnWebSocketRecv = null;
    
    var m_sWebSocketServerURL = "";
    var m_bConnectedWebRTC = false;
                
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    this.SetEventWebSocket = function (hEventOnTryingToConnect, hEventOnFailedToConnect, hEventOnSuccessToConnect, hEventOnWebSocketRecv, hEventOnConnectionClosed)
    {
        m_hEventOnTryingToConnect = hEventOnTryingToConnect;
        m_hEventOnFailedToConnect = hEventOnFailedToConnect;
        m_hEventOnSuccessToConnect = hEventOnSuccessToConnect;
        m_hEventOnWebSocketRecv = hEventOnWebSocketRecv;
        m_hEventOnConnectionClosed = hEventOnConnectionClosed;
    }
        
    function OnTryingToConnect()
    {
        m_hEventOnTryingToConnect();
    }

    function OnFailedToConnect()
    {
        m_hEventOnFailedToConnect();
    }

    function OnSuccessToConnect()
    {
        m_hEventOnSuccessToConnect();
    }

    function OnWebSocketRecv(sData)
    {
        m_hEventOnWebSocketRecv(sData);
    }

    function OnConnectionClosed()
    {
        m_hEventOnConnectionClosed();
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    this.ConnectServerWebRTC = function (sServerAddr)
    {
        m_bConnectedWebRTC = false;

        OnTryingToConnect();

        this.ConnectionWebSocket(sServerAddr);
    }

    this.ConnectionWebSocket = function (sServerAddr)
    {
        m_sWebSocketServerURL = sServerAddr;

        if (m_hWebSocket != null)
	    {
            m_hWebSocket.close();
	        m_hWebSocket = null;
	    }

        m_hWebSocket = new WebSocket(m_sWebSocketServerURL);

        m_hWebSocket.onerror = function (error)
        {
            m_bConnectedWebRTC = false;
                        
            OnFailedToConnect();
        }

        m_hWebSocket.onopen = function (event)
        {
            m_bConnectedWebRTC = true;
                        
            OnSuccessToConnect();
        }

        m_hWebSocket.onmessage = function (event)
        {
            if (event.data == "VaxWebPhoneALIVE")
            {
                if (m_bConnectedWebRTC)
                {
                    m_hWebSocket.send("VaxWebPhoneALIVE");
                }

                return;
            }

            OnWebSocketRecv(event.data);
        }

        m_hWebSocket.onclose = function (event)
        {
            m_bConnectedWebRTC = false;

            OnConnectionClosed();
        }
    }

    this.SendToServerWebRTC = function (sData)
    {
        if (m_bConnectedWebRTC)
            m_hWebSocket.send(sData);
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    this.IsConnectedToServerWebRTC = function ()
    {
        return m_bConnectedWebRTC;
    }

    this.DisconnectServerWebRTC = function ()
    {
        if (m_bConnectedWebRTC == false)
            return;

        m_bConnectedWebRTC = false;
        m_hWebSocket.close();
    }

};
  

