﻿
function OnVaxChatTypingTimeoutTick()
{
    m_objChat.OnTypingTimerTick();
}

// Class cVaxChat

function cVaxChat()
{
    var m_bTyping = false;
    var m_nTimerTyping = 0;

    this.OnLoadPage = function ()
    {
        m_objVaxWebPhoneLib.SetEventMainSIP(OnInitialized, OnUnInitialized, null, null, null, null);
        m_objVaxWebPhoneLib.SetEventRegister(null, null, null, OnSuccessToRegister, null, null, null, null, null, null, null);
        
        m_objVaxWebPhoneLib.SetEventChat(OnChatContactStatus, OnChatRecvMsgText, OnChatSendMsgTextFailed, OnChatSendMsgTextSuccess,
                                         OnChatSendMsgTypingFailed, OnChatSendMsgTypingSuccess, OnChatRecvMsgTypingStarted, m_aEventOnChatRecvMsgTypingEnded);
    }

    function OnInitialized()
    {
        ComboMyChatStatus.options[0] = new Option('Online', '0');
        ComboMyChatStatus.options[1] = new Option('Offline', '1');
        ComboMyChatStatus.options[2] = new Option('Away', '2');
        ComboMyChatStatus.options[3] = new Option('On the phone', '3');
        ComboMyChatStatus.options[4] = new Option('Busy', '4');

        ComboMyChatStatus.selectedIndex = 1;
    }

    function OnUnInitialized()
    {
        ListChatStatusLog.value = "";
        
        clearTimeout(m_nTimerTyping);
        EditChatStatusTyping.value = "";
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    this.BtnChatAddContact_onclick = function()
    {
        if(EditChatContactName.value == "")
		    return;
		
        m_objVaxWebPhoneLib.ChatAddContact(EditChatContactName.value, true);
                
        ListChatContacts.options[ListChatContacts.options.length] = new Option(EditChatContactName.value, EditChatContactName.value);

        if (ListChatContacts.selectedIndex == -1)
            ListChatContacts.selectedIndex = 0;

        EditChatContactName.value = "";
    }

    this.BtnChatRemoveContact_onclick = function()
    {
        if (ListChatContacts.selectedIndex == -1) return;
        var sContactName = ListChatContacts.options[ListChatContacts.selectedIndex].value;
                
        m_objVaxWebPhoneLib.ChatRemoveContact(sContactName);
        ListChatContacts.remove(ListChatContacts.selectedIndex);
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    function OnSuccessToRegister()
    {
        for (nContactCount = 0; nContactCount < ListChatContacts.length; nContactCount++)
        {
            var sContactName = ListChatContacts.options[nContactCount].value;
            m_objVaxWebPhoneLib.ChatAddContact(sContactName, true);
        }
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    this.ComboMyChatStatus_onchange = function ()
    {	
        if (ComboMyChatStatus.selectedIndex == -1) return;

        var sStatusId = ComboMyChatStatus.options[ComboMyChatStatus.selectedIndex].value;
        var nStatusId = parseInt(sStatusId);

        m_objVaxWebPhoneLib.ChatSetMyStatus(nStatusId);
    } 

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    this.BtnChatSendMessage_onclick = function ()
    {
        if (ListChatContacts.selectedIndex == -1) return;
        var sContactName = ListChatContacts.options[ListChatContacts.selectedIndex].value;

        m_objVaxWebPhoneLib.ChatSendMessageText(sContactName, EditChatSendMessage.value);
                
        AddChatTextLog("Me: " + EditChatSendMessage.value);
        EditChatSendMessage.value = "";
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    this.ChatSendMessageTyping_onkeydown = function () 
    {
        if (ListChatContacts.selectedIndex == -1)
            return;

        var sContactName = ListChatContacts.options[ListChatContacts.selectedIndex].value;

        m_objVaxWebPhoneLib.ChatSendMessageTyping(sContactName);
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    function GetStatusText(nStatusId)
    {	
        var sStatusText = "";

        switch (nStatusId)
        {
            case 0:
                sStatusText = "Online";
                break;

            case 1:
                sStatusText = "Offline";
                break;

            case 2:
                sStatusText = "Away";
                break;

            case 3:
                sStatusText = "On the phone";
                break;

            case 4:
                sStatusText = "Busy";
                break;

            case 5:
                sStatusText = "Offline";
                break;
        }

        return sStatusText;
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    
    function AddChatTextLog(sMsg) 
    {
        if (ListChatMessages.value.length == 0)
            ListChatMessages.value = ListChatMessages.value + sMsg;
        else
            ListChatMessages.value = ListChatMessages.value + "\n" + sMsg;

        ListChatMessages.scrollTop = ListChatMessages.scrollHeight;
    }

    function AddChatStatusLog(sStatus)
    {
        if (ListChatStatusLog.value.length == 0)
            ListChatStatusLog.value = ListChatStatusLog.value + sStatus;
        else
            ListChatStatusLog.value = ListChatStatusLog.value + "\n" + sStatus;

        ListChatStatusLog.scrollTop = ListChatStatusLog.scrollHeight;
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    this.BtnChatClearStatusLog_onclick = function ()
    {
        ListChatStatusLog.value = "";
    }
    
    this.BtnChatClearMessage_onclick = function ()
    {
        ListChatMessages.value = "";
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    function OnChatContactStatus(sUserName, nStatusId)
    {	
        for (nContactCount = 0; nContactCount < ListChatContacts.length; nContactCount++)
        {
            var sChatContact = ListChatContacts.options[nContactCount].text.toUpperCase();

            if (sChatContact.indexOf(sUserName.toUpperCase()) != -1)
            {
                ListChatContacts.options[nContactCount].text = sUserName + " [" + GetStatusText(nStatusId) + "]";
            }
        }
    }
        
    this.OnPhoneChatStatus = function (sStatus)
    {
        AddChatStatusLog(sStatus);
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    function OnChatRecvMsgText(sUserName, sMsgText, bIsChatContact)
    {
        var nStart = sMsgText.indexOf(">");

        if (nStart == -1)
        {
            AddChatTextLog(sUserName + ": " + sMsgText);
            return;
        }

        /* Remote is sending HTML based text messages */

        nStart = nStart + 1;
        var nEnd = sMsgText.indexOf("<", nStart);

        AddChatTextLog(sUserName + ": " + sMsgText.substr(nStart, nEnd - nStart));
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
        
    function OnChatRecvMsgTypingStarted(sUserName)
    {
        m_bTyping = true;
        EditChatStatusTyping.value = sUserName + ": Typing";
       
        this.StopTypingTimeoutTick();
        this.StartTypingTimeoutTick();
        
        this.AdjustTypingState();
    }

    this.OnTypingTimerTick = function ()
    {
        this.StopTypingTimeoutTick();
        this.StartTypingTimeoutTick();

        this.AdjustTypingState();
    }

    this.AdjustTypingState = function ()
    {
        if (!m_bTyping)
        {
            this.StopTypingTimeoutTick();
            m_aEventOnChatRecvMsgTypingEnded();
        }
        else
        {
            m_bTyping = false;
        }
    }
        
    function m_aEventOnChatRecvMsgTypingEnded(sUserName)
    {
        EditChatStatusTyping.value = "";
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
        
    this.StartTypingTimeoutTick = function ()
    {
        this.StopTypingTimeoutTick();
        m_nTimerTyping = setTimeout("OnVaxChatTypingTimeoutTick()", 2000);
    }

    this.StopTypingTimeoutTick = function ()
    {
        if (m_nTimerTyping == 0)
            return;

        clearTimeout(m_nTimerTyping);
        m_nTimerTyping = 0;
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    function OnChatSendMsgTextFailed(sUserName, nStatusCode, sReasonPhrase, sMsgText)
    {
        AddChatStatusLog(sUserName + ": Failed (" + sReasonPhrase + ") to send msg text");
    }

    function OnChatSendMsgTextSuccess(sUserName, sMsgText)
    {
        AddChatStatusLog(sUserName + ": Success to send msg text");
    }

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    
    function OnChatSendMsgTypingFailed(sUserName, nStatusCode, sReasonPhrase)
    {
        AddChatStatusLog(sUserName + ": Failed (" + sReasonPhrase + ") to send status typing");
    }

    function OnChatSendMsgTypingSuccess(sUserName)
    {
        AddChatStatusLog(sUserName + ": Success to send status typing");
    }

};