﻿// Class cVaxAccountSIP


function cVaxAccountSIP()
{
	this.OnLoadPage = function ()
    {
        m_objVaxWebPhoneLib.SetEventServerWebRTC(OnTryingToConnectServerWebRTC, OnFailedToConnectServerWebRTC, OnSuccessToConnectServerWebRTC, OnConnectionClosedServerWebRTC);

        m_objVaxWebPhoneLib.SetEventRegister(OnConnectingToRegister, OnTryingToRegister, OnFailedToRegister, OnSuccessToRegister, OnConnectingToReRegister,
            OnTryingToReRegister, OnFailedToReRegister, OnSuccessToReRegister, OnTryingToUnRegister, OnFailedToUnRegister,
            OnSuccessToUnRegister);

        m_objVaxWebPhoneLib.SetEventMainSIP(OnInitialized, OnUnInitialized, null, null, null, null);

		this.ReadAccountSetting();
        this.DisplayNone();
	}
	
    function OnInitialized()
    {	
	    BtnOnline.value = "Offline";
	}

    function OnUnInitialized()
    {
        BtnOnline.value = "Online";
        ListStatusLog.value = "";
    }

	////////////////////////////////////////////////////////////////////////

    this.BtnOnline_onclick = function () 
    {	
	    if (BtnOnline.value == "Offline") 
        {	
            m_objVaxWebPhoneLib.VaxOffline();
            return;
        }

        if (!IsValidAddrIP(EditAddrServerWebRTC.value))
        {
            ShowDialog("Please enter a valid ServerWebRTC IP address.");
            return;
        }

        if (EditAccountAuthLogin.value == "") 
        {
            ShowDialog("Invalid auth Login.");
            return;
        }
		
        if (EditAccountServerAddr.value == "") 
        {
            ShowDialog("Invalid SIP server domain or IP address.");
            return;
        }

        if (EditAccountServerPort.value == "")
        {
            EditAccountServerPort.value = '5060';
        }

        SaveAccountSetting();

        let [sWebSocketServerURL, sWebSocketServerAddr] = this.ConstructWebSocketURL(EditAddrServerWebRTC.value);

        m_objVaxWebPhoneLib.VaxOnline(EditAccountDisplayName.value, EditAccountUserName.value, EditAccountAuthLogin.value, EditAccountAuthPassword.value, EditAccountDomain.value, EditAccountServerAddr.value, parseInt(EditAccountServerPort.value), true, sWebSocketServerURL, sWebSocketServerAddr);
    }

    this.ConstructWebSocketURL = function (sServerAddr)
    {
        var sWebSocketIP = sServerAddr;
        var sDomainName = sWebSocketIP.replaceAll(".", "_");

        var sWebSocketServerURL = "wss://" + sDomainName + ".vaxphone.com:8080";
        return [sWebSocketServerURL, sServerAddr];
    }
	
    this.BtnClearStatusLog_onclick = function () 
    {
        ListStatusLog.value = "";
    }

    this.CheckSavePwd_onclick = function ()
    {
        if (CheckSavePwd.checked)
        {
            SetCookie('CheckSavePwd', '1');
            SetCookie('AccountAuthPassword', EditAccountAuthPassword.value);
		}
		
        else
        {
            SetCookie('CheckSavePwd', '0');
            SetCookie('AccountAuthPassword', '');
        }
    }

    this.BtnAdvance_onclick = function ()
    {
        var DisplayId = document.getElementById("EditAccountDisplayName");
        DisplayId.style.display == "block" ? DisplayId.style.display = "none" :
        DisplayId.style.display = "block";

        var UserNameId = document.getElementById("EditAccountUserName");
        UserNameId.style.display == "block" ? UserNameId.style.display = "none" :
        UserNameId.style.display = "block";

        var DomainRealmId = document.getElementById("EditAccountDomain");
        DomainRealmId.style.display == "block" ? DomainRealmId.style.display = "none" :
        DomainRealmId.style.display = "block";

        var BtnAdvanceId = document.getElementById("BtnAdvance");

        if (BtnAdvanceId.value == "Basic") BtnAdvanceId.value = "Advance";
        else BtnAdvanceId.value = "Basic";
    }

	this.BtnDemoAcc_onclick = function()
	{
		var DateNow = new Date();
		var Time = DateNow.getTime();
  
		var EpochTime = Math.round(Time / 1000);
  
		EditAccountAuthLogin.value = EpochTime;
		EditAccountAuthPassword.value = EpochTime;
  
		EditAccountServerAddr.value = "demo.vaxvoip.com";
        EditAccountServerPort.value = "8060";

        EditAccountUserName.value = "";
        EditAccountDisplayName.value = "";
        EditAccountDomain.value = "";

        CheckSavePwd.checked = true;
        EditAddrServerWebRTC.value = '45.126.210.90';

        var sDemoMsg = "";

        sDemoMsg = "<br/>" + "Auth Login: " + EpochTime + "<br/>";
        sDemoMsg = sDemoMsg + "Auth Password: " + EpochTime + "<br/>";
        sDemoMsg = sDemoMsg + "Server Addr: " + EditAccountServerAddr.value + "<br/>";
        sDemoMsg = sDemoMsg + "Server Port: " + EditAccountServerPort.value + "<br/> <br/>";


        ShowDialog(sDemoMsg + "Demo accounts are only for account-to-account VoIP calls. Use demo accounts on different devices to dial/receive VoIP calls.<br/> <br/>Dial 000 for self testing.<br> <br/>[Powered by VaxVoIP Server SDK]", "VaxVoIP SDK");
	}

	/////////////////////////////////////////////////////////////////////////////

	function SaveAccountSetting()
	{
    	SetCookie('AccountUserName', EditAccountUserName.value);
    	SetCookie('AccountDisplayName', EditAccountDisplayName.value);
    	SetCookie('AccountDomain', EditAccountDomain.value);
    	
    	SetCookie('AccountAuthLogin', EditAccountAuthLogin.value);

    	if (CheckSavePwd.checked)
        	SetCookie('AccountAuthPassword', EditAccountAuthPassword.value);
    	else
        	SetCookie('AccountAuthPassword', '');
        
		SetCookie('AccountServerAddr', EditAccountServerAddr.value);
		SetCookie('AccountServerPort', EditAccountServerPort.value);
		
		SetCookie('AccountRTCServerIP', EditAddrServerWebRTC.value);
		SetCookie('CheckSavePwd', CheckSavePwd.value);
	}

	this.ReadAccountSetting = function()
	{
		var Value = GetCookie('AccountUserName');
    	if (Value != null)
        	EditAccountUserName.value = Value;

    	Value = GetCookie('AccountDisplayName');
    	if (Value != null)
        	EditAccountDisplayName.value = Value;

    	Value = GetCookie('AccountDomain');
    	if (Value != null)
        	EditAccountDomain.value = Value;
			
		Value = GetCookie('AccountAuthLogin');
    	if (Value != null)
        	EditAccountAuthLogin.value = Value;
		
    	Value = GetCookie('AccountAuthPassword');
    	if (Value != null)
        	EditAccountAuthPassword.value = Value;

    	Value = GetCookie('AccountServerAddr');
    	if (Value != null)
        	EditAccountServerAddr.value = Value;
			
        var Value = GetCookie('AccountServerPort');

        if (Value != null && Value != '')
            EditAccountServerPort.value = Value;
        else
            EditAccountServerPort.value = '5060';
		    	
    	Value = GetCookie('CheckSavePwd');
		
    	if (Value == null || Value == '0')
        	CheckSavePwd.checked = false;
    	else
        	CheckSavePwd.checked = true;
				        
    	var Value = GetCookie('AccountRTCServerIP');
    	
		if (Value != null && Value != '')
        	EditAddrServerWebRTC.value = Value;
		else
            EditAddrServerWebRTC.value = '45.126.210.90';
	}

	this.DisplayNone = function()
	{
		document.getElementById("EditAccountDisplayName").style.display = "none";
		document.getElementById("EditAccountUserName").style.display = "none";
		document.getElementById("EditAccountDomain").style.display = "none";	
	}

    function AddStatusLog(sText)
    {
        if (ListStatusLog.value.length == 0)
            ListStatusLog.value = ListStatusLog.value + sText;
        else
            ListStatusLog.value = ListStatusLog.value + "\n" + sText;

        ListStatusLog.scrollTop = ListStatusLog.scrollHeight;
    }

    ////////////////////////////////////////////////////////////////////////

    function IsValidAddrIP(sAddrIP)
    {
        if (/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/.test(sAddrIP))
        {
            return (true);
        }

        return (false);
    }


    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    function OnConnectingToRegister() {
        AddStatusLog("Connecting to register SIP");
    }

    function OnTryingToRegister() {
        AddStatusLog("Trying to register SIP");
    }

    function OnFailedToRegister(nStatusCode, sReasonPhrase) {
        AddStatusLog("Failed register SIP: " + sReasonPhrase);
    }

    function OnSuccessToRegister() {
        AddStatusLog("Successfully registered SIP");
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    function OnConnectingToReRegister() {
        //AddStatusLog("Connecting to re-register");
    }

    function OnTryingToReRegister() {
        //AddStatusLog("Trying to re-register");
    }

    function OnFailedToReRegister(nStatusCode, sReasonPhrase) {
        AddStatusLog("Failed re-register SIP: " + sReasonPhrase);
    }

    function OnSuccessToReRegister() {
        AddStatusLog("Successfully re-registered SIP");
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    function OnTryingToUnRegister() {
        AddStatusLog("Trying to unregister SIP");
    }

    function OnFailedToUnRegister() {
        AddStatusLog("Failed to unregister SIP");
    }

    function OnSuccessToUnRegister() {
        m_objVaxWebPhoneLib.VaxUnInitialize();
        AddStatusLog("Unregistered successfully SIP");
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    function OnTryingToConnectServerWebRTC() {
        AddStatusLog("Trying to connect to the VaxServerWebRTC");
    }

    function OnFailedToConnectServerWebRTC() {
        AddStatusLog("Failed to connect to the VaxServerWebRTC");
    }

    function OnSuccessToConnectServerWebRTC() {
        AddStatusLog("Successfully connected to the VaxServerWebRTC");
        AddStatusLog(" ");
    }

    function OnConnectionClosedServerWebRTC() {
        AddStatusLog("Disconnected from VaxServerWebRTC");
    }

};