﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace VaxVoIP
{
    public partial class MainVideoForm : Form
    {
        private cVaxSIPUserAgentExCOM m_objVaxUserAgent;

        public MainVideoForm(ref cVaxSIPUserAgentExCOM objVaxUserAgent)
        {
            m_objVaxUserAgent = objVaxUserAgent;
            InitializeComponent();

            CheckBoxActivate.Checked = true;
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////

        public void OnVaxOnline()
        {
            ActivateVideoPreview();
        }

        public void OnVaxOffline()
        {
            VaxVideoPreview.DisplayClose();
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////

        private void ActivateVideoPreview()
        {
            if (CheckBoxActivate.Checked == true)
            {
                VaxVideoPreview.DisplayOpen();
                m_objVaxUserAgent.ActivateVideoDevice(true);
            }
            else
            {
                VaxVideoPreview.DisplayClose();
                m_objVaxUserAgent.CloseVideoDev();
            }
        }

        private void CheckBoxActivate_Click(object sender, EventArgs e)
        {
            ActivateVideoPreview();
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////

        public void OnVideoRemoteStarted(int nLineNo)
        {
            if(nLineNo == 0)
                VaxVideoScreen1.DisplayOpen();

            if (nLineNo == 1)
                VaxVideoScreen2.DisplayOpen();

            if (nLineNo == 2)
                VaxVideoScreen3.DisplayOpen();

            if (nLineNo == 3)
                VaxVideoScreen4.DisplayOpen();

            if (nLineNo == 4)
                VaxVideoScreen5.DisplayOpen();
        }

        public void OnVideoRemoteEnded(int nLineNo)
        {
            if (nLineNo == 0)
                VaxVideoScreen1.DisplayClose();

            if (nLineNo == 1)
                VaxVideoScreen2.DisplayClose();

            if (nLineNo == 2)
                VaxVideoScreen3.DisplayClose();

            if (nLineNo == 3)
                VaxVideoScreen4.DisplayClose();

            if (nLineNo == 4)
                VaxVideoScreen5.DisplayClose();
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////

        public void OnVideoRemoteFrameRGB(int nLineNo, long lFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
        {
            if(nLineNo == 0)
                VaxVideoScreen1.DisplayFrameRGB((ulong) lFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
            if(nLineNo == 1)
                VaxVideoScreen2.DisplayFrameRGB((ulong) lFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
            if (nLineNo == 2)
                VaxVideoScreen3.DisplayFrameRGB((ulong) lFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
            if (nLineNo == 3)
                VaxVideoScreen4.DisplayFrameRGB((ulong) lFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
            if (nLineNo == 4)
                VaxVideoScreen5.DisplayFrameRGB((ulong) lFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
        }

        public void OnVideoDeviceFrameRGB(int nDeviceId, long lFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
        {
            VaxVideoPreview.DisplayFrameRGB((ulong) lFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
        }
    }
}
