﻿using System;
using System.Collections;

class cStoreChat
{
    const String CHAT_ROOT_PATH = "Chat\\";

    public static Boolean AddContact(String sContactName)
    {
        if (sContactName.Length == 0)
            return false;

        String sKeyPath = CHAT_ROOT_PATH + sContactName;
        cStoreRegistry objStore = new cStoreRegistry();

        Boolean bResult = objStore.SetTEXT(sKeyPath, "ContactName", sContactName);
        objStore.Close();

        return bResult;
    }
       
    public static void RemoveContact(String sContactName)
    {
        if (sContactName.Length == 0)
            return;

        String sKeyPath = CHAT_ROOT_PATH + sContactName;
        cStoreRegistry objStore = new cStoreRegistry();

        objStore.DeleteSubKey(sKeyPath);
        objStore.Close();
    }

    public static void GetContactAll(ref ArrayList objList)
    {
        objList.Clear();

        String sKeyPath = CHAT_ROOT_PATH;
        cStoreRegistry objStore = new cStoreRegistry();

        objStore.EnumSubKeys(sKeyPath, ref objList);
        objStore.Close();
    }

    public static Boolean AddMsg(String sContactName, String sMsgText)
    {
        if (sContactName.Length == 0)
            return false;

        String sKeyPath = CHAT_ROOT_PATH + sContactName + "\\Messages";

        cStoreRegistry objStore = new cStoreRegistry();

        int nMsgCount = 0;

        objStore.GetINT(sKeyPath, "MsgCount", ref nMsgCount, 0);
        objStore.SetINT(sKeyPath, "MsgCount", nMsgCount + 1);

        objStore.SetTEXT(sKeyPath + "\\MsgText", "Msg" + Convert.ToString(nMsgCount), sMsgText);
        objStore.Close();

        return true;
    }

    public static void RemoveMsgAll(String sContactName)
    {
        if (sContactName.Length == 0)
            return;

        String sKeyPath = CHAT_ROOT_PATH + sContactName + "\\Messages";
        cStoreRegistry objStore = new cStoreRegistry();

        objStore.DeleteSubKey(sKeyPath);
        objStore.Close();
    }

    public static void GetMsgAll(String sContactName, ref ArrayList objList)
    {
        objList.Clear();

        String sKeyPath = CHAT_ROOT_PATH + sContactName + "\\Messages\\MsgText";
        cStoreRegistry objStore = new cStoreRegistry();

        ArrayList objValueNameList = new ArrayList();
        objStore.EnumValueNames(sKeyPath, ref objValueNameList);
        
        for (int nCount = 0; nCount < objValueNameList.Count; nCount++)
        {
            String sMsgText = "";
            objStore.GetTEXT(sKeyPath, (String) objValueNameList[nCount], ref sMsgText, "");

            objList.Add(sMsgText);
        }
        
        objStore.Close();
    }

    public static Boolean IsDataStored()
    {
        cStoreRegistry objStore = new cStoreRegistry();
        Boolean bResult = objStore.IsKeyExist(CHAT_ROOT_PATH);

        objStore.Close();
        return bResult;
    }
}

