﻿using System;
using System.Collections;

class cStoreBusyLamp
{
    const String BUSY_LAMP_ROOT_PATH = "BusyLamp\\";

    public static Boolean AddContact(String sContactName)
    {
        if (sContactName.Length == 0)
            return false;

        String sKeyPath = BUSY_LAMP_ROOT_PATH + sContactName;
        cStoreRegistry objStore = new cStoreRegistry();

        Boolean bResult = objStore.SetTEXT(sKeyPath, "ContactName", sContactName);
        objStore.Close();

        return bResult;
    }
       
    public static void RemoveContact(String sContactName)
    {
        if (sContactName.Length == 0)
            return;

        String sKeyPath = BUSY_LAMP_ROOT_PATH + sContactName;
        cStoreRegistry objStore = new cStoreRegistry();

        objStore.DeleteSubKey(sKeyPath);
        objStore.Close();
    }

    public static void GetContactAll(ref ArrayList objList)
    {
        objList.Clear();

        String sKeyPath = BUSY_LAMP_ROOT_PATH;
        cStoreRegistry objStore = new cStoreRegistry();

        objStore.EnumSubKeys(sKeyPath, ref objList);
        objStore.Close();
    }
       
    public static Boolean IsDataStored()
    {
        cStoreRegistry objStore = new cStoreRegistry();
        Boolean bResult = objStore.IsKeyExist(BUSY_LAMP_ROOT_PATH);

        objStore.Close();
        return bResult;
    }
}

