﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

class cStoreAccountREC
{
    const String ROOT_PATH = "AccountInfoREC\\";
        
    static public Boolean AddAccountInfo(String sDisplayName, String sUserName, String sAuthLogin, String sAuthPwd, String sDomainRealm, String sServerAddr, int nServerPort, Boolean bRegSIP)
    {
        cStoreRegistry objStore = new cStoreRegistry();
        String sKeyPath = ROOT_PATH + sUserName;

        objStore.SetTEXT(sKeyPath, "VaxDisplayName", sDisplayName);
        objStore.SetTEXT(sKeyPath, "VaxUserName", sUserName);
        objStore.SetTEXT(sKeyPath, "VaxAuthLogin", sAuthLogin);
        objStore.SetTEXT(sKeyPath, "VaxAuthPassword", sAuthPwd);
        objStore.SetTEXT(sKeyPath, "VaxDomainRealm", sDomainRealm);
        objStore.SetTEXT(sKeyPath, "VaxServerAddr", sServerAddr);
        objStore.SetINT(sKeyPath, "VaxServerPort", nServerPort);
        objStore.SetBOOL(sKeyPath, "VaxRegisterSIP", bRegSIP);

        objStore.Close();

        return true;
    }

    static public void GetAccountInfo(ref String sDisplayName, ref String sUserName, ref String sAuthLogin, ref String sAuthPwd, ref String sDomainRealm, ref String sServerAddr, ref int nServerPort, ref Boolean bRegSIP)
    {
        cStoreRegistry objStore = new cStoreRegistry();
        String sKeyPath = ROOT_PATH + sUserName;

        objStore.GetTEXT(sKeyPath, "VaxDisplayName", ref sDisplayName, "");
        objStore.GetTEXT(sKeyPath, "VaxUserName", ref sUserName, "");
        objStore.GetTEXT(sKeyPath, "VaxAuthLogin", ref sAuthLogin, "");
        objStore.GetTEXT(sKeyPath, "VaxAuthPassword", ref sAuthPwd, "");
        objStore.GetTEXT(sKeyPath, "VaxDomainRealm", ref sDomainRealm, "");
        objStore.GetTEXT(sKeyPath, "VaxServerAddr", ref sServerAddr, "");
        objStore.GetINT(sKeyPath, "VaxServerPort", ref nServerPort, 5060);

        objStore.GetBOOL(sKeyPath, "VaxRegisterSIP", ref bRegSIP, true);
        objStore.Close();
    }
}


