﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace VaxVoIP
{
    public partial class MainPhoneForm : Form
    {
        cLineVoice[] m_aLineVoice;

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        public void OnVaxVoiceOnline()
        {
            int nTotalLine = m_objVaxUserAgent.GetTotalLine();

            m_aLineVoice = new cLineVoice[nTotalLine];

            for (int nLineNo = 0; nLineNo < nTotalLine; nLineNo++)
            {
                m_aLineVoice[nLineNo] = new cLineVoice();
               
            }

            CheckLeftSpkListen.Checked = true;
            CheckRightSpkListen.Checked = true;

            CheckAllowListenConf.Checked = true;
            CheckAllowSpeakConf.Checked = true;

            CheckMuteLineSPK.Checked = false;
            CheckMuteLineMIC.Checked = false;

            SliderSpkVol.Value = 100;
            SliderMicVol.Value = 100;

            m_objVaxUserAgent.AudioDeviceVU(true, true, true);
        }

        public void OnVaxVoiceOffline()
        {
            SpkProgBar.Value = 0;
            MicProgBar.Value = 0;
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void CheckMuteLineSPK_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            Boolean bResult = m_objVaxUserAgent.MuteLineSpk(nLineNo, CheckMuteLineSPK.Checked);
            if (!bResult) return;

            m_aLineVoice[nLineNo].m_bMuteLineSPK = CheckMuteLineSPK.Checked;
        }

        private void CheckMuteLineMIC_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            Boolean bResult = m_objVaxUserAgent.MuteLineMic(nLineNo, CheckMuteLineMIC.Checked);
            if (!bResult) return;

            m_aLineVoice[nLineNo].m_bMuteLineMIC = CheckMuteLineMIC.Checked;
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void CheckLeftSpkListen_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            if (CheckLeftSpkListen.Checked == false && CheckRightSpkListen.Checked == false)
                CheckRightSpkListen.Checked = true;

            Boolean bResult = m_objVaxUserAgent.LineVoiceChannelSpk(nLineNo, SpkListenChannel(CheckLeftSpkListen.Checked, CheckRightSpkListen.Checked));
            if (!bResult) return;

            m_aLineVoice[nLineNo].m_bListenLeftSpk = CheckLeftSpkListen.Checked;
        }

        private void CheckRightSpkListen_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            if (CheckLeftSpkListen.Checked == false && CheckRightSpkListen.Checked == false)
                CheckLeftSpkListen.Checked = true;

            Boolean bResult = m_objVaxUserAgent.LineVoiceChannelSpk(nLineNo, SpkListenChannel(CheckLeftSpkListen.Checked, CheckRightSpkListen.Checked));
            if (!bResult) return;

            m_aLineVoice[nLineNo].m_bListenRightSpk = CheckRightSpkListen.Checked;
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void CheckAllowListenConf_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            Boolean bResult = m_objVaxUserAgent.ConfAllowLine(nLineNo, CheckAllowListenConf.Checked, CheckAllowSpeakConf.Checked);
            if (!bResult) return;

            m_aLineVoice[nLineNo].m_bAllowListenConf = CheckAllowListenConf.Checked;
        }

        private void CheckAllowSpeakConf_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            Boolean bResult = m_objVaxUserAgent.ConfAllowLine(nLineNo, CheckAllowListenConf.Checked, CheckAllowSpeakConf.Checked);
            if (!bResult) return;

            m_aLineVoice[nLineNo].m_bAllowSpeakConf = CheckAllowSpeakConf.Checked;
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void CheckSpkMute_Click(object sender, EventArgs e)
        {
            m_objVaxUserAgent.MuteSpk(CheckSpkMute.Checked);
        }

        private void CheckMuteMic_Click(object sender, EventArgs e)
        {
            m_objVaxUserAgent.MuteMic(CheckMuteMic.Checked);
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void SliderSpkVol_Scroll(object sender, EventArgs e)
        {
            // Value range (-100) --- 0 --- (+100)

            m_objVaxUserAgent.SetVolumeSpk(SliderSpkVol.Value - 100);
        }

        private void SliderMicVol_Scroll(object sender, EventArgs e)
        {
            // Value range (-100) --- 0 --- (+100)

            m_objVaxUserAgent.SetVolumeMic(SliderMicVol.Value - 100);
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private int SpkListenChannel(Boolean bListenLeft, Boolean bListenRight)
        {
            if (bListenLeft == true && bListenRight == false)
                return 0;

            if (bListenLeft == false && bListenRight == true)
                return 1;

            return 2;
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void ListBoxLines_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;
            if (nLineNo == -1) return;

            CheckMuteLineMIC.Checked = m_aLineVoice[nLineNo].m_bMuteLineMIC;
            CheckMuteLineSPK.Checked = m_aLineVoice[nLineNo].m_bMuteLineSPK;

            CheckAllowListenConf.Checked = m_aLineVoice[nLineNo].m_bAllowListenConf;
            CheckAllowSpeakConf.Checked = m_aLineVoice[nLineNo].m_bAllowSpeakConf;

            CheckLeftSpkListen.Checked = m_aLineVoice[nLineNo].m_bListenLeftSpk;
            CheckRightSpkListen.Checked = m_aLineVoice[nLineNo].m_bListenRightSpk;

            UpdateBtnStatus();
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        public void OnAudioDeviceMicVU(int nLevelVU)
        {
            MicProgBar.Value = nLevelVU;
        }

        public void OnAudioDeviceSpkVU(int nLevelVU)
        {
            SpkProgBar.Value = nLevelVU;
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////
    }

    public class cLineVoice
    {
        public  Boolean m_bMuteLineMIC = false;
        public  Boolean m_bMuteLineSPK = false;

        public Boolean m_bAllowListenConf = true;
        public Boolean m_bAllowSpeakConf = true;

        public Boolean m_bListenLeftSpk = true;
        public Boolean m_bListenRightSpk = true;

    }
}
