﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace VaxVoIP
{
    public partial class MainPhoneForm : Form
    {
        private void BtnTransferCall_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            m_objVaxUserAgent.TransferCallBlind(nLineNo, EditTransferPhoneNo.Text);
        }

        private void BtnConsultTransfer_Click(object sender, EventArgs e)
        {
            if (ComboConsultLineA.SelectedIndex == ComboConsultLineB.SelectedIndex)
            {
                MessageBox.Show("Please select two different lines.", "VaxVoIP SIP SDK");
                return;
            }

            m_objVaxUserAgent.TransferCallConsult(ComboConsultLineA.SelectedIndex, ComboConsultLineB.SelectedIndex);
        }

        public void OnTransferCallAccepted(int nLineNo)
        {
            AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Transfer accepted.");
        }

        public void OnTransferCallFailed(int nLineNo, int nStatusCode, String sReasonPhrase)
        {
            AddToStatusLog("Fail to Transfer: " + sReasonPhrase);
        }
    }
}
