﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace VaxVoIP
{
    public partial class MainPhoneForm : Form
    {
        private void BtnOpenPlayFile_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            m_objVaxUserAgent.PlayWaveOpen(nLineNo, EditPlayFileName.Text);
        }

        private void BtnPlayPause_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            m_objVaxUserAgent.PlayWavePause(nLineNo);
        }

        private void BtnPlayStop_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            m_objVaxUserAgent.PlayWaveStop(nLineNo);
        }

        private void BtnStartPlay_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            m_objVaxUserAgent.PlayWaveStart(nLineNo, CheckPlayListen.Checked);
        }

        private void BtnPlayRewind_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            m_objVaxUserAgent.PlayWaveSkipTo(nLineNo, m_objVaxUserAgent.PlayWavePosition(nLineNo) - 1000);
        }

        private void BtnPlayForward_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            m_objVaxUserAgent.PlayWaveSkipTo(nLineNo, m_objVaxUserAgent.PlayWavePosition(nLineNo) + 1000);
        }

        public void OnPlayWaveDone(int nLineNo)
        {
            AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Play wave done.");
        }
    }
}
