﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace VaxVoIP
{
    public partial class MainPhoneForm : Form
    {
        public void OnVaxLineOnline()
        {
            int nTotalLine = m_objVaxUserAgent.GetTotalLine();

            FillListLines();
            TimerTick.Enabled = true;
        }

        public void OnVaxLineOffline()
        {
            TimerTick.Enabled = false;
            ListBoxLines.Items.Clear();
        }

        private void FillListLines()
        {
            int nTotalLine = m_objVaxUserAgent.GetTotalLine();

            ComboConsultLineA.Items.Clear();
            ComboConsultLineB.Items.Clear();

            for (int nLineNo = 0; nLineNo < nTotalLine; nLineNo++)
            {
                ListBoxLines.Items.Add("Line-" + Convert.ToString(nLineNo + 1) + " : FREE");

                ComboConsultLineA.Items.Add("Line-" + Convert.ToString(nLineNo + 1));
                ComboConsultLineB.Items.Add("Line-" + Convert.ToString(nLineNo + 1));
            }

            ListBoxLines.SelectedIndex = 0;

            ComboConsultLineA.SelectedIndex = 0;
            ComboConsultLineB.SelectedIndex = 1;
        }
                
        private void ShowListBoxLineStatus(int nLineNo, String sStatus)
        {
            ListBoxLines.Items[nLineNo] = "Line-" + Convert.ToString(nLineNo + 1) + " : " + sStatus;
        }
        
        private void TimerTick_Tick(object sender, EventArgs e)
        {
            UpdateBtnStatus();

            int nTotalLine = m_objVaxUserAgent.GetTotalLine();
                                
            for (int nLineNo = 0; nLineNo < nTotalLine; nLineNo++)
            {
                String sItemText = ListBoxLines.Items[nLineNo].ToString();

                if (m_objVaxUserAgent.IsLineBusy(nLineNo))
                {
                    if (m_objVaxUserAgent.IsLinePlaying(nLineNo))
                    {
                        if (sItemText.IndexOf("PLAYING") == -1)
                        {
                            ShowListBoxLineStatus(nLineNo, "PLAYING");
                        }

                        return;
                    }

                    if (m_objVaxUserAgent.IsLineHold(nLineNo))
                    {
                        if (sItemText.IndexOf("HOLD") == -1)
                        {
                            ShowListBoxLineStatus(nLineNo, "HOLD");
                        }
                    }
                    else
                    {
                        if (sItemText.IndexOf("BUSY") == -1 && sItemText.IndexOf("CONNECTING") == -1)
                        {
                            ShowListBoxLineStatus(nLineNo, "BUSY");
                        }
                    }
                }
                else
                {
                    if (sItemText.IndexOf("FREE") == -1)
                    {
                        ShowListBoxLineStatus(nLineNo, "FREE");
                    }
                }
            }
        }

        private int FindLine()
        {
            int nTotalLine = m_objVaxUserAgent.GetTotalLine();
            int nLineNo = ListBoxLines.SelectedIndex;

            if (nLineNo == -1)
                return -1;

            if (m_objVaxUserAgent.IsLineBusy(nLineNo) == false)
            {
                return nLineNo;
            }

            for (nLineNo = 0; nLineNo < nTotalLine; nLineNo++)
            {
                if (m_objVaxUserAgent.IsLineBusy(nLineNo) == false)
                    return nLineNo;
            }

            return -1;
        }

    }
}
