﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace VaxVoIP
{
    public partial class MainForm : Form
    {
        public static MainForm m_objMainForm = null;

        private cVaxSIPUserAgentExCOM m_objVaxUserAgent;

        private MainAccountForm m_objAccountForm;
        private MainPhoneForm m_objPhoneForm;
        private MainVideoForm m_objVideoForm;
        private MainChatForm m_objChatForm;
        private MainBusyLampForm m_objBusyLampForm;
        private MainSettingForm m_objSettingForm;
        private MainAccountRecForm m_objAccountRecForm;
        
        public MainForm()
        {
            InitializeComponent();

            m_objMainForm = this;

            m_objVaxUserAgent = new cVaxSIPUserAgentExCOM();

            m_objAccountForm = new MainAccountForm(ref m_objVaxUserAgent);
            m_objPhoneForm = new MainPhoneForm(ref m_objVaxUserAgent);
            m_objVideoForm = new MainVideoForm(ref m_objVaxUserAgent);
            m_objChatForm = new MainChatForm(ref m_objVaxUserAgent);
            m_objBusyLampForm = new MainBusyLampForm(ref m_objVaxUserAgent);
            m_objSettingForm = new MainSettingForm(ref m_objVaxUserAgent);
            m_objAccountRecForm = new MainAccountRecForm(ref m_objVaxUserAgent);
            
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            m_objAccountForm.TopLevel = false;
            m_objAccountForm.Visible = true;
            MainTab.TabPages[0].Controls.Add(m_objAccountForm);

            m_objPhoneForm.TopLevel = false;
            m_objPhoneForm.Visible = true;
            MainTab.TabPages[1].Controls.Add(m_objPhoneForm);

            m_objVideoForm.TopLevel = false;
            m_objVideoForm.Visible = true;
            MainTab.TabPages[2].Controls.Add(m_objVideoForm);

            m_objChatForm.TopLevel = false;
            m_objChatForm.Visible = true;
            MainTab.TabPages[3].Controls.Add(m_objChatForm);

            m_objBusyLampForm.TopLevel = false;
            m_objBusyLampForm.Visible = true;
            MainTab.TabPages[4].Controls.Add(m_objBusyLampForm);

            m_objSettingForm.TopLevel = false;
            m_objSettingForm.Visible = true;
            MainTab.TabPages[5].Controls.Add(m_objSettingForm);

            m_objAccountRecForm.TopLevel = false;
            m_objAccountRecForm.Visible = true;
            MainTab.TabPages[6].Controls.Add(m_objAccountRecForm);
        }

        public int GetActiveTab()
        {
            return MainTab.SelectedIndex;
        }

        public void SetActiveTab(int nTab)
        {
            MainTab.SelectedIndex = nTab;
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnVaxOnline()
        {
            m_objPhoneForm.OnVaxOnline();
            m_objChatForm.OnVaxOnline();
            m_objBusyLampForm.OnVaxOnline();
            m_objSettingForm.OnVaxOnline();
            m_objVideoForm.OnVaxOnline();
        }

        public void OnVaxOffline()
        {
            m_objPhoneForm.OnVaxOffline();
            m_objChatForm.OnVaxOffline();
            m_objBusyLampForm.OnVaxOffline();
            m_objSettingForm.OnVaxOffline();
            m_objVideoForm.OnVaxOffline();
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnConnectingToRegister()
        {
            m_objAccountForm.OnConnectingToRegister();
        }

        public void OnTryingToRegister()
        {
            m_objAccountForm.OnTryingToRegister();
        }
        
        public void OnFailToRegister(int nStatusCode, String sReasonPhrase)
        {
            m_objAccountForm.OnFailToRegister(nStatusCode, sReasonPhrase);
        }

        public void OnSuccessToRegister()
        {
            m_objAccountForm.OnSuccessToRegister();            
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnConnectingToReRegister()
        {
            m_objAccountForm.OnConnectingToReRegister();
        }

        public void OnTryingToReRegister()
        {
            m_objAccountForm.OnTryingToReRegister();
        }
                
        public void OnFailToReRegister(int nStatusCode, String sReasonPhrase)
        {
            m_objAccountForm.OnFailToReRegister(nStatusCode, sReasonPhrase);
        }

        public void OnSuccessToReRegister()
        {
            m_objAccountForm.OnSuccessToReRegister();
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnTryingToUnRegister()
        {
            m_objAccountForm.OnTryingToUnRegister();
        }

        public void OnFailToUnRegister()
        {
            m_objAccountForm.OnFailToUnRegister();
        }

        public void OnSuccessToUnRegister()
        {
            m_objAccountForm.OnSuccessToUnRegister();
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnTransferCallFailed(int nLineNo, int nStatusCode, String sReasonPhrase)
        {
            m_objPhoneForm.OnTransferCallFailed(nLineNo, nStatusCode, sReasonPhrase);
        }

        public void OnDigitDTMF(int nLineNo, String sDigit)
        {
            m_objPhoneForm.OnDigitDTMF(nLineNo, sDigit);
        }

        public void OnPlayWaveDone(int nLineNo)
        {
            m_objPhoneForm.OnPlayWaveDone(nLineNo);
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnIncomingCallStarted(String sCallId, String sCallerName, String sCallerId)
        {
            m_objPhoneForm.OnIncomingCallStarted(sCallId, sCallerName, sCallerId);
        }

        public void OnIncomingCallEnded(String sCallId)
        {
            m_objPhoneForm.OnIncomingCallEnded(sCallId);
        }

        public void OnRingToneStarted(String sCallId)
        {
            m_objPhoneForm.OnRingToneStarted(sCallId);
        }

        public void OnRingToneEnded(String sCallId)
        {
            m_objPhoneForm.OnRingToneEnded(sCallId);
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnTransferCallAccepted(int nLineNo)
        {
            m_objPhoneForm.OnTransferCallAccepted(nLineNo);
        }
                                
        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnVoiceMailMsg(Boolean bIsMsgWaiting, int nNewMsgCount, int nOldMsgCount, int nNewUrgentMsgCount, int nOldUrgentMsgCount, String sMsgAccount)
        {
            m_objAccountForm.OnVoiceMailMsg(bIsMsgWaiting, nNewMsgCount, nOldMsgCount, nNewUrgentMsgCount, nOldUrgentMsgCount, sMsgAccount);
        }
                
        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnDialCallStarted(int nLineNo, String sCallerName, String sCallerId, String sDialNo)
        {
            m_objPhoneForm.OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
        }

        public void OnDialingCall(int nLineNo, int nStatusCode, String sReasonPhrase)
        {
            m_objPhoneForm.OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
        }

        public void OnDialCallFailed(int nLineNo, int nStatusCode, String sReasonPhrase, String sContact)
        {
            m_objPhoneForm.OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase, sContact);
        }

        public void OnConnectedCall(int nLineNo)
        {
            m_objPhoneForm.OnConnectedCall(nLineNo);
        }

        public void OnHungupCall(int nLineNo)
        {
            m_objPhoneForm.OnHungupCall(nLineNo);
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnSuccessToHold(int nLineNo)
        {
            m_objPhoneForm.OnSuccessToHold(nLineNo);
        }

        public void OnTryingToHold(int nLineNo)
        {
            m_objPhoneForm.OnTryingToHold(nLineNo);
        }

        public void OnFailToHold(int nLineNo)
        {
            m_objPhoneForm.OnFailToHold(nLineNo);
        }

        public void OnSuccessToUnHold(int nLineNo)
        {
            m_objPhoneForm.OnSuccessToUnHold(nLineNo);
        }

        public void OnTryingToUnHold(int nLineNo)
        {
            m_objPhoneForm.OnTryingToUnHold(nLineNo);
        }

        public void OnFailToUnHold(int nLineNo)
        {
            m_objPhoneForm.OnFailToUnHold(nLineNo);
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnDetectedAMD(int nLineNo, Boolean bIsHuman)
        {
            m_objPhoneForm.OnDetectedAMD(nLineNo, bIsHuman);
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnChatSubscribeSuccess(String sUserName)
        {
            m_objChatForm.OnChatSubscribeSuccess(sUserName);
        }

        public void OnChatSubscribeFailed(String sUserName, int nStatusCode, String sReasonPhrase)
        {
            m_objChatForm.OnChatSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
        }

        public void OnChatContactStatus(String sUserName, int nStatusId)
        {
            m_objChatForm.OnChatContactStatus(sUserName, nStatusId);
        }

        public void OnChatSendMsgTextSuccess(String sUserName, String sMsgText, long nUserValue)
        {
            m_objChatForm.OnChatSendMsgTextSuccess(sUserName, sMsgText, nUserValue);
        }

        public void OnChatSendMsgTextFailed(String sUserName, int nStatusCode, String sReasonPhrase, String sMsgText, long nUserValue)
        {
            m_objChatForm.OnChatSendMsgTextFailed(sUserName, nStatusCode, sReasonPhrase, sMsgText, nUserValue);
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnChatSendMsgTypingSuccess(String sUserName, long nUserValue)
        {
            m_objChatForm.OnChatSendMsgTypingSuccess(sUserName, nUserValue);
        }

        public void OnChatSendMsgTypingFailed(String sUserName, int nStatusCode, String sReasonPhrase, long nUserValue)
        {
            m_objChatForm.OnChatSendMsgTypingFailed(sUserName, nStatusCode, sReasonPhrase, nUserValue);
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnChatRecvMsgText(string sUserName, string sMsgText, bool bIsChatContact)
        {
            m_objChatForm.OnChatRecvMsgText(sUserName, sMsgText, bIsChatContact);
        }

        public void OnChatRecvMsgTypingStart(String sUserName)
        {
            m_objChatForm.OnChatRecvMsgTypingStart(sUserName);
        }

        public void OnChatRecvMsgTypingStop(String sUserName)
        {
            m_objChatForm.OnChatRecvMsgTypingStop();
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnBusyLampSubscribeSuccess(String sUserName)
        {
            m_objBusyLampForm.OnBusyLampSubscribeSuccess(sUserName);
        }

        public void OnBusyLampSubscribeFailed(String sUserName, int nStatusCode, String sReasonPhrase)
        {
            m_objBusyLampForm.OnBusyLampSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
        }

        public void OnBusyLampContactStatus(String sUserName, int nStatusId)
        {
            m_objBusyLampForm.OnBusyLampContactStatus(sUserName, nStatusId);
        }

        ///////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////

        public void OnNetworkReachability(bool bAvailable)
        {
            m_objAccountForm.OnNetworkReachability(bAvailable);
            m_objPhoneForm.OnNetworkReachability(bAvailable);
        }
                
        public void OnAudioDeviceMicVU(int nLevelVU)
        {
            m_objPhoneForm.OnAudioDeviceMicVU(nLevelVU);
        }

        public void OnAudioDeviceSpkVU(int nLevelVU)
        {
            m_objPhoneForm.OnAudioDeviceSpkVU(nLevelVU);
        }
                
        /////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////

        public void OnVideoRemoteStarted(int nLineNo)
        {
            m_objVideoForm.OnVideoRemoteStarted(nLineNo);
        }

        public void OnVideoRemoteEnded(int nLineNo)
        {
            m_objVideoForm.OnVideoRemoteEnded(nLineNo);
        }

        public void OnVideoRemoteFrameRGB(int nLineNo, long lFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
        {
            m_objVideoForm.OnVideoRemoteFrameRGB(nLineNo, lFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
        }

        public void OnVideoDeviceFrameRGB(int nDeviceId, long lFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
        {
            m_objVideoForm.OnVideoDeviceFrameRGB(nDeviceId, lFrameRGB, nFrameSize, nFrameWidth, nFrameHeight);
        }

        /////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////

        public void OnConnectingToRegisterREC()
        {
            m_objAccountRecForm.OnConnectingToRegister();
        }

        public void OnTryingToRegisterREC()
        {
            m_objAccountRecForm.OnTryingToRegister();
        }

        public void OnFailToRegisterREC(int nStatusCode, string sReasonPhrase)
        {
            m_objAccountRecForm.OnFailToRegister(nStatusCode, sReasonPhrase);
        }

        public void OnSuccessToRegisterREC()
        {
            m_objAccountRecForm.OnSuccessToRegister();
        }

        public void OnTryingToReRegisterREC()
        {
            m_objAccountRecForm.OnTryingToReRegister();
        }

        public void OnFailToReRegisterREC(int nStatusCode, string sReasonPhrase)
        {
            m_objAccountRecForm.OnFailToReRegister(nStatusCode, sReasonPhrase);
        }

        public void OnSuccessToReRegisterREC()
        {
            m_objAccountRecForm.OnSuccessToReRegister();
        }

        public void OnTryingToUnRegisterREC()
        {
            m_objAccountRecForm.OnTryingToUnRegister();
        }

        public void OnFailToUnRegisterREC()
        {
            m_objAccountRecForm.OnFailToUnRegister();
        }

        public void OnSuccessToUnRegisterREC()
        {
            m_objAccountRecForm.OnSuccessToUnRegister();
        }

        /////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////

        public void OnDialCallStartedREC(int nLineNo, String sCallerName, String sCallerId, String sDialNo)
        {
            m_objAccountRecForm.OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
        }
                
        public void OnDialingCallREC(int nLineNo, int nStatusCode, string sReasonPhrase)
        {
            m_objAccountRecForm.OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
        }

        public void OnConnectedCallREC(int nLineNo)
        {
            m_objAccountRecForm.OnConnectedCall(nLineNo);
        }

        public void OnDialCallFailedREC(int nLineNo, int nStatusCode, string sReasonPhrase)
        {
            m_objAccountRecForm.OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase);
        }

        public void OnHungupCallREC(int nLineNo)
        {
            m_objAccountRecForm.OnHungupCall(nLineNo);
        }

        /////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////

        public void OnStatusMsgREC(int nLineNo, int nErrorCode, string sErrorMsg)
        {
            m_objAccountRecForm.OnStatusMsg(nLineNo, nErrorCode, sErrorMsg);
        }

        /////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            m_objVaxUserAgent.UnInitialize();
        }  
    }
}
