﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace VaxVoIP
{
    public partial class MainAccountRecForm : Form
    {
        private cVaxSIPUserAgentExCOM m_objVaxUserAgent;
        private Boolean m_bBtnAdvanceShow = true;

        public MainAccountRecForm(ref cVaxSIPUserAgentExCOM objVaxUserAgent)
        {
            InitializeComponent();
            m_objVaxUserAgent = objVaxUserAgent;
        }

        private void MainAccountRecForm_Load(object sender, EventArgs e)
        {
            LoadAccountData();
        }
        
        private void BtnOnline_Click(object sender, EventArgs e)
        {
            if(BtnOnline.Text == "Offline")
            {
                m_objVaxUserAgent.UnRegisterAccountREC();
                BtnOnline.Text = "Online";

                return;
            }

            if (EditAuthLogin.Text == "")
            {
                MessageBox.Show("Invalid auth Login.", "VaxVoIP SDK", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }

            if (EditServerAddr.Text == "")
            {
                MessageBox.Show("Invalid SIP server domain or IP address.", "VaxVoIP SDK", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }

            cStoreAccountREC.AddAccountInfo(EditDisplayName.Text, EditUserName.Text, EditAuthLogin.Text, EditAuthPwd.Text, EditDomainRealm.Text, EditServerAddr.Text, Convert.ToInt32(EditServerPort.Text), CheckRegisterToServerREC.Checked);

            if (!m_objVaxUserAgent.RegisterAccountREC(CheckRegisterToServerREC.Checked, EditDisplayName.Text, EditUserName.Text, EditAuthLogin.Text, EditAuthPwd.Text, EditDomainRealm.Text, EditServerAddr.Text, Convert.ToInt32(EditServerPort.Text)))
                return;
            
            if (CheckRegisterToServerREC.Checked)
                AddToStatusLog("Registering to SIP Server REC");
            
            BtnOnline.Text = "Offline";
           
        }

        private void BtnAdvance_Click(object sender, EventArgs e)
        {
            if (m_bBtnAdvanceShow)
            {
                LabelDisplayName.Visible = true;
                LabelUserName.Visible = true;
                
                LabelDomain.Visible = true;
                EditDisplayName.Visible = true;
                
                EditUserName.Visible = true;
                EditDomainRealm.Visible = true;

                BtnAdvance.Text = "Basic";
                m_bBtnAdvanceShow = false;

                return;
            }

            LabelDisplayName.Visible = false;
            LabelUserName.Visible = false;

            LabelDomain.Visible = false;
            EditDisplayName.Visible = false;
            
            EditUserName.Visible = false;
            EditDomainRealm.Visible = false;

            BtnAdvance.Text = "Advance";
            m_bBtnAdvanceShow = true;
        }

        /////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////

        private void BtnClearStatusLog_Click(object sender, EventArgs e)
        {
            ListBoxStatusLog.Items.Clear();
        }

        private void btnClearCallLog_Click(object sender, EventArgs e)
        {
            ListBoxCallLog.Items.Clear();
        }
        
        /////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////
        
        private void AddToStatusLog(String sStatus)
        {
            ListBoxStatusLog.Items.Add(sStatus);
            ListBoxStatusLog.TopIndex = ListBoxStatusLog.Items.Count - 1;
        }

        private void AddToCallLog(String sStatus)
        {
            ListBoxCallLog.Items.Add(sStatus);
            ListBoxCallLog.TopIndex = ListBoxStatusLog.Items.Count - 1;
        }

        /////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////

        private void LoadAccountData()
        {
            String sDisplayName = "";
            String sUserName = "";

            String sAuthLogin = "";
            String sAuthPwd = "";

            String sDomainRealm = "";
            String sServerAddr = "";

            int nServerPort = 5060;
            Boolean bRegisterREC = true;

            cStoreAccountREC.GetAccountInfo(ref sDisplayName, ref sUserName, ref sAuthLogin, ref sAuthPwd, ref sDomainRealm, ref sServerAddr, ref nServerPort, ref bRegisterREC);

            EditDisplayName.Text = sDisplayName;
            EditUserName.Text = sUserName;
            EditAuthLogin.Text = sAuthLogin;
            EditAuthPwd.Text = sAuthPwd;
            EditDomainRealm.Text = sDomainRealm;
            EditServerAddr.Text = sServerAddr;
            EditServerPort.Text = Convert.ToString(nServerPort);
            CheckRegisterToServerREC.Checked = bRegisterREC;
        }

        /////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////

        public void OnConnectingToRegister()
        {
            AddToStatusLog("Connecting to register.");
        }

        public void OnTryingToRegister()
        {
            AddToStatusLog("Trying to register.");
        }

        public void OnFailToRegister(int nStatusCode, string sReasonPhrase)
        {
            AddToStatusLog("Failed: " + sReasonPhrase);
        }

        public void OnSuccessToRegister()
        {
            AddToStatusLog("Success to register.");
        }

        /////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////
        
        public void OnTryingToReRegister()
        {
            AddToStatusLog("Trying to Re-Register.");
        }

        public void OnFailToReRegister(int nStatusCode, string sReasonPhrase)
        {
            AddToStatusLog("Failed: " + sReasonPhrase);
        }

        public void OnSuccessToReRegister()
        {
            AddToStatusLog("Success to Re-Register.");
        }

        /////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////

        public void OnTryingToUnRegister()
        {
            AddToStatusLog("Trying to Unregister.");
        }

        public void OnFailToUnRegister()
        {
            AddToStatusLog("Fail to unregister.");
        }

        public void OnSuccessToUnRegister()
        {
            AddToStatusLog("Unregistered successfully.");
        }

        /////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////

        public void OnDialCallStarted(int nLineNo, String sCallerName, String sCallerId, String sDialNo)
        {
            AddToCallLog("Line-" + Convert.ToString(nLineNo + 1) + ": Dialing.");
        }

        public void OnDialingCall(int nLineNo, int nStatusCode, string sReasonPhrase)
        {
           AddToCallLog("Line-" + Convert.ToString(nLineNo + 1) + ": Response: " + sReasonPhrase);        
        }

        public void OnConnectedCall(int nLineNo)
        {
            AddToCallLog("Line-" + Convert.ToString(nLineNo + 1) + ": Success to connect.");
        }

        public void OnDialCallFailed(int nLineNo, int nStatusCode, string sReasonPhrase)
        {
            AddToCallLog("Line-" + Convert.ToString(nLineNo + 1) + ": Response: " + sReasonPhrase);
        }

        public void OnHungupCall(int nLineNo)
        {
            AddToCallLog("Line-" + Convert.ToString(nLineNo + 1) + ": Hang up.");
        }

        public void OnStatusMsg(int nLineNo, int nErrorCode, string sErrorMsg)
        {
            AddToCallLog("Line-" + Convert.ToString(nLineNo + 1) + ": " + sErrorMsg);
        }
    }
}
