﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace VaxVoIP
{
    public partial class MainAccountForm : Form
    {
        private cVaxSIPUserAgentExCOM m_objVaxUserAgent;
        private Boolean m_bBtnAdvanceShow = true;

        public MainAccountForm(ref cVaxSIPUserAgentExCOM objVaxUserAgent)
        {
            InitializeComponent();
            m_objVaxUserAgent = objVaxUserAgent;
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void AccountForm_Load(object sender, EventArgs e)
        {
            ComboServerType.Items.Add("UDP");
            ComboServerType.Items.Add("TCP");
            ComboServerType.Items.Add("TLS");
            ComboServerType.SelectedIndex = 0;

            LoadAccountData();
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnOnline_Click(object sender, EventArgs e)
        {
            if (BtnOnline.Text == "Offline")
            {
                m_objVaxUserAgent.UnInitialize();
                BtnOnline.Text = "Online";

                EditServerPort.Enabled = true;
                return;
            }

            if (EditAuthLogin.Text == "")
            {
                MessageBox.Show("Invalid auth Login.", "VaxVoIP SDK", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }

            if (EditServerAddr.Text == "")
            {
                MessageBox.Show("Invalid SIP server domain or IP address.", "VaxVoIP SDK", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }

            int nServerType = GetServerType();

            if (!m_objVaxUserAgent.Initialize(EditDisplayName.Text, EditUserName.Text, EditAuthLogin.Text, EditAuthPwd.Text, EditDomainRealm.Text, EditServerAddr.Text, Convert.ToInt32(EditServerPort.Text), nServerType, CheckRegisterToServerSIP.Checked, CheckCaptureSoundDevice.Checked))
                return;

            if (CheckRegisterToServerSIP.Checked == false)
            {
                AddToStatusLog("Account is online.");
            }
                                    
            BtnOnline.Text = "Offline";

            cStoreAccount.AddAccountInfo(EditDisplayName.Text, EditUserName.Text, EditAuthLogin.Text, EditAuthPwd.Text, EditDomainRealm.Text, EditServerAddr.Text, Convert.ToInt32(EditServerPort.Text), nServerType, CheckRegisterToServerSIP.Checked);
        }
               
        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void AddToStatusLog(String sStatus)
        {
            ListBoxStatusLog.Items.Add(sStatus);
            ListBoxStatusLog.TopIndex = ListBoxStatusLog.Items.Count - 1;
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        public void OnNetworkReachability(Boolean bAvailable)
        {
            if (bAvailable)
                AddToStatusLog("Network is available");
            else
                AddToStatusLog("Network is not available");
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        public void OnConnectingToRegister()
        {
            AddToStatusLog("Connecting to register.");
        }

        public void OnTryingToRegister()
        {
            AddToStatusLog("Trying to register.");
        }

        public void OnFailToRegister(int nStatusCode, String sReasonPhrase)
        {
            AddToStatusLog("Failed: " + sReasonPhrase);
        }

        public void OnSuccessToRegister()
        {
            AddToStatusLog("Success to register.");
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        public void OnConnectingToReRegister()
        {
            AddToStatusLog("Connecting to re-register.");
        }

        public void OnTryingToReRegister()
        {
            AddToStatusLog("Trying to Re-Register.");
        }

        public void OnFailToReRegister(int nStatusCode, String sReasonPhrase)
        {
            AddToStatusLog("Failed: " + sReasonPhrase);
        }

        public void OnSuccessToReRegister()
        {
            AddToStatusLog("Success to Re-Register.");
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        public void OnTryingToUnRegister()
        {
            AddToStatusLog("Trying to Unregister.");
        }

        public void OnFailToUnRegister()
        {
            AddToStatusLog("Fail to unregister.");
        }

        public void OnSuccessToUnRegister()
        {
            AddToStatusLog("Unregistered successfully.");
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnClearLog_Click(object sender, EventArgs e)
        {
            ListBoxStatusLog.Items.Clear();
        }
        
        private void BtnAdvance_Click(object sender, EventArgs e)
        {
            if (m_bBtnAdvanceShow)
            {
                LabelDisplayName.Visible = true;
                LabelUserName.Visible = true;
                LabelDomainRealm.Visible = true;
                EditDisplayName.Visible = true;
                EditUserName.Visible = true;
                EditDomainRealm.Visible = true;

                BtnAdvance.Text = "Basic";
                m_bBtnAdvanceShow = false;

                return;
            }

            LabelDisplayName.Visible = false;
            LabelUserName.Visible = false;
            LabelDomainRealm.Visible = false;
            EditDisplayName.Visible = false;
            EditUserName.Visible = false;
            EditDomainRealm.Visible = false; ;

            BtnAdvance.Text = "Advance";
            m_bBtnAdvanceShow = true;
        }

        private void BtnDemoAcc_Click(object sender, EventArgs e)
        {
            TimeSpan EpocTime = DateTime.UtcNow - new DateTime(1970, 1, 1);
            int nEpocSeconds = ((int)EpocTime.TotalSeconds) % 9999999;

            String sAccountDemo = nEpocSeconds.ToString();
                        
            EditAuthLogin.Text = sAccountDemo;
            EditAuthPwd.Text = sAccountDemo;

            EditServerAddr.Text = "demo.vaxvoip.com";
            EditServerPort.Text = "8060";

            CheckRegisterToServerSIP.Checked = true;
            ComboServerType.SelectedIndex = 0;

            String sDemoMsg = "";

            sDemoMsg = "\n" + "Auth Login: " + sAccountDemo + "\n";
            sDemoMsg = sDemoMsg + "Auth Password: " + sAccountDemo + "\n";
            sDemoMsg = sDemoMsg + "Server Addr: " + EditServerAddr.Text + "\n";
            sDemoMsg = sDemoMsg + "Server Port: " + EditServerPort.Text + "\n \n";

            MessageBox.Show(sDemoMsg + "Demo accounts are only for account-to-account VoIP calls. Use demo accounts on different devices to dial/receive VoIP calls.\n\nDial 000 for self testing.\n\n[Powered by VaxVoIP Server SDK]", "VaxVoIP SDK", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void LoadAccountData()
        {
            String sDisplayName = "";
            String sUserName = "";

            String sAuthLogin = "";
            String sAuthPwd = "";

            String sDomainRealm = "";
            
            String sServerAddr = "";
            int nServerPort = 5060;

            int nServerType = cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP;
            Boolean bRegisterSIP = true;

            cStoreAccount.GetAccountInfo(ref sDisplayName, ref sUserName, ref sAuthLogin, ref sAuthPwd, ref sDomainRealm, ref sServerAddr, ref nServerPort, ref nServerType, ref bRegisterSIP);

            EditDisplayName.Text = sDisplayName;
            EditUserName.Text = sUserName;

            EditAuthLogin.Text = sAuthLogin;
            EditAuthPwd.Text = sAuthPwd;

            EditDomainRealm.Text = sDomainRealm;
            EditServerAddr.Text = sServerAddr;
            EditServerPort.Text = Convert.ToString(nServerPort);
            
            CheckRegisterToServerSIP.Checked = bRegisterSIP;

            UpdateServerType(nServerType);
        }

        public void OnVoiceMailMsg(Boolean bIsMsgWaiting, int nNewMsgCount, int nOldMsgCount, int nNewUrgentMsgCount, int nOldUrgentMsgCount, String sMsgAccount)
        {
            if (bIsMsgWaiting)
            {
                LabelIsMsgWaiting.Text = "Yes";
            }
            else
            {
                LabelIsMsgWaiting.Text = "No";
            }

            LabelNewMsgs.Text = Convert.ToString(nNewMsgCount);
            LabelOldMsgs.Text = Convert.ToString(nOldMsgCount);
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void UpdateServerType(int nServerType)
        {
            if (nServerType == cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP)
            {
                ComboServerType.SelectedIndex = 0;
                LabelServerPort.Text = "Server Port UDP (Default: 5060)";
            }
            else if (nServerType == cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TCP)
            {
                ComboServerType.SelectedIndex = 1;
                LabelServerPort.Text = "Server Port TCP (Default: 5060)";
            }
            else if (nServerType == cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TLS)
            {
                ComboServerType.SelectedIndex = 2;
                LabelServerPort.Text = "Server Port TLS (Default: 5061)";
            }

            if (EditServerAddr.Text == "demo.vaxvoip.com")
            {
                if (nServerType == cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TLS)
                    EditServerPort.Text = "8061";
                else
                    EditServerPort.Text = "8060";
            }
            else if (EditServerPort.Text == "5060" || EditServerPort.Text == "5061" || EditServerPort.Text.Length == 0)
            {
                if (nServerType == cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TLS)
                    EditServerPort.Text = "5061";
                else
                    EditServerPort.Text = "5060";
            }
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private int GetServerType()
        {
            if (ComboServerType.SelectedIndex == 0)
                return cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP;

            if (ComboServerType.SelectedIndex == 1)
                return cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TCP;

            if (ComboServerType.SelectedIndex == 2)
                return cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_TLS;

            return cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP;
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////

        private void ComboServerType_SelectionChangeCommitted(object sender, EventArgs e)
        {
            int nServerType = GetServerType();
            UpdateServerType(nServerType);
        }
    }
}
