﻿using System;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using VAXSIPUSERAGENTCOMLib;
using VaxVoIP;
using System.Collections;

public class cVaxSIPUserAgentExCOM : cVaxSIPUserAgentCOM
{
    public const int VAX_TOTAL_NO_LINES = 8;

    private int m_nActiveAudioInDeviceId;
    private int m_nActiveAudioOutDeviceId;

    private Boolean m_bCaptureSoundDevice;
    
    private Boolean m_bEnableREC = false;
    private Boolean m_bBoostMic = false;

    private Boolean m_bDetectAMD = false;
    private int m_nTypeDTMF = cVaxSIPUserAgentCOM.VAX_DTMF_TYPE_AUTO; 

    private const String VAX_ACCOUNT_NAME_PHONE = "VaxVoIP-PHONE";
    private const String VAX_ACCOUNT_NAME_REC = "VaxVoIP-REC";
    
    public cVaxSIPUserAgentExCOM()
    {
        m_bDetectAMD = false;
        m_bEnableREC = false;
                
        m_nActiveAudioInDeviceId = -1;
        m_nActiveAudioOutDeviceId = -1;

        m_bCaptureSoundDevice = true;
    }    
        
    ////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean Initialize(String sDisplayName, String sUserName, String sAuthLogin, String sAuthPwd, String sDomainRealm, String sServerAddr, int nServerPort, int nServerType, Boolean bRegisterSIP, Boolean bCaptureSoundDevice)
    {
        /****************************************/

        base.SetLicenceKey("TRIAL-LICENSE-KEY");

        /****************************************/

        if (!base.Initialize())
            return false;

        if (!base.AddAccountSIP(VAX_ACCOUNT_NAME_PHONE, nServerType, "", -1, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort))
        {
            base.UnInitialize();
            return false;
        }

        //base.DiagnosticLogSIP("", true, true);

        OnVaxOnline();

        base.DeselectAllVideoCodec();
        base.NetworkReachability(true);
                
        if (bRegisterSIP)
        {
            base.RegisterAccountSIP(VAX_ACCOUNT_NAME_PHONE, 1800);
            base.AutoRegistration(VAX_ACCOUNT_NAME_PHONE, true, -1, 4);
        }

        m_bCaptureSoundDevice = bCaptureSoundDevice;
        base.EnableKeepAlive(VAX_ACCOUNT_NAME_PHONE, 10);
                      
        return true;
    }

    public new void UnInitialize()
    {
        base.UnInitialize();
        OnVaxOffline();
    }

    public int GetTotalLine()
    {
        return VAX_TOTAL_NO_LINES;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////

    public void DialCallToREC(int nLineNo)
    {
        if (!m_bEnableREC)
            return;

        if (!base.DialCallToREC(VAX_ACCOUNT_NAME_REC, nLineNo, "0000"))
        {
            OnStatusMsgREC(nLineNo);
            return;
        }
    }

    public Boolean UnRegisterAccountREC()
    {
        m_bEnableREC = false;

        base.RemoveAccountSIP(VAX_ACCOUNT_NAME_REC);
        return true;
    }

    public Boolean RegisterAccountREC(Boolean bRegister, String sDisplayName, String sUserName, String sAuthLogin, String sAuthPwd, String sDomainRealm, String sServerAddr, int nServerPort)
    {
        m_bEnableREC = false;
        base.RemoveAccountSIP(VAX_ACCOUNT_NAME_REC);

        if (!base.AddAccountSIP(VAX_ACCOUNT_NAME_REC, cVaxSIPUserAgentCOM.VAX_ACCOUNT_TYPE_UDP, "", -1, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort))
        {
            return false;
        }

        if (bRegister)
        {
            if (!base.RegisterAccountSIP(VAX_ACCOUNT_NAME_REC, 1800))
                return false;
        }
        else
        {
            m_bEnableREC = true;
        }
                
        return true;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean DialCall(int nLineNo, String sCallerName, String sCallerId, String sDialNo)
    {
        int nInputDeviceId = m_nActiveAudioInDeviceId;
        int nOutputDeviceId = m_nActiveAudioOutDeviceId;

        if (m_bCaptureSoundDevice == false)
        {
            nInputDeviceId = cVaxSIPUserAgentCOM.VAX_CAPTURE_SOUND_DEVICE_NONE;
            nOutputDeviceId = cVaxSIPUserAgentCOM.VAX_CAPTURE_SOUND_DEVICE_NONE;
        }
        
        if (!base.DialCall(VAX_ACCOUNT_NAME_PHONE, nLineNo, sCallerName, sCallerId, sDialNo, nInputDeviceId, nOutputDeviceId))
        {
            return false;
        }

        DialCallToREC(nLineNo);
        return true;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean AcceptCall(int nLineNo, String sCallId)
    {
        int nInputDeviceId = m_nActiveAudioInDeviceId;
        int nOutputDeviceId = m_nActiveAudioOutDeviceId;

        if (m_bCaptureSoundDevice == false)
        {
            nInputDeviceId = cVaxSIPUserAgentCOM.VAX_CAPTURE_SOUND_DEVICE_NONE;
            nOutputDeviceId = cVaxSIPUserAgentCOM.VAX_CAPTURE_SOUND_DEVICE_NONE;
        }

        if(!base.AcceptCall(nLineNo, sCallId, nInputDeviceId, nOutputDeviceId))
        {
            return false;
        }

        DialCallToREC(nLineNo);
        return true;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean DigitDTMF(int nLineNo, String sDigit)
    {
        return base.DigitDTMF(nLineNo, sDigit, m_nTypeDTMF);
    }

    public void ForceDigitDTMF(int nTypeDTMF)
    {
        m_nTypeDTMF = nTypeDTMF;
    }
        
    ////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////
    
    public Boolean IsVolumeBoostMic()
    {
        return m_bBoostMic;
    }

    public Boolean SetVolumeBoostMic(bool bEnable)
    { 
        int nBoostVol = 0;

	    if(bEnable)
		nBoostVol = 20;

	    bool bResult = base.SetVolumeMic(nBoostVol);
	
	    if(!bResult)
	    {
            m_bBoostMic = false;
	    }
	
	    m_bBoostMic = bEnable;
	    return bResult;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
   
    public void SetActiveAudioInDevice(int nDeviceId)
    {
        m_nActiveAudioInDeviceId = nDeviceId;
    }
       
    public void SetActiveAudioOutDevice(int nDeviceId)
    {
        m_nActiveAudioOutDeviceId = nDeviceId;
    }
            
    //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////
    public void DetectAMD(Boolean bEnable)
    {
        m_bDetectAMD = bEnable;
    }

    //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////

    public void DialRingEnable()
    {
        base.DialRingEnable("DialRing.wav");
    }

    public void BusyRingEnable()
    {
        base.BusyRingEnable("BusyRing.wav");
    }
        
    //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////

    public Boolean ChatAddContact(string sUserName)
    {
        return base.ChatAddContact(VAX_ACCOUNT_NAME_PHONE, sUserName, true);
    }

    public Boolean ChatRemoveContact(string sUserName)
    {
        return base.ChatRemoveContact(VAX_ACCOUNT_NAME_PHONE, sUserName);
    }

    public Boolean ChatSetMyStatus(int nStatusId)
    {
        return base.ChatSetMyStatus(VAX_ACCOUNT_NAME_PHONE, nStatusId);
    }

    public Boolean ChatSendMessageText(string sUserName, string sMsgText)
    {
        return base.ChatSendMessageText(VAX_ACCOUNT_NAME_PHONE, sUserName, sMsgText, false, 0);
    }

    public Boolean ChatSendMessageTyping(string sUserName)
    {
        return base.ChatSendMessageTyping(VAX_ACCOUNT_NAME_PHONE, sUserName, 0);
    }

    //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////

    public Boolean BusyLampAddContact(string sUserName)
    {
        return base.BusyLampAddContact(VAX_ACCOUNT_NAME_PHONE, sUserName);
    }

    public void BusyLampRemoveContact(string sUserName)
    {
        base.BusyLampRemoveContact(VAX_ACCOUNT_NAME_PHONE, sUserName);
    }

    //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////

    public Boolean RegisterAccountSIP(int nExpire)
    {
        return base.RegisterAccountSIP(VAX_ACCOUNT_NAME_PHONE, nExpire);
    }

    public Boolean AutoRegistration(bool bEnable, int nTickCountLimit, int nTickSeconds)
    {
        return base.AutoRegistration(VAX_ACCOUNT_NAME_PHONE, bEnable, nTickCountLimit, nTickSeconds);
    }

    public Boolean EnableKeepAlive(int nSeconds)
    {
        return base.EnableKeepAlive(VAX_ACCOUNT_NAME_PHONE, nSeconds);
    }
            
    //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////

    public void OnVaxOnline()
    {
        MainForm.m_objMainForm.OnVaxOnline();
    }

    public void OnVaxOffline()
    {
        MainForm.m_objMainForm.OnVaxOffline();
    }

    //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////

    public override void OnDigitDTMF(String sAccountName, int nLineNo, String sDigit)
    {
        MainForm.m_objMainForm.OnDigitDTMF(nLineNo, sDigit);
    }

    public override void OnPlayWaveDone(String sAccountName, int nLineNo)
    {
        MainForm.m_objMainForm.OnPlayWaveDone(nLineNo);
    }
        
    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnConnectingToRegister(String sAccountName)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnConnectingToRegisterREC();
            return;
        }

        MainForm.m_objMainForm.OnConnectingToRegister();
    }

    public override void OnTryingToRegister(String sAccountName)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnTryingToRegisterREC();
            return;
        }

        MainForm.m_objMainForm.OnTryingToRegister();
    }

    public override void OnFailToRegister(String sAccountName, int nStatusCode, String sReasonPhrase)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            m_bEnableREC = false;
            MainForm.m_objMainForm.OnFailToRegisterREC(nStatusCode, sReasonPhrase);

            return;
        }

        MainForm.m_objMainForm.OnFailToRegister(nStatusCode, sReasonPhrase);
    }

    public override void OnSuccessToRegister(String sAccountName)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            m_bEnableREC = true;
            MainForm.m_objMainForm.OnSuccessToRegisterREC();
            return;
        }

        MainForm.m_objMainForm.OnSuccessToRegister();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnConnectingToReRegister(String sAccountName)
    {
        MainForm.m_objMainForm.OnConnectingToReRegister();
    }

    public override void OnTryingToReRegister(String sAccountName)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnTryingToReRegisterREC();
            return;
        }

        MainForm.m_objMainForm.OnTryingToReRegister();
    }

    public override void OnFailToReRegister(String sAccountName, int nStatusCode, String sReasonPhrase)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            m_bEnableREC = false;
            MainForm.m_objMainForm.OnFailToReRegisterREC(nStatusCode, sReasonPhrase);

            return;
        }

        MainForm.m_objMainForm.OnFailToReRegister(nStatusCode, sReasonPhrase); 
    }

    public override void OnSuccessToReRegister(String sAccountName)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            m_bEnableREC = true;
            MainForm.m_objMainForm.OnSuccessToReRegisterREC();

            return;
        }

        MainForm.m_objMainForm.OnSuccessToReRegister();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnTryingToUnRegister(String sAccountName)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnTryingToUnRegisterREC();
            return;
        }

        MainForm.m_objMainForm.OnTryingToUnRegister();
    }

    public override void OnFailToUnRegister(String sAccountName)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnFailToUnRegisterREC();
            return;
        }

        MainForm.m_objMainForm.OnFailToUnRegister();
    }

    public override void OnSuccessToUnRegister(String sAccountName)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            m_bEnableREC = false;
            MainForm.m_objMainForm.OnSuccessToUnRegisterREC();
            
            return;
        }

        MainForm.m_objMainForm.OnSuccessToUnRegister();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnIncomingCallStarted(String sAccountName, String sCallId, String sCallerName, String sCallerId, String sDialNo, String sFromURI, String sToURI)
    {
        MainForm.m_objMainForm.OnIncomingCallStarted(sCallId, sCallerName, sCallerId);
    }

    public override void OnIncomingCallEnded(String sAccountName, String sCallId, int nReasonCode)
    {
        MainForm.m_objMainForm.OnIncomingCallEnded(sCallId);
    }

    public override void OnRingToneStarted(String sAccountName, String sCallId)
    {
        MainForm.m_objMainForm.OnRingToneStarted(sCallId);
    }

    public override void OnRingToneEnded(String sAccountName, String sCallId)
    {
        MainForm.m_objMainForm.OnRingToneEnded(sCallId);
    }
        
    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnDialCallStarted(String sAccountName, int nLineNo, String sCallerName, String sCallerId, String sDialNo)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnDialCallStartedREC(nLineNo, sCallerName, sCallerId, sDialNo);
            return;
        }

        MainForm.m_objMainForm.OnDialCallStarted(nLineNo, sCallerName, sCallerId, sDialNo);
    }

    public override void OnDialingCall(String sAccountName, int nLineNo, int nStatusCode, String sReasonPhrase)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnDialingCallREC(nLineNo, nStatusCode, sReasonPhrase);
            return;
        }

        MainForm.m_objMainForm.OnDialingCall(nLineNo, nStatusCode, sReasonPhrase);
    }

    public override void OnDialCallFailed(String sAccountName, int nLineNo, int nStatusCode, String sReasonPhrase, String sContact)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnDialCallFailedREC(nLineNo, nStatusCode, sReasonPhrase);
            return;
        }

        MainForm.m_objMainForm.OnDialCallFailed(nLineNo, nStatusCode, sReasonPhrase, sContact);
    }

    public override void OnConnectedCall(String sAccountName, int nLineNo, String sToRTPIP, int nToRTPPort)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnConnectedCallREC(nLineNo);
            return;
        }

        base.DetectAMD(nLineNo, m_bDetectAMD, 6000, 300, 2);
        MainForm.m_objMainForm.OnConnectedCall(nLineNo);
    }

    public override void OnHungupCall(String sAccountName, int nLineNo)
    {
        if (sAccountName == VAX_ACCOUNT_NAME_REC)
        {
            MainForm.m_objMainForm.OnHungupCallREC(nLineNo);
            return;
        }

        MainForm.m_objMainForm.OnHungupCall(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnSuccessToHold(String sAccountName, int nLineNo)
    {
       MainForm.m_objMainForm.OnSuccessToHold(nLineNo);
    }

    public override void OnTryingToHold(String sAccountName, int nLineNo)
    {
       MainForm.m_objMainForm.OnTryingToHold(nLineNo);
    }

    public override void OnFailToHold(String sAccountName, int nLineNo)
    {
       MainForm.m_objMainForm.OnFailToHold(nLineNo);
    }

    public override void OnSuccessToUnHold(String sAccountName, int nLineNo)
    {
       MainForm.m_objMainForm.OnSuccessToUnHold(nLineNo);
    }

    public override void OnTryingToUnHold(String sAccountName, int nLineNo)
    {
       MainForm.m_objMainForm.OnTryingToUnHold(nLineNo);
    }

    public override void OnFailToUnHold(String sAccountName, int nLineNo)
    {
       MainForm.m_objMainForm.OnFailToUnHold(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnTransferCallFailed(String sAccountName, int nLineNo, int nStatusCode, String sReasonPhrase)
    {
        MainForm.m_objMainForm.OnTransferCallFailed(nLineNo, nStatusCode, sReasonPhrase);
    }

    public override void OnTransferCallAccepted(String sAccountName, int nLineNo)
    {
        MainForm.m_objMainForm.OnTransferCallAccepted(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnIncomingDiagnostic(String sAccountName, String sMsgSIP, String sFromIP, int nFromPort)
    {
        
    }

    public override void OnOutgoingDiagnostic(String sAccountName, String sMsgSIP, String sToIP, int nToPort)
    {
        
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnVoiceMailMsg(String sAccountName, Boolean bIsMsgWaiting, int nNewMsgCount, int nOldMsgCount, int nNewUrgentMsgCount, int nOldUrgentMsgCount, String sMsgAccount)
    {
        MainForm.m_objMainForm.OnVoiceMailMsg(bIsMsgWaiting, nNewMsgCount, nOldMsgCount, nNewUrgentMsgCount, nOldUrgentMsgCount, sMsgAccount);
    }
        
    //////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    public override void OnChatSubscribeSuccess(String sAccountName, String sUserName)
    {
        MainForm.m_objMainForm.OnChatSubscribeSuccess(sUserName);
    }

    public override void OnChatSubscribeFailed(String sAccountName, String sUserName, int nStatusCode, String sReasonPhrase)
    {
        MainForm.m_objMainForm.OnChatSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
    }

    public override void OnChatContactStatus(String sAccountName, String sUserName, int nStatusId)
    {
        MainForm.m_objMainForm.OnChatContactStatus(sUserName, nStatusId);
    }

    public override void OnChatSendMsgTextSuccess(String sAccountName, String sUserName, String sMsgText, long nUserValue)
    {
        MainForm.m_objMainForm.OnChatSendMsgTextSuccess(sUserName, sMsgText, nUserValue);
    }

    public override void OnChatSendMsgTextFailed(String sAccountName, String sUserName, int nStatusCode, String sReasonPhrase, String sMsgText, long nUserValue)
    {
        MainForm.m_objMainForm.OnChatSendMsgTextFailed(sUserName, nStatusCode, sReasonPhrase, sMsgText, nUserValue);
    }

    public override void OnChatSendMsgTypingSuccess(String sAccountName, String sUserName, long nUserValue)
    {
        MainForm.m_objMainForm.OnChatSendMsgTypingSuccess(sUserName, nUserValue);
    }

    public override void OnChatSendMsgTypingFailed(String sAccountName, String sUserName, int nStatusCode, String sReasonPhrase, long nUserValue)
    {
        MainForm.m_objMainForm.OnChatSendMsgTypingFailed(sUserName, nStatusCode, sReasonPhrase, nUserValue);
    }

    public override void OnChatRecvMsgText(String sAccountName, String sUserName, String sMsgText, bool bIsChatContact)
    {
        MainForm.m_objMainForm.OnChatRecvMsgText(sUserName, sMsgText, bIsChatContact);
    }

    public override void OnChatRecvMsgTypingStart(String sAccountName, String sUserName)
    {
        MainForm.m_objMainForm.OnChatRecvMsgTypingStart(sUserName);
    }

    public override void OnChatRecvMsgTypingStop(String sAccountName, String sUserName)
    {
        MainForm.m_objMainForm.OnChatRecvMsgTypingStop(sUserName);
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////
        
    public override void OnDetectedAMD(String sAccountName, int nLineNo, Boolean bIsHuman)
    {
        MainForm.m_objMainForm.OnDetectedAMD(nLineNo, bIsHuman);
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    public override void OnBusyLampSubscribeSuccess(String sAccountName, String sUserName)
    {
        MainForm.m_objMainForm.OnBusyLampSubscribeSuccess(sUserName);
    }

    public override void OnBusyLampSubscribeFailed(String sAccountName, String sUserName, int nStatusCode, String sReasonPhrase)
    {
        MainForm.m_objMainForm.OnBusyLampSubscribeFailed(sUserName, nStatusCode, sReasonPhrase);
    }

    public override void OnBusyLampContactStatus(String sAccountName, String sUserName, int nStatusId)
    {
        MainForm.m_objMainForm.OnBusyLampContactStatus(sUserName, nStatusId);
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    public override void OnAudioDeviceMicVU(int nLevelVU)
    {
        MainForm.m_objMainForm.OnAudioDeviceMicVU(nLevelVU);
    }

    public override void OnAudioDeviceSpkVU(int nLevelVU)
    {
        MainForm.m_objMainForm.OnAudioDeviceSpkVU(nLevelVU);
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////

    public override void OnNetworkReachability(bool bAvailable)
    {
        MainForm.m_objMainForm.OnNetworkReachability(bAvailable);
    }

    //////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////

    private void OnStatusMsgREC(int nLineNo)
    {
        int nErrorCode = base.GetVaxErrorCode();
        String sErrorMsg = base.GetVaxErrorMsg();

        MainForm.m_objMainForm.OnStatusMsgREC(nLineNo, nErrorCode, sErrorMsg);
    }

    public override void OnVaxErrorMsg(string sFuncName, string sErrorMsg, int nErrorCode)
    {
        if (sFuncName == "DialRingEnable")
        {
            MessageBox.Show("Unable to access or find DialRing.wav file", "VaxVoIP SIP SDK", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            return;
        }

        if (sFuncName == "BusyRingEnable")
        {
            MessageBox.Show("Unable to access or find BusyRing.wav file", "VaxVoIP SIP SDK", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            return;
        }

        if (sFuncName == "OpenLineREC" || sFuncName == "DialCallToREC")
            return;

        MessageBox.Show(sErrorMsg, "VaxVoIP SIP SDK", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
    }
}

