﻿using System;
using System.Runtime.InteropServices;
using VAXSIPUSERAGENTCOMLib;

public class cVaxSIPUserAgentCOM
{
    public const int VAX_ACCOUNT_TYPE_UDP = 0;
    public const int VAX_ACCOUNT_TYPE_TCP = 1;
    public const int VAX_ACCOUNT_TYPE_TLS = 2;

    public const int VAX_VIDEO_QUALITY_LOW = 0;
    public const int VAX_VIDEO_QUALITY_STANDARD = 1;
    public const int VAX_VIDEO_QUALITY_MEDIUM = 2;
    public const int VAX_VIDEO_QUALITY_HIGH = 3;
    public const int VAX_VIDEO_QUALITY_MAX = 4;
                
    public const int VAX_AUDIO_CODEC_G711U = 0;
    public const int VAX_AUDIO_CODEC_G711A = 1;
    public const int VAX_AUDIO_CODEC_GSM610 = 2;
    public const int VAX_AUDIO_CODEC_ILBC = 3;
    public const int VAX_AUDIO_CODEC_G729 = 4;

    public const int VAX_VIDEO_CODEC_VP8 = 0;

    public const int VAX_DTMF_TYPE_AUTO = 0;
    public const int VAX_DTMF_TYPE_RFC2833 = 1;
    public const int VAX_DTMF_TYPE_SIP_INFO = 2;
    public const int VAX_DTMF_TYPE_INBAND = 3;

    public const int VAX_CAPTURE_SOUND_DEVICE_NONE = -2;
    
    public const int VAX_CONTACT_STATUS_ONLINE = 0;
    public const int VAX_CONTACT_STATUS_OFFLINE = 1;
    public const int VAX_CONTACT_STATUS_AWAY = 2;
    public const int VAX_CONTACT_STATUS_ON_PHONE = 3;
    public const int VAX_CONTACT_STATUS_BUSY = 4;
    public const int VAX_CONTACT_STATUS_UNKNOWN = 5;

    public const int VAX_BUSY_LAMP_STATUS_FREE = 0;
    public const int VAX_BUSY_LAMP_STATUS_OFFLINE = 1;
    public const int VAX_BUSY_LAMP_STATUS_BUSY = 2;
    public const int VAX_BUSY_LAMP_STATUS_UNKNOWN = 3;
    public const int VAX_BUSY_LAMP_STATUS_CONNECTING = 4;

    public const int VAX_CALL_HISTORY_TYPE_OUTBOUND = 0;
    public const int VAX_CALL_HISTORY_TYPE_INBOUND = 1;
    public const int VAX_CALL_HISTORY_TYPE_MISSED = 2;
    public const int VAX_CALL_HISTORY_TYPE_REJECTED = 3;

    public const int VAX_INCOMING_CALL_ACCEPTED = 0;
    public const int VAX_INCOMING_CALL_REJECTED = 1;
    public const int VAX_INCOMING_CALL_CANCELED = 2;

    public const int VAX_SIP_NETWORK_MODE_PRIORITY_AUTO = 0;
    public const int VAX_SIP_NETWORK_MODE_PRIORITY_IPV4 = 1;
    public const int VAX_SIP_NETWORK_MODE_PRIORITY_IPV6 = 2;

    
    private VaxVoIPSIP m_objVaxVoIP = new VaxVoIPSIP();

    public cVaxSIPUserAgentCOM()
    {
        m_objVaxVoIP.OnInitialized += new _IVaxVoIPSIPEvents_OnInitializedEventHandler(OnInitialized);
        m_objVaxVoIP.OnUnInitialized += new _IVaxVoIPSIPEvents_OnUnInitializedEventHandler(OnUnInitialized);
        m_objVaxVoIP.OnConnectingToRegister += new _IVaxVoIPSIPEvents_OnConnectingToRegisterEventHandler(OnConnectingToRegister);
        m_objVaxVoIP.OnTryingToRegister += new _IVaxVoIPSIPEvents_OnTryingToRegisterEventHandler(OnTryingToRegister);
        m_objVaxVoIP.OnFailToRegister += new _IVaxVoIPSIPEvents_OnFailToRegisterEventHandler(OnFailToRegister);
        m_objVaxVoIP.OnSuccessToRegister += new _IVaxVoIPSIPEvents_OnSuccessToRegisterEventHandler(OnSuccessToRegister);
        m_objVaxVoIP.OnConnectingToReRegister += new _IVaxVoIPSIPEvents_OnConnectingToReRegisterEventHandler(OnConnectingToReRegister);
        m_objVaxVoIP.OnTryingToReRegister += new _IVaxVoIPSIPEvents_OnTryingToReRegisterEventHandler(OnTryingToReRegister);
        m_objVaxVoIP.OnFailToReRegister += new _IVaxVoIPSIPEvents_OnFailToReRegisterEventHandler(OnFailToReRegister);
        m_objVaxVoIP.OnSuccessToReRegister += new _IVaxVoIPSIPEvents_OnSuccessToReRegisterEventHandler(OnSuccessToReRegister);
        m_objVaxVoIP.OnTryingToUnRegister += new _IVaxVoIPSIPEvents_OnTryingToUnRegisterEventHandler(OnTryingToUnRegister);
        m_objVaxVoIP.OnFailToUnRegister += new _IVaxVoIPSIPEvents_OnFailToUnRegisterEventHandler(OnFailToUnRegister);
        m_objVaxVoIP.OnSuccessToUnRegister += new _IVaxVoIPSIPEvents_OnSuccessToUnRegisterEventHandler(OnSuccessToUnRegister);

        m_objVaxVoIP.OnDialCallStarted += new _IVaxVoIPSIPEvents_OnDialCallStartedEventHandler(OnDialCallStarted);
        m_objVaxVoIP.OnDialingCall += new _IVaxVoIPSIPEvents_OnDialingCallEventHandler(OnDialingCall);
        m_objVaxVoIP.OnDialCallFailed += new _IVaxVoIPSIPEvents_OnDialCallFailedEventHandler(OnDialCallFailed);
        m_objVaxVoIP.OnConnectedCall += new _IVaxVoIPSIPEvents_OnConnectedCallEventHandler(OnConnectedCall);
        m_objVaxVoIP.OnHungupCall += new _IVaxVoIPSIPEvents_OnHungupCallEventHandler(OnHungupCall);
        m_objVaxVoIP.OnIncomingCallStarted += new _IVaxVoIPSIPEvents_OnIncomingCallStartedEventHandler(OnIncomingCallStarted);
        m_objVaxVoIP.OnIncomingCallEnded += new _IVaxVoIPSIPEvents_OnIncomingCallEndedEventHandler(OnIncomingCallEnded);
        m_objVaxVoIP.OnRingToneStarted += new _IVaxVoIPSIPEvents_OnRingToneStartedEventHandler(OnRingToneStarted);
        m_objVaxVoIP.OnRingToneEnded += new _IVaxVoIPSIPEvents_OnRingToneEndedEventHandler(OnRingToneEnded);
        m_objVaxVoIP.OnTransferCallAccepted += new _IVaxVoIPSIPEvents_OnTransferCallAcceptedEventHandler(OnTransferCallAccepted);
        m_objVaxVoIP.OnTransferCallFailed += new _IVaxVoIPSIPEvents_OnTransferCallFailedEventHandler(OnTransferCallFailed);
        m_objVaxVoIP.OnPlayWaveDone += new _IVaxVoIPSIPEvents_OnPlayWaveDoneEventHandler(OnPlayWaveDone);
        m_objVaxVoIP.OnDigitDTMF += new _IVaxVoIPSIPEvents_OnDigitDTMFEventHandler(OnDigitDTMF);
        m_objVaxVoIP.OnMsgNOTIFY += new _IVaxVoIPSIPEvents_OnMsgNOTIFYEventHandler(OnMsgNOTIFY);
        m_objVaxVoIP.OnVoiceMailMsg += new _IVaxVoIPSIPEvents_OnVoiceMailMsgEventHandler(OnVoiceMailMsg);
        m_objVaxVoIP.OnIncomingDiagnostic += new _IVaxVoIPSIPEvents_OnIncomingDiagnosticEventHandler(OnIncomingDiagnostic);
        m_objVaxVoIP.OnOutgoingDiagnostic += new _IVaxVoIPSIPEvents_OnOutgoingDiagnosticEventHandler(OnOutgoingDiagnostic);
        m_objVaxVoIP.OnAudioSessionLost += new _IVaxVoIPSIPEvents_OnAudioSessionLostEventHandler(OnAudioSessionLost);
        m_objVaxVoIP.OnSuccessToHold += new _IVaxVoIPSIPEvents_OnSuccessToHoldEventHandler(OnSuccessToHold);
        m_objVaxVoIP.OnTryingToHold += new _IVaxVoIPSIPEvents_OnTryingToHoldEventHandler(OnTryingToHold);
        m_objVaxVoIP.OnFailToHold += new _IVaxVoIPSIPEvents_OnFailToHoldEventHandler(OnFailToHold);
        m_objVaxVoIP.OnSuccessToUnHold += new _IVaxVoIPSIPEvents_OnSuccessToUnHoldEventHandler(OnSuccessToUnHold);
        m_objVaxVoIP.OnTryingToUnHold += new _IVaxVoIPSIPEvents_OnTryingToUnHoldEventHandler(OnTryingToUnHold);
        m_objVaxVoIP.OnFailToUnHold += new _IVaxVoIPSIPEvents_OnFailToUnHoldEventHandler(OnFailToUnHold);

        m_objVaxVoIP.OnTryingToRefresh += new _IVaxVoIPSIPEvents_OnTryingToRefreshEventHandler(OnTryingToRefresh);
        m_objVaxVoIP.OnFailToRefresh += new _IVaxVoIPSIPEvents_OnFailToRefreshEventHandler(OnFailToRefresh);
        m_objVaxVoIP.OnSuccessToRefresh += new _IVaxVoIPSIPEvents_OnSuccessToRefreshEventHandler(OnSuccessToRefresh);

        m_objVaxVoIP.OnChatSubscribeSuccess += new _IVaxVoIPSIPEvents_OnChatSubscribeSuccessEventHandler(OnChatSubscribeSuccess);
        m_objVaxVoIP.OnChatSubscribeFailed += new _IVaxVoIPSIPEvents_OnChatSubscribeFailedEventHandler(OnChatSubscribeFailed);

        m_objVaxVoIP.OnChatContactStatus += new _IVaxVoIPSIPEvents_OnChatContactStatusEventHandler(OnChatContactStatus);
        m_objVaxVoIP.OnChatSendMsgTextSuccess += new _IVaxVoIPSIPEvents_OnChatSendMsgTextSuccessEventHandler(OnChatSendMsgTextSuccess);
        m_objVaxVoIP.OnChatSendMsgTextFailed += new _IVaxVoIPSIPEvents_OnChatSendMsgTextFailedEventHandler(OnChatSendMsgTextFailed);
        m_objVaxVoIP.OnChatSendMsgTypingSuccess += new _IVaxVoIPSIPEvents_OnChatSendMsgTypingSuccessEventHandler(OnChatSendMsgTypingSuccess);
        m_objVaxVoIP.OnChatSendMsgTypingFailed += new _IVaxVoIPSIPEvents_OnChatSendMsgTypingFailedEventHandler(OnChatSendMsgTypingFailed);
        m_objVaxVoIP.OnChatRecvMsgText += new _IVaxVoIPSIPEvents_OnChatRecvMsgTextEventHandler(OnChatRecvMsgText);
        m_objVaxVoIP.OnChatRecvMsgTypingStart += new _IVaxVoIPSIPEvents_OnChatRecvMsgTypingStartEventHandler(OnChatRecvMsgTypingStart);
        m_objVaxVoIP.OnChatRecvMsgTypingStop += new _IVaxVoIPSIPEvents_OnChatRecvMsgTypingStopEventHandler(OnChatRecvMsgTypingStop);
        
        m_objVaxVoIP.OnDetectedAMD += new _IVaxVoIPSIPEvents_OnDetectedAMDEventHandler(OnDetectedAMD);
        m_objVaxVoIP.OnHoldCall += new _IVaxVoIPSIPEvents_OnHoldCallEventHandler(OnHoldCall);
        m_objVaxVoIP.OnUnHoldCall += new _IVaxVoIPSIPEvents_OnUnHoldCallEventHandler(OnUnHoldCall);

        m_objVaxVoIP.OnVideoDeviceFrameRGB += new _IVaxVoIPSIPEvents_OnVideoDeviceFrameRGBEventHandler(OnVideoDeviceFrameRGB);
        m_objVaxVoIP.OnVideoRemoteFrameRGB += new _IVaxVoIPSIPEvents_OnVideoRemoteFrameRGBEventHandler(OnVideoRemoteFrameRGB);
        m_objVaxVoIP.OnVideoRemoteStarted += new _IVaxVoIPSIPEvents_OnVideoRemoteStartedEventHandler(OnVideoRemoteStarted);
        m_objVaxVoIP.OnVideoRemoteEnded += new _IVaxVoIPSIPEvents_OnVideoRemoteEndedEventHandler(OnVideoRemoteEnded);
                
        m_objVaxVoIP.OnAddCallHistory += new _IVaxVoIPSIPEvents_OnAddCallHistoryEventHandler(OnAddCallHistory);
        m_objVaxVoIP.OnNetworkReachability += new _IVaxVoIPSIPEvents_OnNetworkReachabilityEventHandler(OnNetworkReachability);
        m_objVaxVoIP.OnAudioDeviceMicVU += new _IVaxVoIPSIPEvents_OnAudioDeviceMicVUEventHandler(OnAudioDeviceMicVU);
        m_objVaxVoIP.OnAudioDeviceSpkVU += new _IVaxVoIPSIPEvents_OnAudioDeviceSpkVUEventHandler(OnAudioDeviceSpkVU);
        m_objVaxVoIP.OnVaxErrorMsg += new _IVaxVoIPSIPEvents_OnVaxErrorMsgEventHandler(OnVaxErrorMsg);

        m_objVaxVoIP.OnBusyLampSubscribeSuccess += new _IVaxVoIPSIPEvents_OnBusyLampSubscribeSuccessEventHandler(OnBusyLampSubscribeSuccess);
        m_objVaxVoIP.OnBusyLampSubscribeFailed += new _IVaxVoIPSIPEvents_OnBusyLampSubscribeFailedEventHandler(OnBusyLampSubscribeFailed);
        m_objVaxVoIP.OnBusyLampContactStatus += new _IVaxVoIPSIPEvents_OnBusyLampContactStatusEventHandler(OnBusyLampContactStatus);
        
        m_objVaxVoIP.OnAudioRecordedPCM += new _IVaxVoIPSIPEvents_OnAudioRecordedPCMEventHandler(OnAudioRecordedPCM);
    }

    #region Methods

    public String GetVersionSDK()
    {
        return m_objVaxVoIP.GetVersionSDK();
    }

    public String GetVersionFile()
    {
        return m_objVaxVoIP.GetVersionFile();
    }

    public Boolean SetLicenceKey(String sLicenceKey)
    {
        return m_objVaxVoIP.SetLicenceKey(sLicenceKey);
    }

    public String GetCallId(int nLineNo)
    {
        return m_objVaxVoIP.GetCallId(nLineNo);
    }

    public Boolean AudioDeviceVU(Boolean bActivate, Boolean bMicVU, Boolean bSpkVU)
    {
        return m_objVaxVoIP.AudioDeviceVU(bActivate, bMicVU, bSpkVU);
    }

    public int GetAudioInDevTotal()
    {
        return m_objVaxVoIP.GetAudioInDevTotal();
    }

    public int GetAudioOutDevTotal()
    {
        return m_objVaxVoIP.GetAudioOutDevTotal();
    }

    public String GetAudioInDevName(int nDeviceId)
    {
        return m_objVaxVoIP.GetAudioInDevName(nDeviceId);
    }

    public String GetAudioOutDevName(int nDeviceId)
    {
        return m_objVaxVoIP.GetAudioOutDevName(nDeviceId);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean Initialize()
    {
        return m_objVaxVoIP.Initialize();
    }

    public void UnInitialize()
    {
        m_objVaxVoIP.UnInitialize();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean AddAccountSIP(String sAccountName, int nAccountType, String sListenIP, int nListenPort, String sDisplayName, String sUserName, String sAuthLogin, String sAuthPwd, String sDomainRealm, String sServerAddr, int nServerPort)
    {
        return m_objVaxVoIP.AddAccountSIP(sAccountName, nAccountType, sListenIP, nListenPort, sDisplayName, sUserName, sAuthLogin, sAuthPwd, sDomainRealm, sServerAddr, nServerPort);
    }

    public void RemoveAccountSIP(String sAccountName)
    {
        m_objVaxVoIP.RemoveAccountSIP(sAccountName);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean RegisterAccountSIP(String sAccountName, int nExpire)
    {
        return m_objVaxVoIP.RegisterAccountSIP(sAccountName, nExpire);
    }

    public Boolean UnRegisterAccountSIP(String sAccountName)
    {
        return m_objVaxVoIP.UnRegisterAccountSIP(sAccountName);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean OpenLine(int nLineNo, String sRTPRxIP, int nRxAudioPortRTP, int nRxVideoPortRTP)
    {
        return m_objVaxVoIP.OpenLine(nLineNo, sRTPRxIP, nRxAudioPortRTP, nRxVideoPortRTP);
    }

    public Boolean OpenLineREC(int nLineNo, String sRTPRxIP, int nAudioPortRTP)
    {
        return m_objVaxVoIP.OpenLineREC(nLineNo, sRTPRxIP, nAudioPortRTP);
    }

    public Boolean CloseLine(int nLineNo)
    {
        return m_objVaxVoIP.CloseLine(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public int GetVaxErrorCode()
    {
        return m_objVaxVoIP.GetVaxErrorCode();
    }

    public String GetVaxErrorMsg()
    {
        return m_objVaxVoIP.GetVaxErrorMsg();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean DialCall(String sAccountName, int nLineNo, String sCallerName, String sCallerId, String sDialNo, int nInputDeviceId, int nOutputDeviceId)
    {
        return m_objVaxVoIP.DialCall(sAccountName, nLineNo, sCallerName, sCallerId, sDialNo, nInputDeviceId, nOutputDeviceId);
    }

    public Boolean DisconnectCall(int nLineNo)
    {
        return m_objVaxVoIP.DisconnectCall(nLineNo);
    }

    public Boolean AcceptCall(int nLineNo, String sCallId, int nInputDeviceId, int nOutputDeviceId)
    {
        return m_objVaxVoIP.AcceptCall(nLineNo, sCallId, nInputDeviceId, nOutputDeviceId);
    }

    public Boolean RejectCall(String sCallId)
    {
        return m_objVaxVoIP.RejectCall(sCallId);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean TransferCallBlind(int nLineNo, String sToUserName)
    {
        return m_objVaxVoIP.TransferCallBlind(nLineNo, sToUserName);
    }

    public Boolean TransferCallConsult(int nLineNoA, int nLineNoB)
    {
        return m_objVaxVoIP.TransferCallConsult(nLineNoA, nLineNoB);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean HoldLine(int nLineNo)
    {
        return m_objVaxVoIP.HoldLine(nLineNo);
    }

    public Boolean UnHoldLine(int nLineNo)
    {
        return m_objVaxVoIP.UnHoldLine(nLineNo);
    }

    public Boolean RefreshLine(int nLineNo)
    {
        return m_objVaxVoIP.RefreshLine(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean IsLineOpen(int nLineNo)
    {
        return m_objVaxVoIP.IsLineOpen(nLineNo);
    }

    public Boolean IsLineHold(int nLineNo)
    {
        return m_objVaxVoIP.IsLineHold(nLineNo);
    }

    public Boolean IsLineBusy(int nLineNo)
    {
        return m_objVaxVoIP.IsLineBusy(nLineNo);
    }

    public Boolean IsLineConnected(int nLineNo)
    {
        return m_objVaxVoIP.IsLineConnected(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean EnableKeepAlive(String sAccountName, int nSeconds)
    {
        return m_objVaxVoIP.EnableKeepAlive(sAccountName, nSeconds);
    }

    public void DisableKeepAlive(String sAccountName)
    {
        m_objVaxVoIP.DisableKeepAlive(sAccountName);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public void DeselectAllAudioCodec()
    {
        m_objVaxVoIP.DeselectAllAudioCodec();
    }

    public void SelectAllAudioCodec()
    {
        m_objVaxVoIP.SelectAllAudioCodec();
    }

    public Boolean SelectAudioCodec(int nCodecNo)
    {
        return m_objVaxVoIP.SelectAudioCodec(nCodecNo);
    }

    public Boolean DeselectAudioCodec(int nCodecNo)
    {
        return m_objVaxVoIP.DeselectAudioCodec(nCodecNo);
    }

    public void DeselectAllVideoCodec()
    {
        m_objVaxVoIP.DeselectAllVideoCodec();
    }

    public void SelectAllVideoCodec()
    {
        m_objVaxVoIP.SelectAllVideoCodec();
    }

    public Boolean SelectVideoCodec(int nCodecNo)
    {
        return m_objVaxVoIP.SelectVideoCodec(nCodecNo);
    }

    public void DeselectVideoCodec(int nCodecNo)
    {
        m_objVaxVoIP.DeselectVideoCodec(nCodecNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean DigitDTMF(int nLineNo, String sDigit, int nTypeDTMF)
    {
        return m_objVaxVoIP.DigitDTMF(nLineNo, sDigit, nTypeDTMF);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean SetVolumeDTMF(int nVolume)
    {
        return m_objVaxVoIP.SetVolumeDTMF(nVolume);
    }

    public int GetVolumeDTMF()
    {
        return m_objVaxVoIP.GetVolumeDTMF();
    }
        
    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean MuteMic(Boolean bMute)
    {
        return m_objVaxVoIP.MuteMic(bMute);
    }

    public Boolean MuteSpk(Boolean bMute)
    {
        return m_objVaxVoIP.MuteSpk(bMute);
    }

    public Boolean MuteLineSpk(int nLineNo, Boolean bMute)
    {
        return m_objVaxVoIP.MuteLineSpk(nLineNo, bMute);
    }

    public Boolean MuteLineMic(int nLineNo, Boolean bMute)
    {
        return m_objVaxVoIP.MuteLineMic(nLineNo, bMute);
    }

    public Boolean AutoGainMic(Boolean bEnable, int nVolume)
    {
        return m_objVaxVoIP.AutoGainMic(bEnable, nVolume);
    }

    public Boolean AutoGainSpk(Boolean bEnable, int nVolume)
    {
        return m_objVaxVoIP.AutoGainSpk(bEnable, nVolume);
    }

    public Boolean SetVolumeMic(int nVolume)
    {
        return m_objVaxVoIP.SetVolumeMic(nVolume);
    }

    public int GetVolumeMic()
    {
        return m_objVaxVoIP.GetVolumeMic();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean SetVolumeSpk(int nVolume)
    {
        return m_objVaxVoIP.SetVolumeSpk(nVolume);
    }

    public int GetVolumeSpk()
    {
        return m_objVaxVoIP.GetVolumeSpk();
    }

    public Boolean SetLineVolumeSpk(int nLineNo, int nVolume)
    {
        return m_objVaxVoIP.SetLineVolumeSpk(nLineNo, nVolume);
    }

    public int GetLineVolumeSpk(int nLineNo)
    {
        return m_objVaxVoIP.GetLineVolumeSpk(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean EchoCancellation(Boolean bEnable)
    {
        return m_objVaxVoIP.EchoCancellation(bEnable);
    }

    public Boolean DonotDisturb(Boolean bEnable)
    {
        return m_objVaxVoIP.DonotDisturb(bEnable);
    }

    public Boolean IsLineRecording(int nLineNo)
    {
        return m_objVaxVoIP.IsLineRecording(nLineNo);
    }

    public Boolean StartRecording(int nLineNo, String sFileName, int nTypeRecord, int nTypePCM)
    {
        return m_objVaxVoIP.StartRecording(nLineNo, sFileName, nTypeRecord, nTypePCM);
    }

    public Boolean StopRecording(int nLineNo)
    {
        return m_objVaxVoIP.StopRecording(nLineNo);
    }

    public Boolean ResetRecording(int nLineNo)
    {
        return m_objVaxVoIP.ResetRecording(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean IsLinePlaying(int nLineNo)
    {
        return m_objVaxVoIP.IsLinePlaying(nLineNo);
    }

    public Boolean PlayWaveOpen(int nLineNo, String sFileName)
    {
        return m_objVaxVoIP.PlayWaveOpen(nLineNo, sFileName);
    }

    public Boolean PlayWaveClose(int nLineNo)
    {
        return m_objVaxVoIP.PlayWaveClose(nLineNo);
    }

    public Boolean PlayWaveSkipTo(int nLineNo, int nSeconds)
    {
        return m_objVaxVoIP.PlayWaveSkipTo(nLineNo, nSeconds);
    }

    public int PlayWaveTotalTime(int nLineNo)
    {
        return m_objVaxVoIP.PlayWaveTotalTime(nLineNo);
    }

    public Boolean PlayWavePause(int nLineNo)
    {
        return m_objVaxVoIP.PlayWavePause(nLineNo);
    }

    public Boolean PlayWaveStart(int nLineNo, Boolean bListen)
    {
        return m_objVaxVoIP.PlayWaveStart(nLineNo, bListen);
    }

    public Boolean PlayWaveStop(int nLineNo)
    {
        return m_objVaxVoIP.PlayWaveStop(nLineNo);
    }

    public int PlayWavePosition(int nLineNo)
    {
        return m_objVaxVoIP.PlayWavePosition(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public int GetOutboundCodec(int nLineNo)
    {
        return m_objVaxVoIP.GetOutboundCodec(nLineNo);
    }

    public int GetInboundCodec(int nLineNo)
    {
        return m_objVaxVoIP.GetInboundCodec(nLineNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean AudioSessionLost(int nSeconds)
    {
        return m_objVaxVoIP.AudioSessionLost(nSeconds);
    }

    public Boolean SetUserAgentSIP(String sUserAgentName)
    {
        return m_objVaxVoIP.SetUserAgentSIP(sUserAgentName);
    }

    public String GetUserAgentSIP()
    {
        return m_objVaxVoIP.GetUserAgentSIP();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean SetSubjectSDP(String sSubjectSDP)
    {
        return m_objVaxVoIP.SetSubjectSDP(sSubjectSDP);
    }

    public String GetSubjectSDP()
    {
        return m_objVaxVoIP.GetSubjectSDP();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean ConfAllowLine(int nLineNo, Boolean bAllowListen, Boolean bAllowSpeak)
    {
        return m_objVaxVoIP.ConfAllowLine(nLineNo, bAllowListen, bAllowSpeak);
    }

    public Boolean LineVoiceChannelSpk(int nLineNo, int nChannel)
    {
        return m_objVaxVoIP.LineVoiceChannelSpk(nLineNo, nChannel);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean ChatFindContact(String sAccountName, String sUserName)
    {
        return m_objVaxVoIP.ChatFindContact(sAccountName, sUserName);
    }

    public Boolean ChatAddContact(String sAccountName, String sUserName, Boolean bPresence)
    {
        return m_objVaxVoIP.ChatAddContact(sAccountName, sUserName, bPresence);
    }

    public Boolean ChatRemoveContact(String sAccountName, String sUserName)
    {
        return m_objVaxVoIP.ChatRemoveContact(sAccountName, sUserName);
    }
    public Boolean ChatSendMessageTyping(String sAccountName, String sUserName, long nUserValue)
    {
        return m_objVaxVoIP.ChatSendMessageTyping(sAccountName, sUserName, nUserValue);
    }
    
    public Boolean ChatSendMessageText(String sAccountName, String sUserName, String sMsgText, Boolean bMsgTypeHtml, long nUserValue)
    {
        return m_objVaxVoIP.ChatSendMessageText(sAccountName, sUserName, sMsgText, bMsgTypeHtml, nUserValue);
    }

    public Boolean ChatSetMyStatus(String sAccountName, int nStatusId)
    {
        return m_objVaxVoIP.ChatSetMyStatus(sAccountName, nStatusId);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean VoiceChanger(int nPitch)
    {
        return m_objVaxVoIP.VoiceChanger(nPitch);
    }

    public Boolean ForwardCall(Boolean bEnable, String sToUserName)
    {
        return m_objVaxVoIP.ForwardCall(bEnable, sToUserName);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean PlayAddPCM(int nLineNo, Byte[] aDataPCM, int nSizePCM)
    {
        GCHandle hHandleGC = GCHandle.Alloc(aDataPCM, GCHandleType.Pinned);
        IntPtr AddrDataPCM = hHandleGC.AddrOfPinnedObject();
        int nDataPCM = AddrDataPCM.ToInt32();

        Boolean bResult = m_objVaxVoIP.PlayAddPCM(nLineNo, nDataPCM, nSizePCM);
        hHandleGC.Free();

        return bResult;
    }

    public Boolean PlayResetPCM(int nLineNo)
    {
        return m_objVaxVoIP.PlayResetPCM(nLineNo);
    }
        
    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean DetectAMD(int nLineNo, Boolean bEnable, int nAnalysisTime, int nSilenceTime, int nSilenceCount)
    {
        return m_objVaxVoIP.DetectAMD(nLineNo, bEnable, nAnalysisTime, nSilenceTime, nSilenceCount);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean AddCustomHeader(int nLineNo, int nReqId, String sName, String sValue)
    {
        return m_objVaxVoIP.AddCustomHeader(nLineNo, nReqId, sName, sValue);
    }

    public Boolean RemoveCustomHeader(int nLineNo, int nReqId, String sName)
    {
        return m_objVaxVoIP.RemoveCustomHeader(nLineNo, nReqId, sName);
    }

    public Boolean RemoveCustomHeaderAll(int nLineNo, int nReqId)
    {
        return m_objVaxVoIP.RemoveCustomHeaderAll(nLineNo, nReqId);
    }
       
    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public int GetCountPacketLost(int nLineNo)
    {
        return m_objVaxVoIP.GetCountPacketLost(nLineNo);
    }

    public int GetSizeJitterBuffer(int nLineNo)
    {
        return m_objVaxVoIP.GetSizeJitterBuffer(nLineNo);
    }

    public Boolean OpenMediaSecondry(int nInputDeviceId, int nOutputDeviceId)
    {
        return m_objVaxVoIP.OpenMediaSecondry(nInputDeviceId, nOutputDeviceId);
    }

    public Boolean CloseMediaSecondry()
    {
        return m_objVaxVoIP.CloseMediaSecondry();
    }

    public Boolean ChangeMEDIA(int nLineNo, int nInputDeviceId, int nOutputDeviceId)
    {
        return m_objVaxVoIP.ChangeMEDIA(nLineNo, nInputDeviceId, nOutputDeviceId);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public int GetVideoDevTotal()
    {
        return m_objVaxVoIP.GetVideoDevTotal();
    }

    public String GetVideoDevName(int nDeviceId)
    {
        return m_objVaxVoIP.GetVideoDevName(nDeviceId);
    }

    public Boolean OpenVideoDev(int nDeviceId, int nQuality)
    {
        return m_objVaxVoIP.OpenVideoDev(nDeviceId, nQuality);
    }

    public void CloseVideoDev()
    {
        m_objVaxVoIP.CloseVideoDev();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean CryptoMediaNONE(Boolean bForced)
    {
        return m_objVaxVoIP.CryptoMediaNONE(bForced);
    }

    public Boolean CryptoMediaSDP(Boolean bForced)
    {
        return m_objVaxVoIP.CryptoMediaSDP(bForced);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean DialCallToREC(String sAccountName, int nLineNo, String sDialNo)
    {
        return m_objVaxVoIP.DialCallToREC(sAccountName, nLineNo, sDialNo);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean DialRingEnable(String sFileName)
    {
        return m_objVaxVoIP.DialRingEnable(sFileName);
    }

    public Boolean DialRingDisable()
    {
        return m_objVaxVoIP.DialRingDisable();
    }

    public Boolean BusyRingEnable(String sFileName)
    {
        return m_objVaxVoIP.BusyRingEnable(sFileName);
    }

    public Boolean BusyRingDisable()
    {
        return m_objVaxVoIP.BusyRingDisable();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean EnableVideo(int nLineNo, Boolean bOutbound, Boolean bInbound)
    {
        return m_objVaxVoIP.EnableVideo(nLineNo, bOutbound, bInbound);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean IsNetworkAvailable()
    {
        return m_objVaxVoIP.IsNetworkAvailable();
    }

    public Boolean NetworkReachability(Boolean bEnable)
    {
        return m_objVaxVoIP.NetworkReachability(bEnable);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean AutoRegistration(String sAccountName, Boolean bEnable, int nTickCountLimit, int nTickSeconds)
    {
        return m_objVaxVoIP.AutoRegistration(sAccountName, bEnable, nTickCountLimit, nTickSeconds);
    }

    public Boolean VideoCodecBitRate(int nCodecNo, int nQuality)
    {
        return m_objVaxVoIP.VideoCodecBitRate(nCodecNo, nQuality);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////

    public int BusyLampGetContactStatus(String sAccountName, String sUserName)
    {
        return m_objVaxVoIP.BusyLampGetContactStatus(sAccountName, sUserName);
    }

    public Boolean BusyLampFindContact(String sAccountName, String sUserName)
    {
        return m_objVaxVoIP.BusyLampFindContact(sAccountName, sUserName);
    }

    public Boolean BusyLampAddContact(String sAccountName, String sUserName)
    {
        return m_objVaxVoIP.BusyLampAddContact(sAccountName, sUserName);
    }

    public Boolean BusyLampRemoveContact(String sAccountName, String sUserName)
    {
        return m_objVaxVoIP.BusyLampRemoveContact(sAccountName, sUserName);
    }

    public Boolean BusyLampSubscribeContactAll(String sAccountName)
    {
        return m_objVaxVoIP.BusyLampSubscribeContactAll(sAccountName);
    }

    public Boolean AudioVAD(int nLineNo, Boolean bEnable)
    {
        return m_objVaxVoIP.AudioVAD(nLineNo, bEnable);
    }

    public Boolean SetNetworkPrioritySIP(int nMode)
    {
        return m_objVaxVoIP.SetNetworkPrioritySIP(nMode);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public Boolean DiagnosticLogSIP(String sAccountName, Boolean bInbound, Boolean bOutbound)
    {
        return m_objVaxVoIP.DiagnosticLogSIP(sAccountName, bInbound, bOutbound);
    }
        
    #endregion

    //////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////

    #region Events


    public virtual void OnInitialized()
    {
        
    }

    public virtual void OnUnInitialized()
    {
        
    }

    public virtual void OnConnectingToRegister(String sAccountName)
    {
        
    }

    public virtual void OnTryingToRegister(String sAccountName)
    {
        
    }

    public virtual void OnFailToRegister(String sAccountName, int nStatusCode, String sReasonPhrase)
    {
        
    }

    public virtual void OnSuccessToRegister(String sAccountName)
    {
        
    }

    public virtual void OnConnectingToReRegister(String sAccountName)
    {
        
    }

    public virtual void OnTryingToReRegister(String sAccountName)
    {
        
    }

    public virtual void OnFailToReRegister(String sAccountName, int nStatusCode, String sReasonPhrase)
    {
        
    }

    public virtual void OnSuccessToReRegister(String sAccountName)
    {
        
    }

    public virtual void OnTryingToUnRegister(String sAccountName)
    {
        
    }

    public virtual void OnFailToUnRegister(String sAccountName)
    {
        
    }

    public virtual void OnSuccessToUnRegister(String sAccountName)
    {
        
    }

    public virtual void OnDialCallStarted(String sAccountName, int nLineNo, String sCallerName, String sCallerId, String sDialNo)
    {
        
    }

    public virtual void OnDialingCall(String sAccountName, int nLineNo, int nStatusCode, String sReasonPhrase)
    {
        
    }

    public virtual void OnDialCallFailed(String sAccountName, int nLineNo, int nStatusCode, String sReasonPhrase, String sContact)
    {
        
    }

    public virtual void OnConnectedCall(String sAccountName, int nLineNo, String sToRTPIP, int nToRTPPort)
    {
        
    }

    public virtual void OnHungupCall(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnIncomingCallStarted(String sAccountName, String sCallId, String sCallerName, String sCallerId, String sDialNo, String sFromURI, String sToURI)
    {
        
    }

    public virtual void OnIncomingCallEnded(String sAccountName, String sCallId, int nReasonCode)
    {
        
    }

    public virtual void OnRingToneStarted(String sAccountName, String sCallId)
    {
        
    }

    public virtual void OnRingToneEnded(String sAccountName, String sCallId)
    {
        
    }

    public virtual void OnTransferCallAccepted(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnTransferCallFailed(String sAccountName, int nLineNo, int nStatusCode, String sReasonPhrase)
    {
        
    }

    public virtual void OnPlayWaveDone(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnDigitDTMF(String sAccountName, int nLineNo, String sDigit)
    {
        
    }

    public virtual void OnMsgNOTIFY(String sAccountName, String sMsg)
    {
        
    }

    public virtual void OnVoiceMailMsg(String sAccountName, Boolean bIsMsgWaiting, int nNewMsgCount, int nOldMsgCount, int nNewUrgentMsgCount, int nOldUrgentMsgCount, String sMsgAccount)
    {
        
    }

    public virtual void OnIncomingDiagnostic(String sAccountName, String sMsgSIP, String sFromIP, int nFromPort)
    {
        
    }

    public virtual void OnOutgoingDiagnostic(String sAccountName, String sMsgSIP, String sToIP, int nToPort)
    {
        
    }

    public virtual void OnAudioSessionLost(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnSuccessToHold(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnTryingToHold(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnFailToHold(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnSuccessToUnHold(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnTryingToUnHold(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnFailToUnHold(String sAccountName, int nLineNo)
    {
        
    }


    public virtual void OnTryingToRefresh(String sAccountName, int nLineNo)
    {

    }

    public virtual void OnFailToRefresh(String sAccountName, int nLineNo)
    {

    }

    public virtual void OnSuccessToRefresh(String sAccountName, int nLineNo)
    {

    }


    public virtual void OnChatSubscribeSuccess(String sAccountName, String sUserName)
    {

    }

    public virtual void OnChatSubscribeFailed(String sAccountName, String sUserName, int nStatusCode, String sReasonPhrase)
    {

    }

    public virtual void OnChatContactStatus(String sAccountName, String sUserName, int nStatusId)
    {
        
    }

    public virtual void OnChatSendMsgTextSuccess(String sAccountName, String sUserName, String sMsgText, long nUserValue)
    {
        
    }

    public virtual void OnChatSendMsgTextFailed(String sAccountName, String sUserName, int nStatusCode, String sReasonPhrase, String sMsgText, long nUserValue)
    {
        
    }

    public virtual void OnChatSendMsgTypingSuccess(String sAccountName, String sUserName, long nUserValue)
    {
        
    }

    public virtual void OnChatSendMsgTypingFailed(String sAccountName, String sUserName, int sStatusCode, String sReasonPhrase, long nUserValue)
    {
        
    }

    public virtual void OnChatRecvMsgText(String sAccountName, String sUserName, String sMsgText, Boolean bIsChatContact)
    {
        
    }

    public virtual void OnChatRecvMsgTypingStart(String sAccountName, String sUserName)
    {
        
    }

    public virtual void OnChatRecvMsgTypingStop(String sAccountName, String sUserName)
    {
        
    }
        
    public virtual void OnDetectedAMD(String sAccountName, int nLineNo, Boolean bIsHuman)
    {
        
    }

    public virtual void OnHoldCall(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnUnHoldCall(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnVideoDeviceFrameRGB(int nDeviceId, long lFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
    {
        
    }

    public virtual void OnVideoRemoteFrameRGB(String sAccountName, int nLineNo, long lFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
    {
        
    }

    public virtual void OnVideoRemoteStarted(String sAccountName, int nLineNo)
    {
        
    }

    public virtual void OnVideoRemoteEnded(String sAccountName, int nLineNo)
    {
        
    }
        
    public virtual void OnAddCallHistory(String sAccountName, Boolean bOutboundCallType, String sCallerName, String sCallerId, String sDialNo, ulong lStartTime, ulong lEndTime, ulong lDuration, ulong lDayNo, int nHistoryTypeId)
    {
        
    }

    public virtual void OnNetworkReachability(Boolean bAvailable)
    {
        
    }

    public virtual void OnAudioDeviceMicVU(int nLevelVU)
    {
        
    }

    public virtual void OnAudioDeviceSpkVU(int nLevelVU)
    {
        
    }

    public virtual void OnVaxErrorMsg(String sFuncName, String sErrorMsg, int nErrorCode)
    {
        
    }

    public virtual void OnBusyLampSubscribeSuccess(String sAccountName, String sUserName)
    {
        
    }

    public virtual void OnBusyLampSubscribeFailed(String sAccountName, String sUserName, int nStatusCode, String sReasonPhrase)
    {
        
    }

    public virtual void OnBusyLampContactStatus(String sAccountName, String sUserName, int nStatusId)
    {
        
    }

    public virtual void OnAudioRecordedPCM(String sAccountName, int nLineNo, long lDataPCM, int nSizePCM, int nTypePCM)
    {

    }

    #endregion
}
