﻿using System;
using System.Collections;
using Microsoft.Win32;


class cStoreRegistry
{
    const String REGISTRY_ROOT_PATH = "SOFTWARE\\VaxPhoneSDKv6";

    private RegistryKey m_hKey;

    public cStoreRegistry()
    {
        Open();
    }

    ////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////

    private void Open()
    {
        if (m_hKey != null)
            return;

        m_hKey = Registry.CurrentUser.CreateSubKey(REGISTRY_ROOT_PATH);
    }

    public void Close()
    {
        if (m_hKey != null)
        {
            m_hKey.Close();
            m_hKey = null;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////

    private RegistryKey CreateKey(String sKeyName)
    {
        if (m_hKey == null)
            return null;

        if (sKeyName.Length == 0)
            return null;

        return m_hKey.CreateSubKey(sKeyName);
    }

    private RegistryKey OpenKey(String sKeyName, Boolean bWritable)
    {
        if (m_hKey == null)
            return null;

        if (sKeyName.Length == 0)
            return null;

        return m_hKey.OpenSubKey(sKeyName, bWritable);
    }

    //////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////

    public Boolean SetTEXT(String sKeyName, String sValueName, String sValueData)
    {
        if (sValueName.Length == 0) return false;

        RegistryKey hKey = CreateKey(sKeyName);
        if (hKey == null) return false;

        hKey.SetValue(sValueName, sValueData, RegistryValueKind.String);
        hKey.Close();

        return true;
    }

    public Boolean SetINT(String sKeyName, String sValueName, int nValueData)
    {
        if (sValueName.Length == 0) return false;

        RegistryKey hKey = CreateKey(sKeyName);
        if (hKey == null) return false;

        hKey.SetValue(sValueName, nValueData, RegistryValueKind.DWord);
        hKey.Close();

        return true;
    }

    public Boolean SetBOOL(String sKeyName, String sValueName, Boolean bValueData)
    {
        int nValueData = bValueData ? 1 : 0;

        return this.SetINT(sKeyName, sValueName, nValueData);
    }

    ////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////

    public void GetTEXT(String sKeyName, String sValueName, ref String sValueData, String sValueDefault)
    {
        if (sValueName.Length == 0)
        {
            sValueData = sValueDefault;
            return;
        }

        RegistryKey hKey = OpenKey(sKeyName, false);
        if (hKey == null)
        {
            sValueData = sValueDefault;
            return;
        }

        sValueData = (String)hKey.GetValue(sValueName, sValueDefault);
        hKey.Close();
    }

    public Boolean GetINT(String sKeyName, String sValueName, ref int nValueData, int nValueDefault)
    {
        if (sValueName.Length == 0)
        {
            nValueData = nValueDefault;
            return false;
        }

        RegistryKey hKey = OpenKey(sKeyName, false);

        if (hKey == null)
        {
            nValueData = nValueDefault;
            return false;
        }

        nValueData = (int)hKey.GetValue(sValueName, nValueDefault);
        hKey.Close();

        return true;
    }

    public void GetBOOL(String sKeyName, String sValueName, ref Boolean bValueData, Boolean bValueDefault)
    {
        int nValueData = 0;
        int nValueDefault = bValueDefault ? 1 : 0;

        if (!GetINT(sKeyName, sValueName, ref nValueData, nValueDefault))
        {
            bValueData = bValueDefault;
            return;
        }

        if (nValueData == 0)
            bValueData = false;
        else
            bValueData = true;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////

    public void DeleteSubKey(String sKeyName)
    {
        if (sKeyName.Length == 0)
            return;

        m_hKey.DeleteSubKeyTree(sKeyName, false);
    }

    public Boolean DeleteValue(String sKeyRootName, String sValueName)
    {
        if (sValueName.Length == 0)
            return false;

        RegistryKey hKey = OpenKey(sKeyRootName, true);
        if (hKey == null) return false;

        hKey.DeleteValue(sValueName, false);
        hKey.Close();

        return true;
    }

    public Boolean EnumValueNames(String sKeyRootName, ref ArrayList objList)
    {
        objList.Clear();

        RegistryKey hKey = OpenKey(sKeyRootName, false);
        if (hKey == null) return false;

        String[] arrayLogin = (String[])hKey.GetValueNames();

        for (int nCount = 0; nCount < arrayLogin.Length; nCount++)
            objList.Add(arrayLogin[nCount]);

        hKey.Close();

        return true;
    }

    public Boolean EnumSubKeys(String sKeyRootName, ref ArrayList objList)
    {
        objList.Clear();

        RegistryKey hKey = OpenKey(sKeyRootName, false);
        if (hKey == null) return false;

        String[] arrayLogin = (String[])hKey.GetSubKeyNames();
                
        for (int nCount = 0; nCount < arrayLogin.Length; nCount++)
            objList.Add(arrayLogin[nCount]);

        hKey.Close();

        return true;
    }

    public Boolean IsKeyExist(String sKeyName)
    {
        RegistryKey hKey = OpenKey(sKeyName, false);
        if (hKey == null) return false;

        hKey.Close();
        return true;
    }
}

