﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace VaxVoIP
{
    public partial class MainSettingForm : Form
    {
        private cVaxSIPUserAgentExCOM m_objVaxUserAgent; 

        public MainSettingForm(ref cVaxSIPUserAgentExCOM objVaxUserAgent)
        {
            InitializeComponent();
            m_objVaxUserAgent = objVaxUserAgent;
            
            CheckG711U.Checked = true;
            CheckG729.Checked = true;
            CheckG711A.Checked = true;
            CheckGSM610.Checked = false;
            CheckiLBC.Checked = false;
                        
            RadioForceNone.Checked = true;

            UpdateAudioIn();
            UpdateAudioOut();
        }

        public void OnVaxOnline()
        {
            ActivateAudioCodecs();
                                    
            ActivateOtherSettings();
            ActivateDigitDTMF();
        }

        public void OnVaxOffline()
        {

        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////

        private void UpdateAudioIn()
        {
            String sDeviceName;
            int nDeviceId; 

            ListBoxAudioIn.Items.Clear();
            ListBoxAudioIn.Items.Add(new cMediaDevice(-1, "Default Device"));

            for (nDeviceId = 0; nDeviceId < m_objVaxUserAgent.GetAudioInDevTotal(); nDeviceId++)
            {
                sDeviceName = m_objVaxUserAgent.GetAudioInDevName(nDeviceId);

                ListBoxAudioIn.Items.Add(new cMediaDevice(nDeviceId, sDeviceName));
            }

            ListBoxAudioIn.SelectedIndex = 0;

            cMediaDevice objAudioDevice = (cMediaDevice)ListBoxAudioIn.Items[0];
            
            nDeviceId = objAudioDevice.m_nDeviceId;
            m_objVaxUserAgent.SetActiveAudioInDevice(nDeviceId);
        }

        private void UpdateAudioOut()
        {
            int nDeviceId;
            String sDeviceName;

            ListBoxAudioOut.Items.Clear();
            ListBoxAudioOut.Items.Add(new cMediaDevice(-1, "Default Device"));

            for (nDeviceId = 0; nDeviceId < m_objVaxUserAgent.GetAudioOutDevTotal(); nDeviceId++)
            {
                sDeviceName = m_objVaxUserAgent.GetAudioOutDevName(nDeviceId);

                ListBoxAudioOut.Items.Add(new cMediaDevice(nDeviceId, sDeviceName));
            }

            ListBoxAudioOut.SelectedIndex = 0;

            cMediaDevice objAudioDevice = (cMediaDevice)ListBoxAudioOut.Items[0];

            nDeviceId = objAudioDevice.m_nDeviceId;
            m_objVaxUserAgent.SetActiveAudioOutDevice(nDeviceId);
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////
        
        private void ActivateAudioCodecs()
        {
            m_objVaxUserAgent.DeselectAllAudioCodec();

            if (CheckG711U.Checked)
                m_objVaxUserAgent.SelectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_G711U);
            else
                m_objVaxUserAgent.DeselectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_G711U);

        
            if (CheckGSM610.Checked)
                m_objVaxUserAgent.SelectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_GSM610);
            else
                m_objVaxUserAgent.DeselectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_GSM610);

    
            if (CheckG711A.Checked)
                m_objVaxUserAgent.SelectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_G711A);
            else
                m_objVaxUserAgent.DeselectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_G711A);
	
    
            if (CheckG729.Checked)
                m_objVaxUserAgent.SelectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_G729);
            else
                m_objVaxUserAgent.DeselectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_G729);


            if (CheckiLBC.Checked)
                m_objVaxUserAgent.SelectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_ILBC);
            else
                m_objVaxUserAgent.DeselectAudioCodec(cVaxSIPUserAgentCOM.VAX_AUDIO_CODEC_ILBC);

        }
                                
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////

        private void ActivateOtherSettings()
        {
            m_objVaxUserAgent.AutoGainMic(CheckAGC.Checked, 8000);
            m_objVaxUserAgent.SetVolumeBoostMic(CheckMicBoost.Checked);
        }
                
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////
               
        private void ActivateDigitDTMF()
        {
            if (RadioForceNone.Checked)
            {
                m_objVaxUserAgent.ForceDigitDTMF(cVaxSIPUserAgentCOM.VAX_DTMF_TYPE_AUTO);
            }

            else if(RadioForceInbandDTMF.Checked)
            {
                //Enable Inband DTMF and VaxVoIP sends DTMF tones in the form of voice. Inband DTMF is not recommended
                //by IP-Telephony standards, because Inband DTMF only works if there is voice session with G711u or G711a codecs.

                m_objVaxUserAgent.ForceDigitDTMF(cVaxSIPUserAgentCOM.VAX_DTMF_TYPE_INBAND);
            }

            else if (RadioForceRfc2833DTMF.Checked)
            {
                m_objVaxUserAgent.ForceDigitDTMF(cVaxSIPUserAgentCOM.VAX_DTMF_TYPE_RFC2833);
            }

            else if (RadioForceInfoDTMF.Checked)
            {
                m_objVaxUserAgent.ForceDigitDTMF(cVaxSIPUserAgentCOM.VAX_DTMF_TYPE_SIP_INFO);
            }
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////

        private void ListAudioIn_SelectedIndexChanged(object sender, EventArgs e)
        {
            cMediaDevice objAudioDevice = (cMediaDevice)ListBoxAudioIn.Items[ListBoxAudioIn.SelectedIndex];
            m_objVaxUserAgent.SetActiveAudioInDevice(objAudioDevice.m_nDeviceId);
        }

        private void ListAudioOut_SelectedIndexChanged(object sender, EventArgs e)
        {
            cMediaDevice objAudioDevice = (cMediaDevice)ListBoxAudioOut.Items[ListBoxAudioOut.SelectedIndex];
            m_objVaxUserAgent.SetActiveAudioOutDevice(objAudioDevice.m_nDeviceId);
        }
                
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////

        private void CheckCodecGSM610_Click(object sender, EventArgs e)
        {
            ActivateAudioCodecs();
        }

        private void CheckCodeciLBC_Click(object sender, EventArgs e)
        {
            ActivateAudioCodecs();
        }

        private void CheckCodecG729_Click(object sender, EventArgs e)
        {
            ActivateAudioCodecs();
        }

        private void CheckCodecG711U_Click(object sender, EventArgs e)
        {
            ActivateAudioCodecs();
        }

        private void CheckCodecG711A_Click(object sender, EventArgs e)
        {
            ActivateAudioCodecs();
        }
                        
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////
                
        private void CheckAGC_Click(object sender, EventArgs e)
        {
            ActivateOtherSettings();
        }

        private void CheckMicBoost_Click(object sender, EventArgs e)
        {
            ActivateOtherSettings();
        }
                                
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////
        
        private void RadioForceNone_Click(object sender, EventArgs e)
        {
            ActivateDigitDTMF();
        }

        private void RadioForceInbandDTMF_Click(object sender, EventArgs e)
        {
            ActivateDigitDTMF();
        }

        private void RadioForceRfc2833DTMF_Click(object sender, EventArgs e)
        {
            ActivateDigitDTMF();
        }

        private void RadioForceInfoDTMF_Click(object sender, EventArgs e)
        {
            ActivateDigitDTMF();
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////

    public class cMediaDevice
    {
        public int m_nDeviceId;
        public String m_sDeviceName;

        public cMediaDevice(int nDeviceId, String sDeviceName)
        {
            m_nDeviceId = nDeviceId;
            m_sDeviceName = sDeviceName;
        }
        
        public override String ToString()
        {
            return m_sDeviceName;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
}
