﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace VaxVoIP
{
    public partial class MainPhoneForm : Form
    {
        private Boolean m_bActivateRingTone = false;
        
        private int SND_ASYNC = 0x0001;
        private int SND_NODEFAULT = 0x0002;
        private int SND_LOOP = 0x0008;
        private int SND_FILENAME = 0x00020000;

        [DllImport("winmm.dll")]

        public static extern bool PlaySound(string lpszName, int hModule, int dwFlags);

        public void OnVaxToneOnline()
        {
            m_objVaxUserAgent.BusyRingEnable();

            ActivateDialTone(CheckPlayDialTone.Checked);
            ActivateRingTone(CheckPlayRingTone.Checked);
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////////////

        public void OnRingToneStarted(String sCallId)
        {
            if (!m_bActivateRingTone) return;
            
            PlaySound("Ring.wav", 0, SND_ASYNC | SND_FILENAME | SND_LOOP | SND_NODEFAULT);
        }

        public void OnRingToneEnded(String sCallId)
        {
            if (!m_bActivateRingTone) return;
            
            PlaySound(null, 0, 0);
        }

        private void ActivateRingTone(Boolean bActivate)
        {
            m_bActivateRingTone = bActivate;
            
            if (!bActivate)
            {
                PlaySound(null, 0, 0);
            }
        }

        private void ActivateDialTone(Boolean bActivate)
        {
            if (bActivate)
            {
                m_objVaxUserAgent.DialRingEnable();
            }
            else
            {
                m_objVaxUserAgent.DialRingDisable();
            }
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////////////

        private void CheckPlayDialTone_Click(object sender, EventArgs e)
        {
            ActivateDialTone(CheckPlayDialTone.Checked);
        }

        private void CheckPlayRingTone_Click(object sender, EventArgs e)
        {
            ActivateRingTone(CheckPlayRingTone.Checked);
        }
    }
}
