﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace VaxVoIP
{
    public partial class MainPhoneForm : Form
    {
        private void BtnResetRecordingBuffer_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            m_objVaxUserAgent.ResetRecording(nLineNo);
        }
                
        private void BtnStartRecording_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            if (BtnStartRecording.Text == "Start")
            {
                if (EditRecordFileName.Text.Length == 0)
                {
                    MessageBox.Show("File name is not valid.", "VaxVoIP SDK", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return;
                }
                
                m_objVaxUserAgent.StartRecording(nLineNo, EditRecordFileName.Text, 2, 0);
                BtnStartRecording.Text = "Stop";
            }
            else
            {
                m_objVaxUserAgent.StopRecording(nLineNo);
                BtnStartRecording.Text = "Sart";
            }
        }
    }
}
