﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace VaxVoIP
{
    public partial class MainPhoneForm : Form
    {
        private void BtnDial_Click(object sender, EventArgs e)
        {
            int nLineNo = 0;

            if (BtnDial.Text == "Hangup")
            {
                nLineNo = ListBoxLines.SelectedIndex;
                m_objVaxUserAgent.DisconnectCall(nLineNo);

                BtnDial.Text = "Dial";
                BtnHold.Text = "Hold";

                return;
            }
            
            if (EditPhoneNo.Text == "")
            {
                MessageBox.Show("Please enter a phone number.", "VaxVoIP SDK");
                return;
            }

            nLineNo = FindLine();

            if (nLineNo == -1)
            {
                MessageBox.Show("No line is free");
                return;
            }

            AdjustSecureMediaSRTP(true);
            cStorePhoneNo.AddPhoneNo(EditPhoneNo.Text);

            if (!m_objVaxUserAgent.DialCall(nLineNo, "", "", EditPhoneNo.Text))
                return;

            BtnDial.Text = "Hangup";
        }

        private void BtnHold_Click(object sender, EventArgs e)
        {
            int nLineNo = ListBoxLines.SelectedIndex;

            if (BtnHold.Text == "UnHold")
            {
                m_objVaxUserAgent.UnHoldLine(nLineNo);
                BtnHold.Text = "Hold";

                return;
            }

            if (!m_objVaxUserAgent.HoldLine(nLineNo))
                return;

            BtnHold.Text = "UnHold";
        }
                
        public void OnConnectedCall(int nLineNo)
        {
            ShowListBoxLineStatus(nLineNo, "BUSY");
            AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Success to connect.");
        }

        public void OnHungupCall(int nLineNo)
        {
            BtnDial.Text = "Dial";
            BtnHold.Text = "Hold";
            
            AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Hung up.");
        }

        ///////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////
        
        public void OnDialCallStarted(int nLineNo, String sCallerName, String sCallerId, String sDialNo)
        {
            ShowListBoxLineStatus(nLineNo, "CONNECTING");
            AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Dialing.");
        }

        public void OnDialingCall(int nLineNo, int nStatusCode, String sReasonPhrase)
        {
            AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Response: " + sReasonPhrase);
        }

        public void OnDialCallFailed(int nLineNo, int nStatusCode, String sReasonPhrase, String sContact)
        {
            AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Response: " + sReasonPhrase);
        }

        ///////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////
               
        private void BtnDialPad1_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "1";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "1");
        }

        private void BtnDialPad2_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "2";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "2");
        }

        private void BtnDialPad3_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "3";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "3");
        }

        private void BtnDialPad4_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "4";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "4");
        }

        private void BtnDialPad5_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "5";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "5");
        }

        private void BtnDialPad6_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "6";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "6");
        }

        private void BtnDialPad7_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "7";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "7");
        }

        private void BtnDialPad8_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "8";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "8");
        }

        private void BtnDialPad9_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "9";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "9");
        }
                
        private void BtnDialPad0_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "0";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "0");
        }

        private void BtnDialPadStar_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "*";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "*");
        }

        private void BtnDialPadNo_Click(object sender, EventArgs e)
        {
            EditPhoneNo.Text += "#";
            m_objVaxUserAgent.DigitDTMF(ListBoxLines.SelectedIndex, "#");
        }
    }
}
