﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace VaxVoIP
{
    public partial class MainPhoneForm : Form
    {
        private PhoneIncomingCallForm m_objAlertForm = null;
        private const int PHONE_TAB_PAGE_INDEX = 1;

        public void OnVaxIncomingCallOffline()
        {
            ListBoxIncomingCall.Items.Clear();
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////////////

        private String GenCallerInfo(String sCallerName, String sCallerId)
        {       
	        String sCallerInfo;
	
	        if(sCallerName.Length != 0)
		        sCallerInfo = String.Format("NAME: {0}, CLI: {1}", sCallerName, sCallerId);
	        else
                sCallerInfo = String.Format("NAME: Unknown, CLI: {0}", sCallerId);
                        
	        return sCallerInfo;
        }

        public void OnIncomingCallStarted(String sCallId, String sCallerName, String sCallerId)
        {
            Boolean bResult = FindCallId(sCallId);
            if (bResult) return;

            String sCallerInfo = GenCallerInfo(sCallerName, sCallerId);

            ListBoxIncomingCall.Items.Add(new cListIncomingCall(sCallId, sCallerInfo));

            if ((ListBoxIncomingCall.SelectedIndex == -1) && (ListBoxIncomingCall.Items.Count > 0))
                ListBoxIncomingCall.SelectedIndex = 0;

            ShowIncomingCallMsgBox(true);
        }

        public void OnIncomingCallEnded(String sCallId)
        {
            ShowIncomingCallMsgBox(false);
            RemoveCallIdFromList(sCallId);
        }

        private void ShowIncomingCallMsgBox(Boolean bShow)
        {
            if (bShow)
            {
                int nTabIndex = MainForm.m_objMainForm.GetActiveTab();
                if (nTabIndex == PHONE_TAB_PAGE_INDEX || m_objAlertForm != null) return;

                m_objAlertForm = new PhoneIncomingCallForm(this);
                m_objAlertForm.Show();

                return;
            }

            if (m_objAlertForm == null) return;

            m_objAlertForm.Close();
            m_objAlertForm = null;
        }
                
        //////////////////////////////////////////////////////////////////////////////////////////////////////////
        //////////////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnAccept_Click(object sender, EventArgs e)
        {
            int nSelectedItemIndex = ListBoxIncomingCall.SelectedIndex;
            if (nSelectedItemIndex == -1) return;

            cListIncomingCall objListIncomingCall = (cListIncomingCall) ListBoxIncomingCall.Items[nSelectedItemIndex];
            String sCallId = objListIncomingCall.m_sCallId;

            int nLineNo = FindLine();

            if (nLineNo == -1)
            {
                MessageBox.Show("No line is free");
                return;
            }
                        
            AdjustSecureMediaSRTP(false);

            Boolean bResult = m_objVaxUserAgent.AcceptCall(nLineNo, sCallId);
            if (!bResult) return;

            ListBoxIncomingCall.Items.Remove(objListIncomingCall);

            ShowListBoxLineStatus(nLineNo, "CONNECTING");

            if (ListBoxIncomingCall.Items.Count > 0)
            {
                if (ListBoxIncomingCall.SelectedIndex == -1)
                    ListBoxIncomingCall.SelectedIndex = 0;

                return;
            }
        }

        private void BtnReject_Click(object sender, EventArgs e)
        {
            int nSelectedItemIndex = ListBoxIncomingCall.SelectedIndex;
            if (nSelectedItemIndex == -1) return;

            cListIncomingCall objListIncomingCall = (cListIncomingCall)ListBoxIncomingCall.Items[nSelectedItemIndex];

            String sCallId = objListIncomingCall.m_sCallId;
            
            Boolean bResult = m_objVaxUserAgent.RejectCall(sCallId);
            if (!bResult) return;

            ListBoxIncomingCall.Items.Remove(objListIncomingCall);

            if (ListBoxIncomingCall.Items.Count > 0)
            {
                if (ListBoxIncomingCall.SelectedIndex == -1)
                    ListBoxIncomingCall.SelectedIndex = 0;

                return;
            }
        }
                
        private Boolean FindCallId(String sCallId)
        {
            cListIncomingCall objListIncomingCall;

            for (int nListIndex = 0; nListIndex < ListBoxIncomingCall.Items.Count; nListIndex++)
            {
                objListIncomingCall = (cListIncomingCall)ListBoxIncomingCall.Items[nListIndex];

                if (sCallId == objListIncomingCall.m_sCallId)
                    return true;
            }

            return false;
        }

        private void RemoveCallIdFromList(String sCallId)
        {
            cListIncomingCall objListIncomingCall;

            for (int nListIndex = 0; nListIndex < ListBoxIncomingCall.Items.Count; nListIndex++)
            {
                objListIncomingCall = (cListIncomingCall)ListBoxIncomingCall.Items[nListIndex];

                if (sCallId == objListIncomingCall.m_sCallId)
                {
                    ListBoxIncomingCall.Items.Remove(objListIncomingCall);
                    objListIncomingCall = null;
                    return;
                }
            }
        }

        public void OkAlert()
        {
            MainForm.m_objMainForm.SetActiveTab(PHONE_TAB_PAGE_INDEX);

            m_objAlertForm.Close();
            m_objAlertForm = null;
        }

        public void CancelAlert()
        {
            m_objAlertForm.Close();
            m_objAlertForm = null;
        }
    }

    class cListIncomingCall
    {
        public String m_sCallId;
        public String m_sCallerInfo;

        public cListIncomingCall(String sCallId, String sCallerInfo)
        {
            m_sCallId = sCallId;
            m_sCallerInfo = sCallerInfo;
        }

        public override String ToString()
        {
            return m_sCallerInfo;
        }
    }
}
