﻿using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace VaxVoIP
{
    public partial class MainPhoneForm : Form
    {
        private cVaxSIPUserAgentExCOM m_objVaxUserAgent;
                
        public MainPhoneForm(ref cVaxSIPUserAgentExCOM objVaxUserAgent)
        {
            InitializeComponent();
            m_objVaxUserAgent = objVaxUserAgent;  
        }

        private void PhoneForm_Load(object sender, EventArgs e)
        {
            LoadPhoneNo();
                        
            ComboDialCallSecureMediaSRTP.Items.Add("Secure Media None");
            ComboDialCallSecureMediaSRTP.Items.Add("Secure Media Forced");
            ComboDialCallSecureMediaSRTP.SelectedIndex = 0;
                       
            ComboAcceptCallSecureMediaSRTP.Items.Add("Secure Media Auto");
            ComboAcceptCallSecureMediaSRTP.Items.Add("Secure Media None");
            ComboAcceptCallSecureMediaSRTP.Items.Add("Secure Media Forced");
            ComboAcceptCallSecureMediaSRTP.SelectedIndex = 0;
            
            ComboVoiceChanger.Items.Add("Disable");
            ComboVoiceChanger.Items.Add("Grandpa drunk");
            ComboVoiceChanger.Items.Add("Teen boy");
            ComboVoiceChanger.Items.Add("Household robot");
            ComboVoiceChanger.Items.Add("Helium inhaled");
            ComboVoiceChanger.Items.Add("Chipmunk");
            ComboVoiceChanger.SelectedIndex = 0;
        }

        public void OnVaxOnline()
        {
            OnVaxForwardCallOnline();
                        
            OnVaxVoiceOnline();
            OnVaxLineOnline();

            OnVaxToneOnline();
        }

        public void OnVaxOffline()
        {
            ListBoxStatusLog.Items.Clear();
            
            OnVaxIncomingCallOffline();

            OnVaxVoiceOffline();
            OnVaxLineOffline();
        }

        private void AddToStatusLog(String sStatusLog)
        {
            ListBoxStatusLog.Items.Add(sStatusLog);
            ListBoxStatusLog.TopIndex = ListBoxStatusLog.Items.Count - 1;
        }

        private void BtnClearLog_Click(object sender, EventArgs e)
        {
            ListBoxStatusLog.Items.Clear();
        } 
        
        ////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////

        public void OnDigitDTMF(int nLineNo, String sDigit)
        {
            AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Key-pressed: " + sDigit);
        }
        
        public void OnDetectedAMD(int nLineNo, Boolean bIsHuman)
        {
            if (!bIsHuman)
                AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Answering Machine [Yes]");
            else
                AddToStatusLog("Line-" + Convert.ToString(nLineNo + 1) + ": Answering Machine [No]");        
        }

        public void OnNetworkReachability(bool bAvailable)
        {
            if (bAvailable)
                AddToStatusLog("Network is available");
            else
                AddToStatusLog("Network is not available");
        }

        private void LoadPhoneNo()
        {
            String sPhoneNo = "";
            cStorePhoneNo.GetPhoneNo(ref sPhoneNo);

            EditPhoneNo.Text = sPhoneNo;
        }

        private void AdjustSecureMediaSRTP(Boolean bDialCall)
        {
            int nSecureIndex = -1;

            if (bDialCall)
            {
                nSecureIndex = ComboDialCallSecureMediaSRTP.SelectedIndex;

                if (nSecureIndex == -1 || nSecureIndex == 0)
                {
                    m_objVaxUserAgent.CryptoMediaNONE(false);
                    return;
                }

                if (nSecureIndex == 1)
                {
                    m_objVaxUserAgent.CryptoMediaSDP(true);
                    return;
                }
                                
                return;
            }

            nSecureIndex = ComboAcceptCallSecureMediaSRTP.SelectedIndex;

            if (nSecureIndex == -1 || nSecureIndex == 0)
            {
                m_objVaxUserAgent.CryptoMediaNONE(false);
                return;
            }

            if (nSecureIndex == 1)
            {
                m_objVaxUserAgent.CryptoMediaNONE(true);
                return;
            }

            if (nSecureIndex == 2)
            {
                m_objVaxUserAgent.CryptoMediaSDP(true);
                return;
            }
        }

        private void UpdateBtnStatus()
        {
            int nLineNo = ListBoxLines.SelectedIndex;
                        
            if (!m_objVaxUserAgent.IsLineRecording(nLineNo) && BtnStartRecording.Text != "Start")
                BtnStartRecording.Text = "Start";

            else if (m_objVaxUserAgent.IsLineRecording(nLineNo) && BtnStartRecording.Text != "Stop")
                BtnStartRecording.Text = "Stop";


            if (!m_objVaxUserAgent.IsLineBusy(nLineNo) && BtnDial.Text != "Dial")
                BtnDial.Text = "Dial";

            else if (m_objVaxUserAgent.IsLineBusy(nLineNo) && BtnDial.Text != "Hangup")
                BtnDial.Text = "Hangup";


            if (!m_objVaxUserAgent.IsLineHold(nLineNo) && BtnHold.Text != "Hold")
                BtnHold.Text = "Hold";

            else if (m_objVaxUserAgent.IsLineHold(nLineNo) && BtnHold.Text != "UnHold")
                BtnHold.Text = "UnHold";
        }

        private void CheckDetectAMD_Click(object sender, EventArgs e)
        {
            m_objVaxUserAgent.DetectAMD(CheckDetectAMD.Checked);
        }

        private void ComboVoiceChanger_SelectionChangeCommitted(object sender, EventArgs e)
        {
            int nVoiceChangerType = ComboVoiceChanger.SelectedIndex;
            if (nVoiceChangerType == -1) return;

            switch (nVoiceChangerType)
            {
                case 0:
                    m_objVaxUserAgent.VoiceChanger(-1);
                    break;

                case 1:
                    m_objVaxUserAgent.VoiceChanger(4);
                    break;

                case 2:
                    m_objVaxUserAgent.VoiceChanger(8);
                    break;

                case 3:
                    m_objVaxUserAgent.VoiceChanger(12);
                    break;

                case 4:
                    m_objVaxUserAgent.VoiceChanger(16);
                    break;

                case 5:
                    m_objVaxUserAgent.VoiceChanger(20);
                    break;
            }
        }

        private void CheckDisturb_Click(object sender, EventArgs e)
        {
            m_objVaxUserAgent.DonotDisturb(CheckDisturb.Checked);
        }

        
    }
}
