﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace VaxVoIP
{
    public partial class MainChatForm : Form
    {
        List<String> m_objContactNameList = new List<String>();
        
        private cVaxSIPUserAgentExCOM m_objVaxUserAgent;
        private Boolean m_bTyping = false;

        public MainChatForm(ref cVaxSIPUserAgentExCOM objVaxUserAgent)
        {
            InitializeComponent();
            m_objVaxUserAgent = objVaxUserAgent;
        }

        private void ChatForm_Load(object sender, EventArgs e)
        {
            LabelChatTyping.Text = "";
            UpdateStatusCombo();
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        public void LoadContactAll()
        {
            m_objContactNameList.Clear();
            ListBoxContacts.Items.Clear();

            ArrayList objList = new ArrayList();
            cStoreChat.GetContactAll(ref objList);

            for (int nCount = 0; nCount < objList.Count; nCount++)
            {
                String sContactName = (String)objList[nCount];
                
                ListBoxContacts.Items.Add(sContactName);
                m_objContactNameList.Add(sContactName);

                m_objVaxUserAgent.ChatAddContact(sContactName);
            }

            if (ListBoxContacts.SelectedIndex == -1 && ListBoxContacts.Items.Count != 0)
            {
                ListBoxContacts.SelectedIndex = 0;
                LoadContactMsgAll((String)objList[0]);
            }
        }
                
        public void OnVaxOnline()
        {
            LabelChatTyping.Text = "";
            m_bTyping = false;

            LoadContactAll();
        }

        public void OnVaxOffline()
        {
            TimerMsgTyping.Stop();
            ListBoxStatusLog.Items.Clear();

            m_objContactNameList.Clear();
            ListBoxContacts.Items.Clear();
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void UpdateStatusCombo()
        {
            ComboMyChatStatus.Items.Clear();

            ComboMyChatStatus.Items.Add("Online");
            ComboMyChatStatus.Items.Add("Offline");
            ComboMyChatStatus.Items.Add("Away");
            ComboMyChatStatus.Items.Add("On the phone");
            ComboMyChatStatus.Items.Add("Busy");

            ComboMyChatStatus.SelectedIndex = cVaxSIPUserAgentCOM.VAX_CONTACT_STATUS_OFFLINE;
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnAddContact_Click(object sender, EventArgs e)
        {
            if (EditContactName.Text.Length == 0)
                return;

            if (!m_objVaxUserAgent.ChatAddContact(EditContactName.Text))
                return;

            ListBoxContacts.Items.Add(EditContactName.Text);
            m_objContactNameList.Add(EditContactName.Text);

            cStoreChat.AddContact(EditContactName.Text);

            if (ListBoxContacts.SelectedIndex == -1 && ListBoxContacts.Items.Count != 0)
                ListBoxContacts.SelectedIndex = 0;

            EditContactName.Text = "";
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnRemoveContact_Click(object sender, EventArgs e)
        {
            int nSelectedIndex = ListBoxContacts.SelectedIndex;

            if (nSelectedIndex == -1)
                return;

            DialogResult Result = MessageBox.Show("Do you really want to remove this Contact?", "Caution", MessageBoxButtons.YesNo, MessageBoxIcon.Question);

            if (Result == DialogResult.No)
                return;

            String sContactName = m_objContactNameList[nSelectedIndex];

            m_objVaxUserAgent.ChatRemoveContact(sContactName);

            ListBoxContacts.Items.RemoveAt(nSelectedIndex);
            m_objContactNameList.RemoveAt(nSelectedIndex);
            cStoreChat.RemoveContact(sContactName);

            if (ListBoxContacts.SelectedIndex == -1 && ListBoxContacts.Items.Count != 0)
                ListBoxContacts.SelectedIndex = 0;
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void ListBoxContacts_Click(object sender, EventArgs e)
        {
            int nSelectedIndex = ListBoxContacts.SelectedIndex;

            if (nSelectedIndex == -1)
                return;

            ListBoxMessages.Items.Clear();
            LoadContactMsgAll(m_objContactNameList[nSelectedIndex]);
        }

        public void LoadContactMsgAll(String sContactName)
        {
            ListBoxMessages.Items.Clear();

            ArrayList objList = new ArrayList();
            cStoreChat.GetMsgAll(sContactName, ref objList);

            for (int nCount = 0; nCount < objList.Count; nCount++)
            {
                String sMsg = (String)objList[nCount];
                ListBoxMessages.Items.Add(sMsg);
            }
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void ComboMyChatStatus_SelectionChangeCommitted(object sender, EventArgs e)
        {
            int nSelectedIndex = ComboMyChatStatus.SelectedIndex;
            if (nSelectedIndex == -1) return;

            m_objVaxUserAgent.ChatSetMyStatus(nSelectedIndex);
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnSendMessage_Click(object sender, EventArgs e)
        {
            if (ListBoxContacts.SelectedIndex == -1)
                return;

            if (EditSendMessage.Text.Length == 0)
                return;

            String sContactName = m_objContactNameList[ListBoxContacts.SelectedIndex];

            if (!m_objVaxUserAgent.ChatSendMessageText(sContactName, EditSendMessage.Text))
                return;

            String sMsg = "Me: " + EditSendMessage.Text;

            ListBoxMessages.Items.Add(sMsg);
            cStoreChat.AddMsg(sContactName, sMsg);

            EditSendMessage.Text = "";
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        public void OnChatSendMsgTextSuccess(String sUserName, String sMsgText, long nUserValue)
        {
            AddToStatusLog("Send Message to " + sUserName + " Success.");
        }

        public void OnChatSendMsgTextFailed(String sUserName, int nStatusCode, String sReasonPhrase, String sMsgText, long nUserValue)
        {
            AddToStatusLog("Send Message to " + sUserName + " Failed.");
        }

        private void AddToStatusLog(String sLog)
        {
            ListBoxStatusLog.Items.Add(sLog);
            ListBoxStatusLog.TopIndex = ListBoxStatusLog.Items.Count - 1;
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnClearMessage_Click(object sender, EventArgs e)
        {
            if (ListBoxContacts.SelectedIndex == -1)
                return;

            ListBoxMessages.Items.Clear();

            String sContactName = m_objContactNameList[ListBoxContacts.SelectedIndex];
            cStoreChat.RemoveMsgAll(sContactName);
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private String GetStatusText(int nStatusId)
        {
            String sStatus = "";

            switch (nStatusId)
            {
                case cVaxSIPUserAgentCOM.VAX_CONTACT_STATUS_ONLINE:
                    sStatus = "Online";
                    break;

                case cVaxSIPUserAgentCOM.VAX_CONTACT_STATUS_OFFLINE:
                    sStatus = "Offline";
                    break;

                case cVaxSIPUserAgentCOM.VAX_CONTACT_STATUS_AWAY:
                    sStatus = "Away";
                    break;

                case cVaxSIPUserAgentCOM.VAX_CONTACT_STATUS_ON_PHONE:
                    sStatus = "On the phone";
                    break;

                case cVaxSIPUserAgentCOM.VAX_CONTACT_STATUS_BUSY:
                    sStatus = "Busy";
                    break;

                case cVaxSIPUserAgentCOM.VAX_CONTACT_STATUS_UNKNOWN:
                    sStatus = "Offline";
                    break;
            }

            return sStatus;
        }

        /////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////

        public void OnChatSubscribeSuccess(String sUserName)
        {
            AddToStatusLog("Chat Subscribe " + sUserName + " Success.");
        }

        public void OnChatSubscribeFailed(String sUserName, int nStatusCode, String sReasonPhrase)
        {
            AddToStatusLog("Chat Subscribe " + sUserName + " Failed.");
        }

        /////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////

        public void OnChatContactStatus(String sUserName, int nStatusId)
        {
            for (int nContactCount = 0; nContactCount < m_objContactNameList.Count; nContactCount++)
            {
                String sContactName = m_objContactNameList[nContactCount];
                sContactName = sContactName.ToUpper();

                if (sContactName == sUserName.ToUpper())
                {
                    String sStatus = sUserName + " [" + GetStatusText(nStatusId) + "]";
                    ListBoxContacts.Items[nContactCount] = sStatus;

                    break;
                }
            }
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        public void OnChatRecvMsgText(string sUserName, string sMsgText, bool bIsContact)
        {
            int nStart = sMsgText.IndexOf(">");

            String sMessage = "";

            if (nStart == -1)
            {
                sMessage = sUserName + ": " + sMsgText;
            }
            else
            {
                // Remote softphone is sending HTML based text messages

                nStart = nStart + 1;
                int nEnd = sMsgText.IndexOf("<", nStart);

                sMessage = sUserName + ": " + sMsgText.Substring(nStart, nEnd - nStart);
            }

            ListBoxMessages.Items.Add(sMessage);
            ListBoxMessages.TopIndex = ListBoxMessages.Items.Count - 1;

            cStoreChat.AddMsg(sUserName, sMessage);
        }

        ///////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////

        public void OnChatRecvMsgTypingStart(String sUserName)
        {
            m_bTyping = true;
            LabelChatTyping.Text = sUserName + ": Typing";

            TimerMsgTyping.Stop();
            TimerMsgTyping.Start();

            AdjustTypingState();
        }

        private void OnTypingTimer(object sender, EventArgs e)
        {
            AdjustTypingState();
        }

        private void AdjustTypingState()
        {
            if (!m_bTyping)
            {
                TimerMsgTyping.Stop();
                OnChatRecvMsgTypingStop();
            }
            else
            {
                m_bTyping = false;
            }
        }

        public void OnChatRecvMsgTypingStop()
        {
            LabelChatTyping.Text = "";
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void EditSendMessage_KeyDown(object sender, KeyEventArgs e)
        {
            if (ListBoxContacts.SelectedIndex == -1)
                return;
                        
            String sContactName = m_objContactNameList[ListBoxContacts.SelectedIndex];
            m_objVaxUserAgent.ChatSendMessageTyping(sContactName);
        }

        public void OnChatSendMsgTypingSuccess(String sUserName, long nUserValue)
        {
            AddToStatusLog("Send Typing to " + sUserName + " Success.");
        }

        public void OnChatSendMsgTypingFailed(String sUserName, int nStatusCode, String sReasonPhrase, long nUserValue)
        {
            AddToStatusLog("Send Typing to " + sUserName + " Failed.");
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnClearStatusLog_Click(object sender, EventArgs e)
        {
            ListBoxStatusLog.Items.Clear();
        }
    }
}