﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace VaxVoIP
{
    public partial class MainBusyLampForm : Form
    {
        List<String> m_objContactNameList = new List<String>();
        private cVaxSIPUserAgentExCOM m_objVaxUserAgent;

        public MainBusyLampForm(ref cVaxSIPUserAgentExCOM objVaxUserAgent)
        {
            InitializeComponent();
            m_objVaxUserAgent = objVaxUserAgent;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        public void LoadContactAll()
        {
            m_objContactNameList.Clear();
            ListBoxContacts.Items.Clear();

            ArrayList objList = new ArrayList();
            cStoreBusyLamp.GetContactAll(ref objList);

            for (int nCount = 0; nCount < objList.Count; nCount++)
            {
                String sContactName = (String)objList[nCount];

                ListBoxContacts.Items.Add(sContactName);
                m_objContactNameList.Add(sContactName);

                m_objVaxUserAgent.BusyLampAddContact(sContactName);
            }

            if (ListBoxContacts.SelectedIndex == -1 && ListBoxContacts.Items.Count != 0)
            {
                ListBoxContacts.SelectedIndex = 0;
            }
        }
                
        public void OnVaxOnline()
        {
            LoadContactAll();
        }

        public void OnVaxOffline()
        {
            ListBoxStatusLog.Items.Clear();

            m_objContactNameList.Clear();
            ListBoxContacts.Items.Clear();
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnAddContact_Click(object sender, EventArgs e)
        {
            if (EditContactName.Text.Length == 0)
                return;

            if (!m_objVaxUserAgent.BusyLampAddContact(EditContactName.Text))
                return;

            ListBoxContacts.Items.Add(EditContactName.Text);
            m_objContactNameList.Add(EditContactName.Text);
            cStoreBusyLamp.AddContact(EditContactName.Text);

            if (ListBoxContacts.SelectedIndex == -1 && ListBoxContacts.Items.Count != 0)
                ListBoxContacts.SelectedIndex = 0;

            EditContactName.Text = "";
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnRemoveContact_Click(object sender, EventArgs e)
        {
            int nSelectedIndex = ListBoxContacts.SelectedIndex;

            if (nSelectedIndex == -1)
                return;

            DialogResult Result = MessageBox.Show("Do you really want to remove this Contact?", "Caution", MessageBoxButtons.YesNo, MessageBoxIcon.Question);

            if (Result == DialogResult.No)
                return;

            String sContactName = m_objContactNameList[nSelectedIndex];

            m_objVaxUserAgent.BusyLampRemoveContact(sContactName);

            ListBoxContacts.Items.RemoveAt(nSelectedIndex);
            m_objContactNameList.RemoveAt(nSelectedIndex);
            cStoreBusyLamp.RemoveContact(sContactName);

            if (ListBoxContacts.SelectedIndex == -1 && ListBoxContacts.Items.Count != 0)
                ListBoxContacts.SelectedIndex = 0;
        }
                
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////
                
        private void AddToStatusLog(String sLog)
        {
            ListBoxStatusLog.Items.Add(sLog);
            ListBoxStatusLog.TopIndex = ListBoxStatusLog.Items.Count - 1;
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private string GetStatusText(int nStatusId)
        {
            string sStatus = "";

            switch (nStatusId)
            {
                case cVaxSIPUserAgentCOM.VAX_BUSY_LAMP_STATUS_FREE:
                    sStatus = "Free";
                    break;

                case cVaxSIPUserAgentCOM.VAX_BUSY_LAMP_STATUS_OFFLINE:
                    sStatus = "Offline";
                    break;

                case cVaxSIPUserAgentCOM.VAX_BUSY_LAMP_STATUS_BUSY:
                    sStatus = "Busy";
                    break;
                                    
                case cVaxSIPUserAgentCOM.VAX_BUSY_LAMP_STATUS_UNKNOWN:
                    sStatus = "UnKnown";
                    break;

                case cVaxSIPUserAgentCOM.VAX_BUSY_LAMP_STATUS_CONNECTING:
                    sStatus = "Busy";
                    break;
            }

            return sStatus;
        }

        /////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////
        
        public void OnBusyLampContactStatus(String sUserName, int nStatusId)
        {
            for (int nContactCount = 0; nContactCount < m_objContactNameList.Count; nContactCount++)
            {
                String sContactName = m_objContactNameList[nContactCount];
                sContactName = sContactName.ToUpper();

                if (sContactName == sUserName.ToUpper())
                {
                    String sStatus = sUserName + " [" + GetStatusText(nStatusId) + "]";
                    ListBoxContacts.Items[nContactCount] = sStatus;

                    break;
                }
            }
        }

        public void OnBusyLampSubscribeSuccess(String sUserName)
        {
            AddToStatusLog("BusyLamp Subscribe " + sUserName + " Success.");
        }

        public void OnBusyLampSubscribeFailed(String sUserName, int nStatusCode, String sReasonPhrase)
        {
            AddToStatusLog("BusyLamp Subscribe " + sUserName + " Failed.");
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////

        private void BtnClearChatLog_Click(object sender, EventArgs e)
        {
            ListBoxStatusLog.Items.Clear();
        }
    }
}