#pragma once
#include "afxwin.h"
#include "DrawFrame.h"

// CMainVideoDlg dialog

class CVaxSIPUserAgentLibEx;

class CMainVideoDlg : public CPropertyPage
{
	DECLARE_DYNAMIC(CMainVideoDlg)

public:

	CMainVideoDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent);
	virtual ~CMainVideoDlg();

// Dialog Data
	enum { IDD = IDD_VIDEO_DLG };

protected:

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()

private:
	
	HWND m_hWndPreview;
	CDrawFrame m_objDrawFramePreview;
	
	
	HWND m_hWndScreen[5];
	CDrawFrame m_objScreens[5];

public:

	CFont m_objFont;

	CVaxSIPUserAgentLibEx* m_pVaxUserAgentSIP;
	BOOL m_bCheckPreview;

public:

	void OnVaxOnline();
	void OnVaxOffline();

	void OnVideoRemoteStarted(int nLineNo);
	void OnVideoRemoteEnded(int nLineNo);

	void OnVideoDeviceFrameRGB(int nDeviceId, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight);
	void OnVideoRemoteFrameRGB(int nLineNo, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight);
	
	virtual BOOL OnInitDialog();
	afx_msg void OnBnClickedCheckVideoPreviewActivate();


	
};
