// VideoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Define.h"
#include "VaxVoIP.h"
#include "MainVideoDlg.h"
#include "afxdialogex.h"
#include "DrawFrame.h"
#include "VaxSIPUserAgentLibEx.h"

// CMainVideoDlg dialog

IMPLEMENT_DYNAMIC(CMainVideoDlg, CPropertyPage)

CMainVideoDlg::CMainVideoDlg(CVaxSIPUserAgentLibEx* pVaxSIPUserAgent) : CPropertyPage(CMainVideoDlg::IDD)
{
	m_pVaxUserAgentSIP = pVaxSIPUserAgent;
	
	m_objFont.CreateFont(14, 0, 0, 0, FW_BOLD, FALSE, FALSE, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_SWISS, "Verdana");
	m_bCheckPreview = TRUE;
}

CMainVideoDlg::~CMainVideoDlg()
{
	m_objDrawFramePreview.CloseDevice();
	
	m_objScreens[0].CloseDevice();
	m_objScreens[1].CloseDevice();
	m_objScreens[2].CloseDevice();
	m_objScreens[3].CloseDevice();
	m_objScreens[4].CloseDevice();
}

void CMainVideoDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	GetDlgItem(IDC_STATIC_PREVIEW)->SetFont(&m_objFont);
	GetDlgItem(IDC_STATIC_SCREEN1)->SetFont(&m_objFont);
	GetDlgItem(IDC_STATIC_SCREEN2)->SetFont(&m_objFont);
	GetDlgItem(IDC_STATIC_SCREEN3)->SetFont(&m_objFont);
	GetDlgItem(IDC_STATIC_SCREEN4)->SetFont(&m_objFont);
	GetDlgItem(IDC_STATIC_SCREEN5)->SetFont(&m_objFont);

	DDX_Check(pDX, IDC_CHECK_VIDEO_PREVIEW_ACTIVATE, m_bCheckPreview);
}


BEGIN_MESSAGE_MAP(CMainVideoDlg, CPropertyPage)
	ON_BN_CLICKED(IDC_CHECK_VIDEO_PREVIEW_ACTIVATE, &CMainVideoDlg::OnBnClickedCheckVideoPreviewActivate)
END_MESSAGE_MAP()

// CMainVideoDlg message handlers


BOOL CMainVideoDlg::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	
	/////////////////////////////////////////////////////////////////////////

	CWnd* pScreenWnd = GetDlgItem(IDC_SCREEN1);
	m_hWndScreen[0] = pScreenWnd->m_hWnd;
	
	pScreenWnd = GetDlgItem(IDC_SCREEN2);
	m_hWndScreen[1] = pScreenWnd->m_hWnd;

	pScreenWnd = GetDlgItem(IDC_SCREEN3);
	m_hWndScreen[2] = pScreenWnd->m_hWnd;

	pScreenWnd = GetDlgItem(IDC_SCREEN4);
	m_hWndScreen[3] = pScreenWnd->m_hWnd;

	pScreenWnd = GetDlgItem(IDC_SCREEN5);
	m_hWndScreen[4] = pScreenWnd->m_hWnd;
	
	/////////////////////////////////////////////////////////////////////////
	
	pScreenWnd = GetDlgItem(IDC_VIDEO_PREVIEW);
	m_hWndPreview = pScreenWnd->m_hWnd;

	m_objDrawFramePreview.OpenDevice(m_hWndPreview);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

void CMainVideoDlg::OnVaxOnline()
{
	UpdateData(TRUE);
	m_pVaxUserAgentSIP->ActivateVideoDevice(m_bCheckPreview);
}

void CMainVideoDlg::OnVaxOffline()
{
	m_pVaxUserAgentSIP->CloseVideoDev();
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

void CMainVideoDlg::OnVideoDeviceFrameRGB(int nDeviceId, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
{
	m_objDrawFramePreview.ShowFrameRGB(pFrameRGB, nFrameWidth, nFrameHeight);
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

void CMainVideoDlg::OnVideoRemoteStarted(int nLineNo)
{
	m_objScreens[nLineNo].OpenDevice(m_hWndScreen[nLineNo]);
}

void CMainVideoDlg::OnVideoRemoteEnded(int nLineNo)
{
	m_objScreens[nLineNo].CloseDevice();
}

void CMainVideoDlg::OnVideoRemoteFrameRGB(int nLineNo, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight)
{
	m_objScreens[nLineNo].ShowFrameRGB(pFrameRGB, nFrameWidth, nFrameHeight);
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

void CMainVideoDlg::OnBnClickedCheckVideoPreviewActivate()
{
	UpdateData(TRUE);

	m_pVaxUserAgentSIP->ActivateVideoDevice(m_bCheckPreview);
}
