#include "D3D9.h"

#pragma once

class CDrawFrame
{

public:

	CDrawFrame(void);
	~CDrawFrame(void);

private:

	IDirect3D9* m_pD3D;
	IDirect3DDevice9* m_pDevice;
	IDirect3DSwapChain9* m_pSwapChain;

	RECT m_rcDest;

	int m_nSwapChainWidth;
	int m_nSwapChainHeight;

	HWND m_hWnd;

private:

	void DestroySwapChain();
	
	BOOL CreateDevice();
	BOOL CreateSwapChains(int nWidth, int nHeight);

public:

	BOOL OpenDevice(HWND hWnd);
	void CloseDevice();

	BOOL ShowFrameRGB(BYTE* pFrameRGB, int nWidth, int nHeight);

};

