#include "StdAfx.h"
#include "DrawFrame.h"
#include "D3D9.h"

CDrawFrame::CDrawFrame(void)
{
	m_pDevice = NULL;
	m_pSwapChain = NULL;
	m_pD3D = NULL;

	m_nSwapChainWidth = 0;
	m_nSwapChainHeight = 0;

	m_hWnd = NULL;
}

CDrawFrame::~CDrawFrame(void)
{
	CloseDevice();
}

BOOL CDrawFrame::OpenDevice(HWND hwnd)
{
	CloseDevice();
	
	m_pD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if(m_pD3D == NULL) return FALSE;

	HRESULT hResult = S_OK;
    D3DPRESENT_PARAMETERS pp = { 0 };
    D3DDISPLAYMODE mode = { 0 };

    hResult = m_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &mode);
	
	if(hResult != S_OK) 
	{
		CloseDevice();
		return FALSE;
	}

	hResult = m_pD3D->CheckDeviceType(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, mode.Format, D3DFMT_X8R8G8B8, TRUE);
	
	if(hResult != S_OK) 
	{
		CloseDevice();
		return FALSE;
	}

	pp.BackBufferFormat = D3DFMT_X8R8G8B8;
    pp.SwapEffect = D3DSWAPEFFECT_COPY;
    pp.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
    pp.Windowed = TRUE;
    pp.hDeviceWindow = hwnd;

	hResult = m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hwnd, D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_FPU_PRESERVE, &pp, &m_pDevice);

	if(hResult != S_OK)
	{
		hResult = m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hwnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_FPU_PRESERVE, &pp, &m_pDevice);
		
		if(hResult != S_OK) 
		{
			CloseDevice();
			return FALSE;
		}
	}

	m_hWnd = hwnd;
	return TRUE;
}

BOOL CDrawFrame::CreateSwapChains(int nWidth, int nHeight)
{
	if(m_pDevice == NULL)
		return FALSE;
	
	DestroySwapChain();
	    
    D3DPRESENT_PARAMETERS pp = { 0 };

    pp.BackBufferWidth  = nWidth;
    pp.BackBufferHeight = nHeight;
    pp.Windowed = TRUE;
    pp.SwapEffect = D3DSWAPEFFECT_FLIP;
    pp.hDeviceWindow = m_hWnd;
    pp.BackBufferFormat = D3DFMT_X8R8G8B8;
    pp.Flags = D3DPRESENTFLAG_VIDEO | D3DPRESENTFLAG_DEVICECLIP | D3DPRESENTFLAG_LOCKABLE_BACKBUFFER;
    pp.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
    pp.BackBufferCount = D3DPRESENT_BACK_BUFFERS_MAX;

    HRESULT hResult = m_pDevice->CreateAdditionalSwapChain(&pp, &m_pSwapChain);

	if(hResult != S_OK) 
	{
		DestroySwapChain();
		return FALSE;
	}
		
    return TRUE;
}

BOOL CDrawFrame::ShowFrameRGB(BYTE* pFrameRGB, int nWidth, int nHeight)
{
	if(m_pDevice == NULL)
		return FALSE;
    
	HRESULT hResult = S_OK;

	D3DLOCKED_RECT lr;
	IDirect3DSurface9 *pSurf = NULL;
    IDirect3DSurface9 *pBB = NULL;

	if(m_nSwapChainWidth != nWidth || m_nSwapChainHeight != nHeight)
	{
		if(!CreateSwapChains(nWidth, nHeight))
			return FALSE;

		m_nSwapChainWidth = nWidth;
		m_nSwapChainHeight = nHeight;
	}

    if(m_pDevice == NULL || m_pSwapChain == NULL)
    {
        return FALSE;
    }

	hResult = m_pSwapChain->GetBackBuffer(0, D3DBACKBUFFER_TYPE_MONO, &pSurf);
	if(hResult != S_OK) return FALSE;

	hResult = pSurf->LockRect(&lr, NULL, D3DLOCK_NOSYSLOCK );
	if(hResult != S_OK) return FALSE;
	
	int nFrameLen = nWidth * nHeight * 4;
	
	int nSrcStride = nWidth * 4;
	int nDscStride = lr.Pitch;
			
	for(int nScanLine = 0, nScanSrc = 0, nScanDsc = 0; nScanLine < nHeight; nScanLine++, nScanSrc +=  nSrcStride, nScanDsc += nDscStride)
	{
		char* pDsc = (char*) lr.pBits;

		::memcpy(&pDsc[nScanDsc], &pFrameRGB[nScanSrc], nSrcStride);
	}

	pSurf->UnlockRect();
	
	RECT rcDest;

    hResult = m_pDevice->GetBackBuffer(0, 0, D3DBACKBUFFER_TYPE_MONO, &pBB);
    //hResult = m_pDevice->ColorFill(pBB, NULL, D3DCOLOR_XRGB(0, 0, 0x80));
    hResult = m_pDevice->StretchRect(pSurf, NULL, pBB, NULL, D3DTEXF_LINEAR);

    hResult = m_pDevice->Present(NULL, NULL, NULL, NULL);

	return TRUE;
}

void CDrawFrame::CloseDevice()
{
	DestroySwapChain();
	
	if(m_pDevice)
	{
		m_pDevice->Release();
		m_pDevice = NULL;
	}

	if(m_pD3D)
	{
		m_pD3D->Release();
		m_pD3D = NULL;
	}
}

void CDrawFrame::DestroySwapChain()
{
	if(m_pSwapChain)
	{
		m_pSwapChain->Release();
		m_pSwapChain = NULL;

		m_nSwapChainWidth = 0;
		m_nSwapChainHeight = 0;
	}
}