#include "stdafx.h"
#include "StoreRegistry.h"
#include "StoreRoom.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

#define ROOM_ROOT_PATH	"Rooms\\"

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

BOOL CStoreRoom::AddRoom(LPCTSTR sRoomName, LPCTSTR sRoomNo)
{
	CString sKeyPath;
	sKeyPath.Format("%s%s", ROOM_ROOT_PATH, sRoomName);

	CStoreRegistry objStore;
	objStore.SetTEXT(sKeyPath, "RoomNo", sRoomNo);

	return TRUE;
}

void CStoreRoom::GetRoom(LPCTSTR sRoomName, CString& sRoomNo)
{
	CString sKeyPath;
	sKeyPath.Format("%s%s", ROOM_ROOT_PATH, sRoomName);

	CStoreRegistry objStore;
	objStore.GetTEXT(sKeyPath, "RoomNo", sRoomNo, "");
}

void CStoreRoom::RemoveRoom(LPCTSTR sRoomName)
{
	CString sKeyPath;
	sKeyPath.Format("%s%s", ROOM_ROOT_PATH, sRoomName);

	CStoreRegistry objStore;
	objStore.DeleteSubKey(sRoomName);
}

//////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

void CStoreRoom::GetRoomNameAll(CStringList& objList)
{
	objList.RemoveAll();

	CString sKeyPath;
	sKeyPath =  ROOM_ROOT_PATH;

	CStoreRegistry objStore;
	objStore.EnumSubKeys(sKeyPath, objList);
}

BOOL CStoreRoom::IsDataStored()
{
	CStoreRegistry objStore;
	return objStore.IsKeyExist(ROOM_ROOT_PATH);
}



