#include "StdAfx.h"
#include "StoreRegistry.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define SUB_KEY_BUFFER_SIZE		2048
#define ROOT_KEY_PATH			"Software\\VaxPhoneSDKv6"


CStoreRegistry::CStoreRegistry()
{
	Open();
}

CStoreRegistry::~CStoreRegistry()
{
	Close();
}

///////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////

BOOL CStoreRegistry::Open()
{
	if(::RegCreateKeyEx(HKEY_CURRENT_USER, ROOT_KEY_PATH, 0, NULL, 0, KEY_ALL_ACCESS, NULL, &m_hKey, NULL) != ERROR_SUCCESS)
	{
		m_hKey = NULL;
		return FALSE;
	}
	
	return TRUE;
}

void CStoreRegistry::Close()
{
	if(m_hKey == NULL)
		return;
	
	::RegCloseKey(m_hKey);
	m_hKey = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

HKEY CStoreRegistry::CreateKey(CString sKeyName)
{
	if(m_hKey == NULL)
		return FALSE;

	if(sKeyName.IsEmpty())
		return NULL;

	HKEY hKeySub = NULL;
	if(::RegCreateKeyEx(m_hKey, sKeyName, 0, NULL, 0, KEY_ALL_ACCESS, NULL, &hKeySub, NULL) != ERROR_SUCCESS)
		return NULL;

	return hKeySub;
}

HKEY CStoreRegistry::OpenKey(CString sKeyName)
{
	if(m_hKey == NULL)
		return FALSE;

	if(sKeyName.IsEmpty())
		return NULL;

	HKEY hKeySub = NULL;
	if(::RegOpenKeyEx(m_hKey, sKeyName, 0, KEY_ALL_ACCESS, &hKeySub) != ERROR_SUCCESS)
		return FALSE;

	return hKeySub;
}

////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////

BOOL CStoreRegistry::SetTEXT(LPCTSTR sKeyName, LPCTSTR sValueName, LPCTSTR sValueData)
{
	HKEY hKey = CreateKey(sKeyName);
	if(hKey == NULL)	return FALSE;

	if(::RegSetValueEx(hKey, sValueName, 0, REG_SZ, (BYTE*) sValueData, ::lstrlen(sValueData)) != ERROR_SUCCESS)
		return FALSE;

	return TRUE;
}

BOOL CStoreRegistry::SetINT(LPCTSTR sKeyName, LPCTSTR sValueName, int nValueData)
{
	HKEY hKey = CreateKey(sKeyName);
    if(hKey == NULL) return FALSE;

	if(::RegSetValueEx(hKey, sValueName, 0, REG_DWORD, (const BYTE*) &nValueData, sizeof(nValueData)))
		return FALSE;

	return TRUE;	
}

BOOL CStoreRegistry::SetBOOL(LPCTSTR sKeyName, LPCTSTR sValueName, BOOL bValueData)
{
	LONG nValueData = 0;
	if(bValueData == TRUE)	nValueData = 1;

	if(!SetINT(sKeyName, sValueName, nValueData))
		return FALSE;

	return TRUE;
}

void CStoreRegistry::GetTEXT(LPCTSTR sKeyName, LPCTSTR sValueName, CString& sValueData, LPCTSTR sValueDefault)
{
	HKEY hKey = OpenKey(sKeyName);
    
	if(hKey == NULL)
	{
		sValueData = sValueDefault;
		return;
	}
	
	char arrBuffer[SUB_KEY_BUFFER_SIZE] = "\0";
	DWORD dwCount = SUB_KEY_BUFFER_SIZE;

	if(::RegQueryValueEx(hKey, sValueName, NULL, NULL, (BYTE*)arrBuffer, &dwCount) != ERROR_SUCCESS)
	{
		sValueData = sValueDefault;
		return;
	}

	sValueData = arrBuffer;
}

void CStoreRegistry::GetINT(LPCTSTR sKeyName, LPCTSTR sValueName, int& nValueData, int nValueDefault)
{
   HKEY hKey = OpenKey(sKeyName);

	if(hKey == NULL)
	{
		nValueData = nValueDefault;
		return;
	}
	
	char arrBuffer[SUB_KEY_BUFFER_SIZE] = "\0";
	DWORD dwCount = SUB_KEY_BUFFER_SIZE;

	if(::RegQueryValueEx(hKey, sValueName, NULL, NULL, (BYTE*)arrBuffer, &dwCount) != ERROR_SUCCESS)
	{
		nValueData = nValueDefault;
		return;
	}

    nValueData = *((LONG*) arrBuffer);
}

void CStoreRegistry::GetBOOL(LPCTSTR sKeyName, LPCTSTR sValueName, BOOL& bValueData, BOOL bValueDefault)
{
	int nValueData = 0;
	int nValueDefault = bValueDefault ? 1 : 0;

	GetINT(sKeyName, sValueName, nValueData, nValueDefault);
		
	if(nValueData == 1)
		bValueData = TRUE;
	else
		bValueData = FALSE;
}

BOOL CStoreRegistry::DeleteSubKey(LPCTSTR sKeyName)
{
	if(CString(sKeyName).IsEmpty())
		return FALSE;

	::RegDeleteTree(m_hKey, sKeyName);
	return TRUE;
}

BOOL CStoreRegistry::EnumSubKeys(LPCTSTR sKeyRootName, CStringList& objList)
{
	objList.RemoveAll();

	HKEY hKey = OpenKey(sKeyRootName);

	if(hKey == NULL)
		return FALSE;
		 
	char arraySubKey[SUB_KEY_BUFFER_SIZE] = "\0";
	DWORD dwSize = SUB_KEY_BUFFER_SIZE;

	for(LONG nCount = 0;;nCount++)
	{
		if(::RegEnumKeyEx(hKey, nCount, arraySubKey, &dwSize, 0, NULL, NULL, NULL)  != ERROR_SUCCESS)
			break;
		
		objList.AddTail(arraySubKey);

		::memset(arraySubKey, 0, SUB_KEY_BUFFER_SIZE);
		dwSize = SUB_KEY_BUFFER_SIZE;
	}

	::RegCloseKey(hKey);
	
	return TRUE;
}

BOOL CStoreRegistry::DeleteValue(LPCTSTR sKeyRootName, LPCTSTR sValueName)
{
	HKEY hKey = OpenKey(sKeyRootName);

	if(hKey == NULL)
		return FALSE;

	::RegDeleteKey(hKey, sValueName);
	::RegCloseKey(hKey);

	 return TRUE;
}

BOOL CStoreRegistry::EnumValueNames(LPCTSTR sKeyRootName, CStringList& objList)
{
	objList.RemoveAll();

	HKEY hKey = OpenKey(sKeyRootName);

	if(hKey == NULL)
		return FALSE;
		 
	char arraySubKey[SUB_KEY_BUFFER_SIZE] = "\0";
	DWORD dwSize = SUB_KEY_BUFFER_SIZE;

	for(LONG nCount = 0;;nCount++)
	{
		if(::RegEnumValue(hKey, nCount, arraySubKey, &dwSize, 0, NULL, NULL, NULL)  != ERROR_SUCCESS)
			break;
		
		objList.AddTail(arraySubKey);

		::memset(arraySubKey, 0, SUB_KEY_BUFFER_SIZE);
		dwSize = SUB_KEY_BUFFER_SIZE;
	}

	::RegCloseKey(hKey);
	
	return TRUE;
}


BOOL CStoreRegistry::IsKeyExist(LPCTSTR sSubKeyName)
{
	HKEY hKey = OpenKey(sSubKeyName);

	if(hKey == NULL)
		return FALSE;

	::RegCloseKey(hKey);
	return TRUE;
}