#include "StdAfx.h"
#include "StoreRegistry.h"
#include "StoreChat.h"

#define CHAT_ROOT_PATH	"Chat\\"

BOOL CStoreChat::AddContact(LPCTSTR sContactName)
{
	if(CString(sContactName).IsEmpty())
		return FALSE;
	
	CString sKeyPath;
	sKeyPath.Format("%s%s", CHAT_ROOT_PATH, sContactName);

	CStoreRegistry objStore;

	objStore.SetTEXT(sKeyPath, "ContactName", sContactName);
	return TRUE;
}

void CStoreChat::RemoveContact(LPCTSTR sContactName)
{
	if(CString(sContactName).IsEmpty())
		return;
	
	CString sKeyPath;
	sKeyPath.Format("%s%s", CHAT_ROOT_PATH, sContactName);

	CStoreRegistry objStore;
	objStore.DeleteSubKey(sKeyPath);
}

void CStoreChat::GetContactAll(CStringList& objList)
{
	objList.RemoveAll();

	CString sKeyPath = CHAT_ROOT_PATH;
	 
	CStoreRegistry objStore;
	objStore.EnumSubKeys(sKeyPath, objList);
}

BOOL CStoreChat::AddMsg(LPCTSTR sContactName, LPCTSTR sMsgText)
{
	if(CString(sContactName).IsEmpty())
		return FALSE;
		
	CString sKeyPath;
	sKeyPath.Format("%s%s\\Messages", CHAT_ROOT_PATH, sContactName);

    CStoreRegistry objStore;

	int nMsgCount = 0;

	objStore.GetINT(sKeyPath, "MsgCount", nMsgCount, 0);
	objStore.SetINT(sKeyPath, "MsgCount", nMsgCount + 1);
	
	CString sMsgCount;
	sMsgCount.Format("%d", nMsgCount);

	objStore.SetTEXT(sKeyPath + "\\MsgText", "Msg" + sMsgCount, sMsgText);
	return TRUE;
}

void CStoreChat::RemoveMsgAll(LPCTSTR sContactName)
{
	if(CString(sContactName).IsEmpty())
		return;
	    
	CString sKeyPath;
	sKeyPath.Format("%s%s\\Messages", CHAT_ROOT_PATH, sContactName);

	CStoreRegistry objStore;
    objStore.DeleteSubKey(sKeyPath);
}

void CStoreChat::GetMsgAll(LPCTSTR sContactName, CStringList& objList)
{
	objList.RemoveAll();
	        
	CString sKeyPath;
	sKeyPath.Format("%s%s\\Messages\\MsgText", CHAT_ROOT_PATH, sContactName);

    CStoreRegistry objStore;

	CStringList objValueNameList;
	objStore.EnumValueNames(sKeyPath, objValueNameList);
        
	while(!objValueNameList.IsEmpty())
	{
		CString sMsgText;
		objStore.GetTEXT(sKeyPath, objValueNameList.RemoveHead(), sMsgText, "");

		objList.AddTail(sMsgText);
	}
}

BOOL CStoreChat::IsDataStored()
{
	CStoreRegistry objStore;
	return objStore.IsKeyExist(CHAT_ROOT_PATH);
}
