#include "StdAfx.h"
#include "StoreRegistry.h"
#include "StoreCOMM.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

#define COMM_ROOT_PATH	"COMM\\"

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

BOOL CStoreCOMM::SetListenPortSIP(LONG nListenPort)
{
	CString sKeyPath;
	sKeyPath.Format("%s", COMM_ROOT_PATH);
		
	CStoreRegistry objStore;
    objStore.SetINT(sKeyPath, "ListenPortSIP", nListenPort);

	return TRUE;	
}

LONG CStoreCOMM::GetListenPortSIP()
{
	CString sKeyPath;
	sKeyPath.Format("%s", COMM_ROOT_PATH);

	LONG nListenPort = SIP_DEFAULT_PORT;

	CStoreRegistry objStore;
	objStore.GetINT(sKeyPath, "ListenPortSIP", nListenPort, SIP_DEFAULT_PORT);

	return nListenPort;
}

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

void CStoreCOMM::SetMusicFiles(LPCTSTR sMusicHold, LPCTSTR sMusicDialTone, LPCTSTR sMusicCallPark)
{
	CString sKeyPath = COMM_ROOT_PATH;
    CStoreRegistry objStore;

    objStore.SetTEXT(sKeyPath, "MusicHold", sMusicHold);
    objStore.SetTEXT(sKeyPath, "MusicDialTone", sMusicDialTone);
    objStore.SetTEXT(sKeyPath, "MusicCallParking", sMusicCallPark);
}

void CStoreCOMM::GetMusicFiles(CString& sMusicHold, CString& sMusicDialTone, CString& sMusicCallPark)
{
	CString sKeyPath = COMM_ROOT_PATH;
    CStoreRegistry objStore;

	objStore.GetTEXT(sKeyPath, "MusicHold", sMusicHold, MUSIC_FILE_HOLD);
	objStore.GetTEXT(sKeyPath, "MusicDialTone", sMusicDialTone, MUSIC_FILE_DIAL_TONE);
	objStore.GetTEXT(sKeyPath, "MusicCallParking", sMusicCallPark, MUSIC_FILE_CALL_PARKING);
}

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

BOOL CStoreCOMM::IsDataStored()
{
	CStoreRegistry objStore;
	return objStore.IsKeyExist(COMM_ROOT_PATH);
}