#include "StdAfx.h"
#include "StoreRegistry.h"
#include "StoreBusyLamp.h"

#define BUSY_LAMP_ROOT_PATH	"BusyLamp\\"

BOOL CStoreBusyLamp::AddContact(LPCTSTR sContactName)
{
	if(CString(sContactName).IsEmpty())
		return FALSE;
	
	CString sKeyPath;
	sKeyPath.Format("%s%s", BUSY_LAMP_ROOT_PATH, sContactName);

	CStoreRegistry objStore;

	objStore.SetTEXT(sKeyPath, "ContactName", sContactName);
	return TRUE;
}

void CStoreBusyLamp::RemoveContact(LPCTSTR sContactName)
{
	if(CString(sContactName).IsEmpty())
		return;
	
	CString sKeyPath;
	sKeyPath.Format("%s%s", BUSY_LAMP_ROOT_PATH, sContactName);

	CStoreRegistry objStore;
	objStore.DeleteSubKey(sKeyPath);
}

void CStoreBusyLamp::GetContactAll(CStringList& objList)
{
	objList.RemoveAll();

	CString sKeyPath = BUSY_LAMP_ROOT_PATH;
	 
	CStoreRegistry objStore;
	objStore.EnumSubKeys(sKeyPath, objList);
}

BOOL CStoreBusyLamp::IsDataStored()
{
	CStoreRegistry objStore;
	return objStore.IsKeyExist(BUSY_LAMP_ROOT_PATH);
}
