#include "StdAfx.h"
#include "StoreRegistry.h"
#include "StoreAccountREC.h"

#define ROOT_PATH	"AccountInfoREC\\"

BOOL CStoreAccountREC::AddAccountInfo(LPCTSTR sDisplayName, LPCTSTR sUserName, LPCTSTR sAuthLogin, LPCTSTR sAuthPwd, LPCTSTR sDomainRealm, LPCTSTR sServerAddr, int nServerPort, BOOL bRegSIP)
{
	CString sKeyPath;
	sKeyPath.Format("%s%s", ROOT_PATH, sUserName);

	CStoreRegistry objStore;

	objStore.SetTEXT(sKeyPath, "VaxDisplayName", sDisplayName);
	objStore.SetTEXT(sKeyPath, "VaxUserName", sUserName);

	objStore.SetTEXT(sKeyPath, "VaxAuthLogin", sAuthLogin);
	objStore.SetTEXT(sKeyPath, "VaxAuthPassword", sAuthPwd);

	objStore.SetTEXT(sKeyPath, "VaxDomainRealm", sDomainRealm);
	objStore.SetTEXT(sKeyPath, "VaxServerAddr", sServerAddr);
	objStore.SetINT(sKeyPath, "VaxServerPort", nServerPort);
		
	objStore.SetBOOL(sKeyPath, "VaxRegisterSIP", bRegSIP);
		
	return TRUE;
}

BOOL CStoreAccountREC::GetAccountInfo(CString& sDisplayName, CString& sUserName, CString& sAuthLogin, CString& sAuthPwd, CString& sDomainRealm, CString& sServerAddr, int& nServerPort, BOOL& bRegSIP)
{
	CString sKeyPath;
	sKeyPath.Format("%s%s", ROOT_PATH, sUserName);

	CStoreRegistry objStore;

	objStore.GetTEXT(sKeyPath, "VaxDisplayName", sDisplayName, "");
	objStore.GetTEXT(sKeyPath, "VaxUserName", sUserName, "");

	objStore.GetTEXT(sKeyPath, "VaxAuthLogin", sAuthLogin, "");
	objStore.GetTEXT(sKeyPath, "VaxAuthPassword", sAuthPwd, "");

	objStore.GetTEXT(sKeyPath, "VaxDomainRealm", sDomainRealm, "");
	objStore.GetTEXT(sKeyPath, "VaxServerAddr", sServerAddr, "");
	objStore.GetINT(sKeyPath, "VaxServerPort", nServerPort, 5060);
		
	objStore.GetBOOL(sKeyPath, "VaxRegisterSIP", bRegSIP, TRUE);
		
	return TRUE;
}