// VaxSIPUserAgent.h: interface for the CVaxVoIP class.
//
//////////////////////////////////////////////////////////////////////

#pragma once

#pragma comment(lib, "D3d9.lib")

#if defined(_DEBUG)
	#pragma comment(lib, "./VaxSIPUserAgentLib/Debug/VaxSIPUserAgentDLL.lib")
#else
	#pragma comment(lib, "./VaxSIPUserAgentLib/Release/VaxSIPUserAgentDLL.lib")
#endif

#include "./VaxSIPUserAgentLib/VaxSIPUserAgentLib.h"

#define VAX_TOTAL_NO_LINES 8

#define VAX_ACCOUNT_NAME_PHONE "VaxVoIP-PHONE"
#define VAX_ACCOUNT_NAME_REC "VaxVoIP-REC"

class CVaxVoIPDlg;

class CVaxSIPUserAgentLibEx : public CVaxSIPUserAgentLib  
{

public:

	CVaxSIPUserAgentLibEx(CVaxVoIPDlg* pMianDlg);
	~CVaxSIPUserAgentLibEx();

public:

	CVaxVoIPDlg* m_pMainDlg;

private:

	BOOL m_bCaptureSoundDevice;
	int m_nTypeDTMF;

	BOOL m_bEnableREC;
	BOOL m_bBoostMic;
	BOOL m_bDetectAMD;
	
	int m_nActiveAudioInDeviceId;
	int m_nActiveAudioOutDeviceId;

	CStringList m_objDontShowErrorMsg;
		
public:	

	BOOL Initialize(LPCTSTR sDisplayName, LPCTSTR sUserName, LPCTSTR sAuthLogin, LPCTSTR sAuthPwd, LPCTSTR sDomainRealm, LPCTSTR sServerAddr, int nServerPort, int nServerType, BOOL bRegisterSIP, BOOL bCaptureSoundDevice);
	void UnInitialize();
	
	BOOL RegisterAccountREC(BOOL bRegister, LPCTSTR sDisplayName, LPCTSTR sUserName, LPCTSTR sAuthLogin, LPCTSTR sAuthPwd, LPCTSTR sDomainRealm, LPCTSTR sServerAddr, int nServerPort);
	BOOL UnRegisterAccountREC();

	void SetActiveAudioInDevice(int nAoudioInDevice);
	void SetActiveAudioOutDevice(int nAoudioOutDevice);
		
	int GetTotalLine();
	
private:

	void OnStatusMsgREC(int nLineNo);
	BOOL DialCallToREC(int nLineNo);

public:

	BOOL DialCall(int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo);
	BOOL AcceptCall(int nLineNo, LPCTSTR sCallId);
		
	BOOL IsVolumeBoostMic();
	BOOL SetVolumeBoostMic(BOOL bEnable);
	
	BOOL DigitDTMF(int nLineNo, LPCTSTR sDigit);
	void ForceDigitDTMF(int nTypeDTMF);

	CString GetVoiceCodecName(int nCodecNo);
	int GetOutboundCodec(int nLineNo);
	int GetInboundCodec(int nLineNo);
		
	void DialRingEnable();
	void BusyRingEnable();
		
	//////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////

    BOOL ChatAddContact(LPCTSTR sUserName);
    BOOL ChatRemoveContact(LPCTSTR sUserName);
    BOOL ChatSetMyStatus(int nStatusId);
    
    BOOL ChatSendMessageText(LPCTSTR sUserName, LPCTSTR sMsgText);
    BOOL ChatSendMessageTyping(LPCTSTR sUserName);

	//////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////

	BOOL BusyLampAddContact(LPCTSTR sUserName);
	BOOL BusyLampRemoveContact(LPCTSTR sUserName);
    
    //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////

    BOOL RegisterAccountSIP(int nExpire);
    BOOL AutoRegistration(BOOL bEnable, int nTickCountLimit, int nTickSeconds);
    BOOL EnableKeepAlive(int nSeconds);

public:

	BOOL m_bActivateVideoDevice;
	BOOL m_nVideoDeviceId;
	BOOL m_nVideoQuality;

private:

	void CaptureVideoDevice();

public:

	void SetActiveVideoDevice(int nDeviceId);
	void ActivateVideoDevice(BOOL bActivate);
	void SetVideoQuality(int nQuality);

	void DetectAMD(BOOL bEnable);

private:

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////
	
	void OnVaxOnline();
	void OnVaxOffline();

	void OnConnectingToRegister(LPCTSTR sAccountName);
	void OnTryingToRegister(LPCTSTR sAccountName);

	void OnFailToRegister(LPCTSTR sAccountName, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToRegister(LPCTSTR sAccountName);

	void OnConnectingToReRegister(LPCTSTR sAccountName);
	void OnTryingToReRegister(LPCTSTR sAccountName);

	void OnFailToReRegister(LPCTSTR sAccountName, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnSuccessToReRegister(LPCTSTR sAccountName);

	void OnTryingToUnRegister(LPCTSTR sAccountName);
	void OnFailToUnRegister(LPCTSTR sAccountName);
	void OnSuccessToUnRegister(LPCTSTR sAccountName);

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////

	void OnDialCallStarted(LPCTSTR sAccountName, int nLineNo, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo);
	void OnDialingCall(LPCTSTR sAccountName, int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnDialCallFailed(LPCTSTR sAccountName, int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sContact);

	void OnConnectedCall(LPCTSTR sAccountName, int nLineNo, LPCTSTR sToRTPIP, int nToRTPPort);
	void OnHungupCall(LPCTSTR sAccountName, int nLineNo);

	void OnIncomingCallStarted(LPCTSTR sAccountName, LPCTSTR sCallId, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo, LPCTSTR sFromURI, LPCTSTR sToURI);
	void OnIncomingCallEnded(LPCTSTR sAccountName, LPCTSTR sCallId, int nReasonCode);;

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////

	void OnTransferCallFailed(LPCTSTR sAccountName, int nLineNo, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnTransferCallAccepted(LPCTSTR sAccountName, int nLineNo);

	void OnPlayWaveDone(LPCTSTR sAccountName, int nLineNo);
	void OnDigitDTMF(LPCTSTR sAccountName, int nLineNo, LPCTSTR sDigit);

	void OnMsgNOTIFY(LPCTSTR sAccountName, LPCTSTR sMsg);
	void OnVoiceMailMsg(LPCTSTR sAccountName, BOOL bIsMsgWaiting, int nNewMsgCount, int nOldMsgCount, int nNewUrgentMsgCount, int nOldUrgentMsgCount, LPCTSTR sMsgAccount);

	void OnRingToneStarted(LPCTSTR sAccountName, LPCTSTR sCallId);
	void OnRingToneEnded(LPCTSTR sAccountName, LPCTSTR sCallId);

	void OnIncomingDiagnostic(LPCTSTR sAccountName, LPCTSTR sMsgSIP, LPCTSTR sFromIP, int nFromPort);
	void OnOutgoingDiagnostic(LPCTSTR sAccountName, LPCTSTR sMsgSIP, LPCTSTR sToIP, int nToPort);

	void OnAudioSessionLost(LPCTSTR sAccountName, int nLineNo);

	void OnSuccessToHold(LPCTSTR sAccountName, int nLineNo);
	void OnTryingToHold(LPCTSTR sAccountName, int nLineNo);
	void OnFailToHold(LPCTSTR sAccountName, int nLineNo);

	void OnSuccessToUnHold(LPCTSTR sAccountName, int nLineNo);
	void OnTryingToUnHold(LPCTSTR sAccountName, int nLineNo);
	void OnFailToUnHold(LPCTSTR sAccountName, int nLineNo);

	void OnChatSubscribeSuccess(LPCTSTR sAccountName, LPCTSTR sUserName);
	void OnChatSubscribeFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase);

	void OnChatContactStatus(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusId);

	void OnChatSendMsgTextSuccess(LPCTSTR sAccountName, LPCTSTR sUserName, LPCTSTR sMsgText, UINT64 nUserValue);
	void OnChatSendMsgTextFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sMsgText, UINT64 nUserValue);

	void OnChatSendMsgTypingSuccess(LPCTSTR sAccountName, LPCTSTR sUserName, UINT64 nUserValue);
	void OnChatSendMsgTypingFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase, UINT64 nUserValue);

	void OnChatRecvMsgText(LPCTSTR sAccountName, LPCTSTR sUserName, LPCTSTR sMsgText, BOOL bIsChatContact);
	void OnChatRecvMsgTypingStart(LPCTSTR sAccountName, LPCTSTR sUserName);
	void OnChatRecvMsgTypingStop(LPCTSTR sAccountName, LPCTSTR sUserName);

	void OnBusyLampSubscribeSuccess(LPCTSTR sAccountName, LPCTSTR sUserName);
	void OnBusyLampSubscribeFailed(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusCode, LPCTSTR sReasonPhrase);
	void OnBusyLampContactStatus(LPCTSTR sAccountName, LPCTSTR sUserName, int nStatusId);

	void OnAudioRecordedPCM(LPCTSTR sAccountName, int nLineNo, char* pDataPCM, int nSizePCM, int nTypePCM);
	void OnDetectedAMD(LPCTSTR sAccountName, int nLineNo, BOOL bIsHuman);

	void OnHoldCall(LPCTSTR sAccountName, int nLineNo);
	void OnUnHoldCall(LPCTSTR sAccountName, int nLineNo);

	void OnVideoRemoteStarted(LPCTSTR sAccountName, int nLineNo);
	void OnVideoRemoteEnded(LPCTSTR sAccountName, int nLineNo);

	void OnVideoDeviceFrameRGB(int nDeviceId, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight);
	void OnVideoRemoteFrameRGB(LPCTSTR sAccountName, int nLineNo, BYTE* pFrameRGB, int nFrameSize, int nFrameWidth, int nFrameHeight);
		
	void OnAddCallHistory(LPCTSTR sAccountName, BOOL bOutboundCallType, LPCTSTR sCallerName, LPCTSTR sCallerId, LPCTSTR sDialNo, UINT64 nStartTime, UINT64 nEndTime, UINT64 nDuration, UINT64 nDayNo, int nHistoryTypeId);
	void OnNetworkReachability(BOOL bAvailable);

	void OnAudioDeviceMicVU(int nLevelVU);
	void OnAudioDeviceSpkVU(int nLevelVU);
		
	void OnVaxErrorMsg(LPCTSTR sFuncName, LPCTSTR sErrorMsg, int nErrorCode);
};

